/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagementGroupTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment#id DataAzurermManagementGroupTemplateDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment#management_group_id DataAzurermManagementGroupTemplateDeployment#management_group_id}
    */
    readonly managementGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment#name DataAzurermManagementGroupTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment#timeouts DataAzurermManagementGroupTemplateDeployment#timeouts}
    */
    readonly timeouts?: DataAzurermManagementGroupTemplateDeploymentTimeouts;
}
export interface DataAzurermManagementGroupTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment#read DataAzurermManagementGroupTemplateDeployment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagementGroupTemplateDeploymentTimeoutsToTerraform(struct?: DataAzurermManagementGroupTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagementGroupTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermManagementGroupTemplateDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermManagementGroupTemplateDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment azurerm_management_group_template_deployment}
*/
export declare class DataAzurermManagementGroupTemplateDeployment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_management_group_template_deployment";
    /**
    * Generates CDKTF code for importing a DataAzurermManagementGroupTemplateDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermManagementGroupTemplateDeployment to import
    * @param importFromId The id of the existing DataAzurermManagementGroupTemplateDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermManagementGroupTemplateDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/management_group_template_deployment azurerm_management_group_template_deployment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagementGroupTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermManagementGroupTemplateDeploymentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    get managementGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _timeouts;
    get timeouts(): DataAzurermManagementGroupTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagementGroupTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermManagementGroupTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
