/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMariadbServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server#id DataAzurermMariadbServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server#name DataAzurermMariadbServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server#resource_group_name DataAzurermMariadbServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server#timeouts DataAzurermMariadbServer#timeouts}
    */
    readonly timeouts?: DataAzurermMariadbServerTimeouts;
}
export interface DataAzurermMariadbServerStorageProfile {
}
export declare function dataAzurermMariadbServerStorageProfileToTerraform(struct?: DataAzurermMariadbServerStorageProfile): any;
export declare class DataAzurermMariadbServerStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMariadbServerStorageProfile | undefined;
    set internalValue(value: DataAzurermMariadbServerStorageProfile | undefined);
    get autoGrow(): string;
    get backupRetentionDays(): number;
    get geoRedundantBackup(): string;
    get storageMb(): number;
}
export declare class DataAzurermMariadbServerStorageProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMariadbServerStorageProfileOutputReference;
}
export interface DataAzurermMariadbServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server#read DataAzurermMariadbServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMariadbServerTimeoutsToTerraform(struct?: DataAzurermMariadbServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMariadbServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMariadbServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMariadbServerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server azurerm_mariadb_server}
*/
export declare class DataAzurermMariadbServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mariadb_server";
    /**
    * Generates CDKTF code for importing a DataAzurermMariadbServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMariadbServer to import
    * @param importFromId The id of the existing DataAzurermMariadbServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMariadbServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/mariadb_server azurerm_mariadb_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMariadbServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMariadbServerConfig);
    get administratorLogin(): string;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get sslEnforcement(): string;
    private _storageProfile;
    get storageProfile(): DataAzurermMariadbServerStorageProfileList;
    private _tags;
    get tags(): cdktf.StringMap;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermMariadbServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMariadbServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMariadbServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
