/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkServiceTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#id DataAzurermNetworkServiceTags#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#location DataAzurermNetworkServiceTags#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#location_filter DataAzurermNetworkServiceTags#location_filter}
    */
    readonly locationFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#service DataAzurermNetworkServiceTags#service}
    */
    readonly service: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#timeouts DataAzurermNetworkServiceTags#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkServiceTagsTimeouts;
}
export interface DataAzurermNetworkServiceTagsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#read DataAzurermNetworkServiceTags#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkServiceTagsTimeoutsToTerraform(struct?: DataAzurermNetworkServiceTagsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkServiceTagsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkServiceTagsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkServiceTagsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags azurerm_network_service_tags}
*/
export declare class DataAzurermNetworkServiceTags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_service_tags";
    /**
    * Generates CDKTF code for importing a DataAzurermNetworkServiceTags resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetworkServiceTags to import
    * @param importFromId The id of the existing DataAzurermNetworkServiceTags that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetworkServiceTags to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/network_service_tags azurerm_network_service_tags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkServiceTagsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkServiceTagsConfig);
    get addressPrefixes(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipv4Cidrs(): string[];
    get ipv6Cidrs(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _locationFilter?;
    get locationFilter(): string;
    set locationFilter(value: string);
    resetLocationFilter(): void;
    get locationFilterInput(): string | undefined;
    get name(): string;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNetworkServiceTagsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkServiceTagsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkServiceTagsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
