/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot#id DataAzurermSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot#name DataAzurermSnapshot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot#resource_group_name DataAzurermSnapshot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot#timeouts DataAzurermSnapshot#timeouts}
    */
    readonly timeouts?: DataAzurermSnapshotTimeouts;
}
export interface DataAzurermSnapshotEncryptionSettingsDiskEncryptionKey {
}
export declare function dataAzurermSnapshotEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: DataAzurermSnapshotEncryptionSettingsDiskEncryptionKey): any;
export declare class DataAzurermSnapshotEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSnapshotEncryptionSettingsDiskEncryptionKey | undefined;
    set internalValue(value: DataAzurermSnapshotEncryptionSettingsDiskEncryptionKey | undefined);
    get secretUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermSnapshotEncryptionSettingsDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSnapshotEncryptionSettingsDiskEncryptionKeyOutputReference;
}
export interface DataAzurermSnapshotEncryptionSettingsKeyEncryptionKey {
}
export declare function dataAzurermSnapshotEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: DataAzurermSnapshotEncryptionSettingsKeyEncryptionKey): any;
export declare class DataAzurermSnapshotEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSnapshotEncryptionSettingsKeyEncryptionKey | undefined;
    set internalValue(value: DataAzurermSnapshotEncryptionSettingsKeyEncryptionKey | undefined);
    get keyUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermSnapshotEncryptionSettingsKeyEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSnapshotEncryptionSettingsKeyEncryptionKeyOutputReference;
}
export interface DataAzurermSnapshotEncryptionSettings {
}
export declare function dataAzurermSnapshotEncryptionSettingsToTerraform(struct?: DataAzurermSnapshotEncryptionSettings): any;
export declare class DataAzurermSnapshotEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSnapshotEncryptionSettings | undefined;
    set internalValue(value: DataAzurermSnapshotEncryptionSettings | undefined);
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataAzurermSnapshotEncryptionSettingsDiskEncryptionKeyList;
    get enabled(): cdktf.IResolvable;
    private _keyEncryptionKey;
    get keyEncryptionKey(): DataAzurermSnapshotEncryptionSettingsKeyEncryptionKeyList;
}
export declare class DataAzurermSnapshotEncryptionSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSnapshotEncryptionSettingsOutputReference;
}
export interface DataAzurermSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot#read DataAzurermSnapshot#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSnapshotTimeoutsToTerraform(struct?: DataAzurermSnapshotTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSnapshotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSnapshotTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot azurerm_snapshot}
*/
export declare class DataAzurermSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_snapshot";
    /**
    * Generates CDKTF code for importing a DataAzurermSnapshot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSnapshot to import
    * @param importFromId The id of the existing DataAzurermSnapshot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSnapshot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/snapshot azurerm_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSnapshotConfig);
    get creationOption(): string;
    get diskSizeGb(): number;
    private _encryptionSettings;
    get encryptionSettings(): DataAzurermSnapshotEncryptionSettingsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get timeCreated(): string;
    get trustedLaunchEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSnapshotTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
