/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermWebPubsubPrivateLinkResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource#id DataAzurermWebPubsubPrivateLinkResource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource#web_pubsub_id DataAzurermWebPubsubPrivateLinkResource#web_pubsub_id}
    */
    readonly webPubsubId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource#timeouts DataAzurermWebPubsubPrivateLinkResource#timeouts}
    */
    readonly timeouts?: DataAzurermWebPubsubPrivateLinkResourceTimeouts;
}
export interface DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypes {
}
export declare function dataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypesToTerraform(struct?: DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypes): any;
export declare class DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypes | undefined;
    set internalValue(value: DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypes | undefined);
    get description(): string;
    get subresourceName(): string;
}
export declare class DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypesOutputReference;
}
export interface DataAzurermWebPubsubPrivateLinkResourceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource#read DataAzurermWebPubsubPrivateLinkResource#read}
    */
    readonly read?: string;
}
export declare function dataAzurermWebPubsubPrivateLinkResourceTimeoutsToTerraform(struct?: DataAzurermWebPubsubPrivateLinkResourceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermWebPubsubPrivateLinkResourceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermWebPubsubPrivateLinkResourceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermWebPubsubPrivateLinkResourceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource azurerm_web_pubsub_private_link_resource}
*/
export declare class DataAzurermWebPubsubPrivateLinkResource extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_web_pubsub_private_link_resource";
    /**
    * Generates CDKTF code for importing a DataAzurermWebPubsubPrivateLinkResource resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermWebPubsubPrivateLinkResource to import
    * @param importFromId The id of the existing DataAzurermWebPubsubPrivateLinkResource that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermWebPubsubPrivateLinkResource to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/web_pubsub_private_link_resource azurerm_web_pubsub_private_link_resource} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermWebPubsubPrivateLinkResourceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermWebPubsubPrivateLinkResourceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sharedPrivateLinkResourceTypes;
    get sharedPrivateLinkResourceTypes(): DataAzurermWebPubsubPrivateLinkResourceSharedPrivateLinkResourceTypesList;
    private _webPubsubId?;
    get webPubsubId(): string;
    set webPubsubId(value: string);
    get webPubsubIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermWebPubsubPrivateLinkResourceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermWebPubsubPrivateLinkResourceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermWebPubsubPrivateLinkResourceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
