/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataboxEdgeOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#device_name DataboxEdgeOrder#device_name}
    */
    readonly deviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#id DataboxEdgeOrder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#resource_group_name DataboxEdgeOrder#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * contact block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#contact DataboxEdgeOrder#contact}
    */
    readonly contact: DataboxEdgeOrderContact;
    /**
    * shipment_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#shipment_address DataboxEdgeOrder#shipment_address}
    */
    readonly shipmentAddress: DataboxEdgeOrderShipmentAddress;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#timeouts DataboxEdgeOrder#timeouts}
    */
    readonly timeouts?: DataboxEdgeOrderTimeouts;
}
export interface DataboxEdgeOrderReturnTracking {
}
export declare function databoxEdgeOrderReturnTrackingToTerraform(struct?: DataboxEdgeOrderReturnTracking): any;
export declare class DataboxEdgeOrderReturnTrackingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataboxEdgeOrderReturnTracking | undefined;
    set internalValue(value: DataboxEdgeOrderReturnTracking | undefined);
    get carrierName(): string;
    get serialNumber(): string;
    get trackingId(): string;
    get trackingUrl(): string;
}
export declare class DataboxEdgeOrderReturnTrackingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataboxEdgeOrderReturnTrackingOutputReference;
}
export interface DataboxEdgeOrderShipmentHistory {
}
export declare function databoxEdgeOrderShipmentHistoryToTerraform(struct?: DataboxEdgeOrderShipmentHistory): any;
export declare class DataboxEdgeOrderShipmentHistoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataboxEdgeOrderShipmentHistory | undefined;
    set internalValue(value: DataboxEdgeOrderShipmentHistory | undefined);
    private _additionalDetails;
    get additionalDetails(): cdktf.StringMap;
    get comments(): string;
    get lastUpdate(): string;
}
export declare class DataboxEdgeOrderShipmentHistoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataboxEdgeOrderShipmentHistoryOutputReference;
}
export interface DataboxEdgeOrderShipmentTracking {
}
export declare function databoxEdgeOrderShipmentTrackingToTerraform(struct?: DataboxEdgeOrderShipmentTracking): any;
export declare class DataboxEdgeOrderShipmentTrackingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataboxEdgeOrderShipmentTracking | undefined;
    set internalValue(value: DataboxEdgeOrderShipmentTracking | undefined);
    get carrierName(): string;
    get serialNumber(): string;
    get trackingId(): string;
    get trackingUrl(): string;
}
export declare class DataboxEdgeOrderShipmentTrackingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataboxEdgeOrderShipmentTrackingOutputReference;
}
export interface DataboxEdgeOrderStatus {
}
export declare function databoxEdgeOrderStatusToTerraform(struct?: DataboxEdgeOrderStatus): any;
export declare class DataboxEdgeOrderStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataboxEdgeOrderStatus | undefined;
    set internalValue(value: DataboxEdgeOrderStatus | undefined);
    private _additionalDetails;
    get additionalDetails(): cdktf.StringMap;
    get comments(): string;
    get info(): string;
    get lastUpdate(): string;
}
export declare class DataboxEdgeOrderStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataboxEdgeOrderStatusOutputReference;
}
export interface DataboxEdgeOrderContact {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#company_name DataboxEdgeOrder#company_name}
    */
    readonly companyName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#emails DataboxEdgeOrder#emails}
    */
    readonly emails: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#name DataboxEdgeOrder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#phone_number DataboxEdgeOrder#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function databoxEdgeOrderContactToTerraform(struct?: DataboxEdgeOrderContactOutputReference | DataboxEdgeOrderContact): any;
export declare class DataboxEdgeOrderContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataboxEdgeOrderContact | undefined;
    set internalValue(value: DataboxEdgeOrderContact | undefined);
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    get companyNameInput(): string | undefined;
    private _emails?;
    get emails(): string[];
    set emails(value: string[]);
    get emailsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface DataboxEdgeOrderShipmentAddress {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#address DataboxEdgeOrder#address}
    */
    readonly address: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#city DataboxEdgeOrder#city}
    */
    readonly city: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#country DataboxEdgeOrder#country}
    */
    readonly country: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#postal_code DataboxEdgeOrder#postal_code}
    */
    readonly postalCode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#state DataboxEdgeOrder#state}
    */
    readonly state: string;
}
export declare function databoxEdgeOrderShipmentAddressToTerraform(struct?: DataboxEdgeOrderShipmentAddressOutputReference | DataboxEdgeOrderShipmentAddress): any;
export declare class DataboxEdgeOrderShipmentAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataboxEdgeOrderShipmentAddress | undefined;
    set internalValue(value: DataboxEdgeOrderShipmentAddress | undefined);
    private _address?;
    get address(): string[];
    set address(value: string[]);
    get addressInput(): string[] | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    get cityInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    get countryInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    get postalCodeInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface DataboxEdgeOrderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#create DataboxEdgeOrder#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#delete DataboxEdgeOrder#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#read DataboxEdgeOrder#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#update DataboxEdgeOrder#update}
    */
    readonly update?: string;
}
export declare function databoxEdgeOrderTimeoutsToTerraform(struct?: DataboxEdgeOrderTimeouts | cdktf.IResolvable): any;
export declare class DataboxEdgeOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataboxEdgeOrderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataboxEdgeOrderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order azurerm_databox_edge_order}
*/
export declare class DataboxEdgeOrder extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_databox_edge_order";
    /**
    * Generates CDKTF code for importing a DataboxEdgeOrder resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataboxEdgeOrder to import
    * @param importFromId The id of the existing DataboxEdgeOrder that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataboxEdgeOrder to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/databox_edge_order azurerm_databox_edge_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataboxEdgeOrderConfig
    */
    constructor(scope: Construct, id: string, config: DataboxEdgeOrderConfig);
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _returnTracking;
    get returnTracking(): DataboxEdgeOrderReturnTrackingList;
    get serialNumber(): string;
    private _shipmentHistory;
    get shipmentHistory(): DataboxEdgeOrderShipmentHistoryList;
    private _shipmentTracking;
    get shipmentTracking(): DataboxEdgeOrderShipmentTrackingList;
    private _status;
    get status(): DataboxEdgeOrderStatusList;
    private _contact;
    get contact(): DataboxEdgeOrderContactOutputReference;
    putContact(value: DataboxEdgeOrderContact): void;
    get contactInput(): DataboxEdgeOrderContact | undefined;
    private _shipmentAddress;
    get shipmentAddress(): DataboxEdgeOrderShipmentAddressOutputReference;
    putShipmentAddress(value: DataboxEdgeOrderShipmentAddress): void;
    get shipmentAddressInput(): DataboxEdgeOrderShipmentAddress | undefined;
    private _timeouts;
    get timeouts(): DataboxEdgeOrderTimeoutsOutputReference;
    putTimeouts(value: DataboxEdgeOrderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataboxEdgeOrderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
