/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatadogMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#id DatadogMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#location DatadogMonitor#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#monitoring_enabled DatadogMonitor#monitoring_enabled}
    */
    readonly monitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#name DatadogMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#resource_group_name DatadogMonitor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#sku_name DatadogMonitor#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#tags DatadogMonitor#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * datadog_organization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#datadog_organization DatadogMonitor#datadog_organization}
    */
    readonly datadogOrganization: DatadogMonitorDatadogOrganization;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#identity DatadogMonitor#identity}
    */
    readonly identity?: DatadogMonitorIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#timeouts DatadogMonitor#timeouts}
    */
    readonly timeouts?: DatadogMonitorTimeouts;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#user DatadogMonitor#user}
    */
    readonly user: DatadogMonitorUser;
}
export interface DatadogMonitorDatadogOrganization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#api_key DatadogMonitor#api_key}
    */
    readonly apiKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#application_key DatadogMonitor#application_key}
    */
    readonly applicationKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#enterprise_app_id DatadogMonitor#enterprise_app_id}
    */
    readonly enterpriseAppId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#linking_auth_code DatadogMonitor#linking_auth_code}
    */
    readonly linkingAuthCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#linking_client_id DatadogMonitor#linking_client_id}
    */
    readonly linkingClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#redirect_uri DatadogMonitor#redirect_uri}
    */
    readonly redirectUri?: string;
}
export declare function datadogMonitorDatadogOrganizationToTerraform(struct?: DatadogMonitorDatadogOrganizationOutputReference | DatadogMonitorDatadogOrganization): any;
export declare class DatadogMonitorDatadogOrganizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatadogMonitorDatadogOrganization | undefined;
    set internalValue(value: DatadogMonitorDatadogOrganization | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _applicationKey?;
    get applicationKey(): string;
    set applicationKey(value: string);
    get applicationKeyInput(): string | undefined;
    private _enterpriseAppId?;
    get enterpriseAppId(): string;
    set enterpriseAppId(value: string);
    resetEnterpriseAppId(): void;
    get enterpriseAppIdInput(): string | undefined;
    get id(): string;
    private _linkingAuthCode?;
    get linkingAuthCode(): string;
    set linkingAuthCode(value: string);
    resetLinkingAuthCode(): void;
    get linkingAuthCodeInput(): string | undefined;
    private _linkingClientId?;
    get linkingClientId(): string;
    set linkingClientId(value: string);
    resetLinkingClientId(): void;
    get linkingClientIdInput(): string | undefined;
    get name(): string;
    private _redirectUri?;
    get redirectUri(): string;
    set redirectUri(value: string);
    resetRedirectUri(): void;
    get redirectUriInput(): string | undefined;
}
export interface DatadogMonitorIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#type DatadogMonitor#type}
    */
    readonly type: string;
}
export declare function datadogMonitorIdentityToTerraform(struct?: DatadogMonitorIdentityOutputReference | DatadogMonitorIdentity): any;
export declare class DatadogMonitorIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatadogMonitorIdentity | undefined;
    set internalValue(value: DatadogMonitorIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DatadogMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#create DatadogMonitor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#delete DatadogMonitor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#read DatadogMonitor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#update DatadogMonitor#update}
    */
    readonly update?: string;
}
export declare function datadogMonitorTimeoutsToTerraform(struct?: DatadogMonitorTimeouts | cdktf.IResolvable): any;
export declare class DatadogMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatadogMonitorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatadogMonitorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DatadogMonitorUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#email DatadogMonitor#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#name DatadogMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#phone_number DatadogMonitor#phone_number}
    */
    readonly phoneNumber?: string;
}
export declare function datadogMonitorUserToTerraform(struct?: DatadogMonitorUserOutputReference | DatadogMonitorUser): any;
export declare class DatadogMonitorUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatadogMonitorUser | undefined;
    set internalValue(value: DatadogMonitorUser | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    resetPhoneNumber(): void;
    get phoneNumberInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor azurerm_datadog_monitor}
*/
export declare class DatadogMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_datadog_monitor";
    /**
    * Generates CDKTF code for importing a DatadogMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatadogMonitor to import
    * @param importFromId The id of the existing DatadogMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatadogMonitor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/datadog_monitor azurerm_datadog_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatadogMonitorConfig
    */
    constructor(scope: Construct, id: string, config: DatadogMonitorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get marketplaceSubscriptionStatus(): string;
    private _monitoringEnabled?;
    get monitoringEnabled(): boolean | cdktf.IResolvable;
    set monitoringEnabled(value: boolean | cdktf.IResolvable);
    resetMonitoringEnabled(): void;
    get monitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _datadogOrganization;
    get datadogOrganization(): DatadogMonitorDatadogOrganizationOutputReference;
    putDatadogOrganization(value: DatadogMonitorDatadogOrganization): void;
    get datadogOrganizationInput(): DatadogMonitorDatadogOrganization | undefined;
    private _identity;
    get identity(): DatadogMonitorIdentityOutputReference;
    putIdentity(value: DatadogMonitorIdentity): void;
    resetIdentity(): void;
    get identityInput(): DatadogMonitorIdentity | undefined;
    private _timeouts;
    get timeouts(): DatadogMonitorTimeoutsOutputReference;
    putTimeouts(value: DatadogMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatadogMonitorTimeouts | undefined;
    private _user;
    get user(): DatadogMonitorUserOutputReference;
    putUser(value: DatadogMonitorUser): void;
    get userInput(): DatadogMonitorUser | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
