/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevTestVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#description DevTestVirtualNetwork#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#id DevTestVirtualNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#lab_name DevTestVirtualNetwork#lab_name}
    */
    readonly labName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#name DevTestVirtualNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#resource_group_name DevTestVirtualNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#tags DevTestVirtualNetwork#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#subnet DevTestVirtualNetwork#subnet}
    */
    readonly subnet?: DevTestVirtualNetworkSubnet;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#timeouts DevTestVirtualNetwork#timeouts}
    */
    readonly timeouts?: DevTestVirtualNetworkTimeouts;
}
export interface DevTestVirtualNetworkSubnet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#use_in_virtual_machine_creation DevTestVirtualNetwork#use_in_virtual_machine_creation}
    */
    readonly useInVirtualMachineCreation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#use_public_ip_address DevTestVirtualNetwork#use_public_ip_address}
    */
    readonly usePublicIpAddress?: string;
}
export declare function devTestVirtualNetworkSubnetToTerraform(struct?: DevTestVirtualNetworkSubnetOutputReference | DevTestVirtualNetworkSubnet): any;
export declare class DevTestVirtualNetworkSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevTestVirtualNetworkSubnet | undefined;
    set internalValue(value: DevTestVirtualNetworkSubnet | undefined);
    get name(): string;
    private _useInVirtualMachineCreation?;
    get useInVirtualMachineCreation(): string;
    set useInVirtualMachineCreation(value: string);
    resetUseInVirtualMachineCreation(): void;
    get useInVirtualMachineCreationInput(): string | undefined;
    private _usePublicIpAddress?;
    get usePublicIpAddress(): string;
    set usePublicIpAddress(value: string);
    resetUsePublicIpAddress(): void;
    get usePublicIpAddressInput(): string | undefined;
}
export interface DevTestVirtualNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#create DevTestVirtualNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#delete DevTestVirtualNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#read DevTestVirtualNetwork#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#update DevTestVirtualNetwork#update}
    */
    readonly update?: string;
}
export declare function devTestVirtualNetworkTimeoutsToTerraform(struct?: DevTestVirtualNetworkTimeouts | cdktf.IResolvable): any;
export declare class DevTestVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevTestVirtualNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DevTestVirtualNetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network azurerm_dev_test_virtual_network}
*/
export declare class DevTestVirtualNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dev_test_virtual_network";
    /**
    * Generates CDKTF code for importing a DevTestVirtualNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DevTestVirtualNetwork to import
    * @param importFromId The id of the existing DevTestVirtualNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DevTestVirtualNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/dev_test_virtual_network azurerm_dev_test_virtual_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevTestVirtualNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DevTestVirtualNetworkConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labName?;
    get labName(): string;
    set labName(value: string);
    get labNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get uniqueIdentifier(): string;
    private _subnet;
    get subnet(): DevTestVirtualNetworkSubnetOutputReference;
    putSubnet(value: DevTestVirtualNetworkSubnet): void;
    resetSubnet(): void;
    get subnetInput(): DevTestVirtualNetworkSubnet | undefined;
    private _timeouts;
    get timeouts(): DevTestVirtualNetworkTimeoutsOutputReference;
    putTimeouts(value: DevTestVirtualNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DevTestVirtualNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
