/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#auto_learn_private_ranges_enabled FirewallPolicy#auto_learn_private_ranges_enabled}
    */
    readonly autoLearnPrivateRangesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#base_policy_id FirewallPolicy#base_policy_id}
    */
    readonly basePolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#id FirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#location FirewallPolicy#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#name FirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#private_ip_ranges FirewallPolicy#private_ip_ranges}
    */
    readonly privateIpRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#resource_group_name FirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#sku FirewallPolicy#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#sql_redirect_allowed FirewallPolicy#sql_redirect_allowed}
    */
    readonly sqlRedirectAllowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#tags FirewallPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#threat_intelligence_mode FirewallPolicy#threat_intelligence_mode}
    */
    readonly threatIntelligenceMode?: string;
    /**
    * dns block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#dns FirewallPolicy#dns}
    */
    readonly dns?: FirewallPolicyDns;
    /**
    * explicit_proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#explicit_proxy FirewallPolicy#explicit_proxy}
    */
    readonly explicitProxy?: FirewallPolicyExplicitProxy;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#identity FirewallPolicy#identity}
    */
    readonly identity?: FirewallPolicyIdentity;
    /**
    * insights block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#insights FirewallPolicy#insights}
    */
    readonly insights?: FirewallPolicyInsights;
    /**
    * intrusion_detection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#intrusion_detection FirewallPolicy#intrusion_detection}
    */
    readonly intrusionDetection?: FirewallPolicyIntrusionDetection;
    /**
    * threat_intelligence_allowlist block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#threat_intelligence_allowlist FirewallPolicy#threat_intelligence_allowlist}
    */
    readonly threatIntelligenceAllowlist?: FirewallPolicyThreatIntelligenceAllowlistStruct;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#timeouts FirewallPolicy#timeouts}
    */
    readonly timeouts?: FirewallPolicyTimeouts;
    /**
    * tls_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#tls_certificate FirewallPolicy#tls_certificate}
    */
    readonly tlsCertificate?: FirewallPolicyTlsCertificate;
}
export interface FirewallPolicyDns {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#proxy_enabled FirewallPolicy#proxy_enabled}
    */
    readonly proxyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#servers FirewallPolicy#servers}
    */
    readonly servers?: string[];
}
export declare function firewallPolicyDnsToTerraform(struct?: FirewallPolicyDnsOutputReference | FirewallPolicyDns): any;
export declare class FirewallPolicyDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyDns | undefined;
    set internalValue(value: FirewallPolicyDns | undefined);
    private _proxyEnabled?;
    get proxyEnabled(): boolean | cdktf.IResolvable;
    set proxyEnabled(value: boolean | cdktf.IResolvable);
    resetProxyEnabled(): void;
    get proxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servers?;
    get servers(): string[];
    set servers(value: string[]);
    resetServers(): void;
    get serversInput(): string[] | undefined;
}
export interface FirewallPolicyExplicitProxy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#enable_pac_file FirewallPolicy#enable_pac_file}
    */
    readonly enablePacFile?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#enabled FirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#http_port FirewallPolicy#http_port}
    */
    readonly httpPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#https_port FirewallPolicy#https_port}
    */
    readonly httpsPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#pac_file FirewallPolicy#pac_file}
    */
    readonly pacFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#pac_file_port FirewallPolicy#pac_file_port}
    */
    readonly pacFilePort?: number;
}
export declare function firewallPolicyExplicitProxyToTerraform(struct?: FirewallPolicyExplicitProxyOutputReference | FirewallPolicyExplicitProxy): any;
export declare class FirewallPolicyExplicitProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyExplicitProxy | undefined;
    set internalValue(value: FirewallPolicyExplicitProxy | undefined);
    private _enablePacFile?;
    get enablePacFile(): boolean | cdktf.IResolvable;
    set enablePacFile(value: boolean | cdktf.IResolvable);
    resetEnablePacFile(): void;
    get enablePacFileInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpPort?;
    get httpPort(): number;
    set httpPort(value: number);
    resetHttpPort(): void;
    get httpPortInput(): number | undefined;
    private _httpsPort?;
    get httpsPort(): number;
    set httpsPort(value: number);
    resetHttpsPort(): void;
    get httpsPortInput(): number | undefined;
    private _pacFile?;
    get pacFile(): string;
    set pacFile(value: string);
    resetPacFile(): void;
    get pacFileInput(): string | undefined;
    private _pacFilePort?;
    get pacFilePort(): number;
    set pacFilePort(value: number);
    resetPacFilePort(): void;
    get pacFilePortInput(): number | undefined;
}
export interface FirewallPolicyIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#identity_ids FirewallPolicy#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#type FirewallPolicy#type}
    */
    readonly type: string;
}
export declare function firewallPolicyIdentityToTerraform(struct?: FirewallPolicyIdentityOutputReference | FirewallPolicyIdentity): any;
export declare class FirewallPolicyIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyIdentity | undefined;
    set internalValue(value: FirewallPolicyIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface FirewallPolicyInsightsLogAnalyticsWorkspace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#firewall_location FirewallPolicy#firewall_location}
    */
    readonly firewallLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#id FirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function firewallPolicyInsightsLogAnalyticsWorkspaceToTerraform(struct?: FirewallPolicyInsightsLogAnalyticsWorkspace | cdktf.IResolvable): any;
export declare class FirewallPolicyInsightsLogAnalyticsWorkspaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallPolicyInsightsLogAnalyticsWorkspace | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallPolicyInsightsLogAnalyticsWorkspace | cdktf.IResolvable | undefined);
    private _firewallLocation?;
    get firewallLocation(): string;
    set firewallLocation(value: string);
    get firewallLocationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export declare class FirewallPolicyInsightsLogAnalyticsWorkspaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallPolicyInsightsLogAnalyticsWorkspace[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallPolicyInsightsLogAnalyticsWorkspaceOutputReference;
}
export interface FirewallPolicyInsights {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#default_log_analytics_workspace_id FirewallPolicy#default_log_analytics_workspace_id}
    */
    readonly defaultLogAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#enabled FirewallPolicy#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#retention_in_days FirewallPolicy#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * log_analytics_workspace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#log_analytics_workspace FirewallPolicy#log_analytics_workspace}
    */
    readonly logAnalyticsWorkspace?: FirewallPolicyInsightsLogAnalyticsWorkspace[] | cdktf.IResolvable;
}
export declare function firewallPolicyInsightsToTerraform(struct?: FirewallPolicyInsightsOutputReference | FirewallPolicyInsights): any;
export declare class FirewallPolicyInsightsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyInsights | undefined;
    set internalValue(value: FirewallPolicyInsights | undefined);
    private _defaultLogAnalyticsWorkspaceId?;
    get defaultLogAnalyticsWorkspaceId(): string;
    set defaultLogAnalyticsWorkspaceId(value: string);
    get defaultLogAnalyticsWorkspaceIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _logAnalyticsWorkspace;
    get logAnalyticsWorkspace(): FirewallPolicyInsightsLogAnalyticsWorkspaceList;
    putLogAnalyticsWorkspace(value: FirewallPolicyInsightsLogAnalyticsWorkspace[] | cdktf.IResolvable): void;
    resetLogAnalyticsWorkspace(): void;
    get logAnalyticsWorkspaceInput(): cdktf.IResolvable | FirewallPolicyInsightsLogAnalyticsWorkspace[] | undefined;
}
export interface FirewallPolicyIntrusionDetectionSignatureOverrides {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#id FirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#state FirewallPolicy#state}
    */
    readonly state?: string;
}
export declare function firewallPolicyIntrusionDetectionSignatureOverridesToTerraform(struct?: FirewallPolicyIntrusionDetectionSignatureOverrides | cdktf.IResolvable): any;
export declare class FirewallPolicyIntrusionDetectionSignatureOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallPolicyIntrusionDetectionSignatureOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallPolicyIntrusionDetectionSignatureOverrides | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
}
export declare class FirewallPolicyIntrusionDetectionSignatureOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallPolicyIntrusionDetectionSignatureOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallPolicyIntrusionDetectionSignatureOverridesOutputReference;
}
export interface FirewallPolicyIntrusionDetectionTrafficBypass {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#description FirewallPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#destination_addresses FirewallPolicy#destination_addresses}
    */
    readonly destinationAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#destination_ip_groups FirewallPolicy#destination_ip_groups}
    */
    readonly destinationIpGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#destination_ports FirewallPolicy#destination_ports}
    */
    readonly destinationPorts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#name FirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#protocol FirewallPolicy#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#source_addresses FirewallPolicy#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#source_ip_groups FirewallPolicy#source_ip_groups}
    */
    readonly sourceIpGroups?: string[];
}
export declare function firewallPolicyIntrusionDetectionTrafficBypassToTerraform(struct?: FirewallPolicyIntrusionDetectionTrafficBypass | cdktf.IResolvable): any;
export declare class FirewallPolicyIntrusionDetectionTrafficBypassOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallPolicyIntrusionDetectionTrafficBypass | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallPolicyIntrusionDetectionTrafficBypass | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationAddresses?;
    get destinationAddresses(): string[];
    set destinationAddresses(value: string[]);
    resetDestinationAddresses(): void;
    get destinationAddressesInput(): string[] | undefined;
    private _destinationIpGroups?;
    get destinationIpGroups(): string[];
    set destinationIpGroups(value: string[]);
    resetDestinationIpGroups(): void;
    get destinationIpGroupsInput(): string[] | undefined;
    private _destinationPorts?;
    get destinationPorts(): string[];
    set destinationPorts(value: string[]);
    resetDestinationPorts(): void;
    get destinationPortsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _sourceAddresses?;
    get sourceAddresses(): string[];
    set sourceAddresses(value: string[]);
    resetSourceAddresses(): void;
    get sourceAddressesInput(): string[] | undefined;
    private _sourceIpGroups?;
    get sourceIpGroups(): string[];
    set sourceIpGroups(value: string[]);
    resetSourceIpGroups(): void;
    get sourceIpGroupsInput(): string[] | undefined;
}
export declare class FirewallPolicyIntrusionDetectionTrafficBypassList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallPolicyIntrusionDetectionTrafficBypass[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallPolicyIntrusionDetectionTrafficBypassOutputReference;
}
export interface FirewallPolicyIntrusionDetection {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#mode FirewallPolicy#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#private_ranges FirewallPolicy#private_ranges}
    */
    readonly privateRanges?: string[];
    /**
    * signature_overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#signature_overrides FirewallPolicy#signature_overrides}
    */
    readonly signatureOverrides?: FirewallPolicyIntrusionDetectionSignatureOverrides[] | cdktf.IResolvable;
    /**
    * traffic_bypass block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#traffic_bypass FirewallPolicy#traffic_bypass}
    */
    readonly trafficBypass?: FirewallPolicyIntrusionDetectionTrafficBypass[] | cdktf.IResolvable;
}
export declare function firewallPolicyIntrusionDetectionToTerraform(struct?: FirewallPolicyIntrusionDetectionOutputReference | FirewallPolicyIntrusionDetection): any;
export declare class FirewallPolicyIntrusionDetectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyIntrusionDetection | undefined;
    set internalValue(value: FirewallPolicyIntrusionDetection | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _privateRanges?;
    get privateRanges(): string[];
    set privateRanges(value: string[]);
    resetPrivateRanges(): void;
    get privateRangesInput(): string[] | undefined;
    private _signatureOverrides;
    get signatureOverrides(): FirewallPolicyIntrusionDetectionSignatureOverridesList;
    putSignatureOverrides(value: FirewallPolicyIntrusionDetectionSignatureOverrides[] | cdktf.IResolvable): void;
    resetSignatureOverrides(): void;
    get signatureOverridesInput(): cdktf.IResolvable | FirewallPolicyIntrusionDetectionSignatureOverrides[] | undefined;
    private _trafficBypass;
    get trafficBypass(): FirewallPolicyIntrusionDetectionTrafficBypassList;
    putTrafficBypass(value: FirewallPolicyIntrusionDetectionTrafficBypass[] | cdktf.IResolvable): void;
    resetTrafficBypass(): void;
    get trafficBypassInput(): cdktf.IResolvable | FirewallPolicyIntrusionDetectionTrafficBypass[] | undefined;
}
export interface FirewallPolicyThreatIntelligenceAllowlistStruct {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#fqdns FirewallPolicy#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#ip_addresses FirewallPolicy#ip_addresses}
    */
    readonly ipAddresses?: string[];
}
export declare function firewallPolicyThreatIntelligenceAllowlistStructToTerraform(struct?: FirewallPolicyThreatIntelligenceAllowlistStructOutputReference | FirewallPolicyThreatIntelligenceAllowlistStruct): any;
export declare class FirewallPolicyThreatIntelligenceAllowlistStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyThreatIntelligenceAllowlistStruct | undefined;
    set internalValue(value: FirewallPolicyThreatIntelligenceAllowlistStruct | undefined);
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
}
export interface FirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#create FirewallPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#delete FirewallPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#read FirewallPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#update FirewallPolicy#update}
    */
    readonly update?: string;
}
export declare function firewallPolicyTimeoutsToTerraform(struct?: FirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class FirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface FirewallPolicyTlsCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#key_vault_secret_id FirewallPolicy#key_vault_secret_id}
    */
    readonly keyVaultSecretId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#name FirewallPolicy#name}
    */
    readonly name: string;
}
export declare function firewallPolicyTlsCertificateToTerraform(struct?: FirewallPolicyTlsCertificateOutputReference | FirewallPolicyTlsCertificate): any;
export declare class FirewallPolicyTlsCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallPolicyTlsCertificate | undefined;
    set internalValue(value: FirewallPolicyTlsCertificate | undefined);
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy azurerm_firewall_policy}
*/
export declare class FirewallPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_firewall_policy";
    /**
    * Generates CDKTF code for importing a FirewallPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FirewallPolicy to import
    * @param importFromId The id of the existing FirewallPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FirewallPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/firewall_policy azurerm_firewall_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: FirewallPolicyConfig);
    private _autoLearnPrivateRangesEnabled?;
    get autoLearnPrivateRangesEnabled(): boolean | cdktf.IResolvable;
    set autoLearnPrivateRangesEnabled(value: boolean | cdktf.IResolvable);
    resetAutoLearnPrivateRangesEnabled(): void;
    get autoLearnPrivateRangesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _basePolicyId?;
    get basePolicyId(): string;
    set basePolicyId(value: string);
    resetBasePolicyId(): void;
    get basePolicyIdInput(): string | undefined;
    get childPolicies(): string[];
    get firewalls(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpRanges?;
    get privateIpRanges(): string[];
    set privateIpRanges(value: string[]);
    resetPrivateIpRanges(): void;
    get privateIpRangesInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get ruleCollectionGroups(): string[];
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _sqlRedirectAllowed?;
    get sqlRedirectAllowed(): boolean | cdktf.IResolvable;
    set sqlRedirectAllowed(value: boolean | cdktf.IResolvable);
    resetSqlRedirectAllowed(): void;
    get sqlRedirectAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _threatIntelligenceMode?;
    get threatIntelligenceMode(): string;
    set threatIntelligenceMode(value: string);
    resetThreatIntelligenceMode(): void;
    get threatIntelligenceModeInput(): string | undefined;
    private _dns;
    get dns(): FirewallPolicyDnsOutputReference;
    putDns(value: FirewallPolicyDns): void;
    resetDns(): void;
    get dnsInput(): FirewallPolicyDns | undefined;
    private _explicitProxy;
    get explicitProxy(): FirewallPolicyExplicitProxyOutputReference;
    putExplicitProxy(value: FirewallPolicyExplicitProxy): void;
    resetExplicitProxy(): void;
    get explicitProxyInput(): FirewallPolicyExplicitProxy | undefined;
    private _identity;
    get identity(): FirewallPolicyIdentityOutputReference;
    putIdentity(value: FirewallPolicyIdentity): void;
    resetIdentity(): void;
    get identityInput(): FirewallPolicyIdentity | undefined;
    private _insights;
    get insights(): FirewallPolicyInsightsOutputReference;
    putInsights(value: FirewallPolicyInsights): void;
    resetInsights(): void;
    get insightsInput(): FirewallPolicyInsights | undefined;
    private _intrusionDetection;
    get intrusionDetection(): FirewallPolicyIntrusionDetectionOutputReference;
    putIntrusionDetection(value: FirewallPolicyIntrusionDetection): void;
    resetIntrusionDetection(): void;
    get intrusionDetectionInput(): FirewallPolicyIntrusionDetection | undefined;
    private _threatIntelligenceAllowlist;
    get threatIntelligenceAllowlist(): FirewallPolicyThreatIntelligenceAllowlistStructOutputReference;
    putThreatIntelligenceAllowlist(value: FirewallPolicyThreatIntelligenceAllowlistStruct): void;
    resetThreatIntelligenceAllowlist(): void;
    get threatIntelligenceAllowlistInput(): FirewallPolicyThreatIntelligenceAllowlistStruct | undefined;
    private _timeouts;
    get timeouts(): FirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: FirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FirewallPolicyTimeouts | undefined;
    private _tlsCertificate;
    get tlsCertificate(): FirewallPolicyTlsCertificateOutputReference;
    putTlsCertificate(value: FirewallPolicyTlsCertificate): void;
    resetTlsCertificate(): void;
    get tlsCertificateInput(): FirewallPolicyTlsCertificate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
