/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
export * as aadb2CDirectory from './aadb2c-directory';
export * as activeDirectoryDomainService from './active-directory-domain-service';
export * as activeDirectoryDomainServiceReplicaSet from './active-directory-domain-service-replica-set';
export * as activeDirectoryDomainServiceTrust from './active-directory-domain-service-trust';
export * as advancedThreatProtection from './advanced-threat-protection';
export * as analysisServicesServer from './analysis-services-server';
export * as apiConnection from './api-connection';
export * as apiManagement from './api-management';
export * as apiManagementApi from './api-management-api';
export * as apiManagementApiDiagnostic from './api-management-api-diagnostic';
export * as apiManagementApiOperation from './api-management-api-operation';
export * as apiManagementApiOperationPolicy from './api-management-api-operation-policy';
export * as apiManagementApiOperationTag from './api-management-api-operation-tag';
export * as apiManagementApiPolicy from './api-management-api-policy';
export * as apiManagementApiRelease from './api-management-api-release';
export * as apiManagementApiSchema from './api-management-api-schema';
export * as apiManagementApiTag from './api-management-api-tag';
export * as apiManagementApiTagDescription from './api-management-api-tag-description';
export * as apiManagementApiVersionSet from './api-management-api-version-set';
export * as apiManagementAuthorizationServer from './api-management-authorization-server';
export * as apiManagementBackend from './api-management-backend';
export * as apiManagementCertificate from './api-management-certificate';
export * as apiManagementCustomDomain from './api-management-custom-domain';
export * as apiManagementDiagnostic from './api-management-diagnostic';
export * as apiManagementEmailTemplate from './api-management-email-template';
export * as apiManagementGateway from './api-management-gateway';
export * as apiManagementGatewayApi from './api-management-gateway-api';
export * as apiManagementGatewayCertificateAuthority from './api-management-gateway-certificate-authority';
export * as apiManagementGatewayHostNameConfiguration from './api-management-gateway-host-name-configuration';
export * as apiManagementGlobalSchema from './api-management-global-schema';
export * as apiManagementGroup from './api-management-group';
export * as apiManagementGroupUser from './api-management-group-user';
export * as apiManagementIdentityProviderAad from './api-management-identity-provider-aad';
export * as apiManagementIdentityProviderAadb2C from './api-management-identity-provider-aadb2c';
export * as apiManagementIdentityProviderFacebook from './api-management-identity-provider-facebook';
export * as apiManagementIdentityProviderGoogle from './api-management-identity-provider-google';
export * as apiManagementIdentityProviderMicrosoft from './api-management-identity-provider-microsoft';
export * as apiManagementIdentityProviderTwitter from './api-management-identity-provider-twitter';
export * as apiManagementLogger from './api-management-logger';
export * as apiManagementNamedValue from './api-management-named-value';
export * as apiManagementNotificationRecipientEmail from './api-management-notification-recipient-email';
export * as apiManagementNotificationRecipientUser from './api-management-notification-recipient-user';
export * as apiManagementOpenidConnectProvider from './api-management-openid-connect-provider';
export * as apiManagementPolicy from './api-management-policy';
export * as apiManagementProduct from './api-management-product';
export * as apiManagementProductApi from './api-management-product-api';
export * as apiManagementProductGroup from './api-management-product-group';
export * as apiManagementProductPolicy from './api-management-product-policy';
export * as apiManagementProductTag from './api-management-product-tag';
export * as apiManagementRedisCache from './api-management-redis-cache';
export * as apiManagementSubscription from './api-management-subscription';
export * as apiManagementTag from './api-management-tag';
export * as apiManagementUser from './api-management-user';
export * as appConfiguration from './app-configuration';
export * as appConfigurationFeature from './app-configuration-feature';
export * as appConfigurationKey from './app-configuration-key';
export * as appService from './app-service';
export * as appServiceActiveSlot from './app-service-active-slot';
export * as appServiceCertificate from './app-service-certificate';
export * as appServiceCertificateBinding from './app-service-certificate-binding';
export * as appServiceCertificateOrder from './app-service-certificate-order';
export * as appServiceConnection from './app-service-connection';
export * as appServiceCustomHostnameBinding from './app-service-custom-hostname-binding';
export * as appServiceEnvironment from './app-service-environment';
export * as appServiceEnvironmentV3 from './app-service-environment-v3';
export * as appServiceHybridConnection from './app-service-hybrid-connection';
export * as appServiceManagedCertificate from './app-service-managed-certificate';
export * as appServicePlan from './app-service-plan';
export * as appServicePublicCertificate from './app-service-public-certificate';
export * as appServiceSlot from './app-service-slot';
export * as appServiceSlotCustomHostnameBinding from './app-service-slot-custom-hostname-binding';
export * as appServiceSlotVirtualNetworkSwiftConnection from './app-service-slot-virtual-network-swift-connection';
export * as appServiceSourceControl from './app-service-source-control';
export * as appServiceSourceControlSlot from './app-service-source-control-slot';
export * as appServiceSourceControlToken from './app-service-source-control-token';
export * as appServiceVirtualNetworkSwiftConnection from './app-service-virtual-network-swift-connection';
export * as applicationGateway from './application-gateway';
export * as applicationInsights from './application-insights';
export * as applicationInsightsAnalyticsItem from './application-insights-analytics-item';
export * as applicationInsightsApiKey from './application-insights-api-key';
export * as applicationInsightsSmartDetectionRule from './application-insights-smart-detection-rule';
export * as applicationInsightsStandardWebTest from './application-insights-standard-web-test';
export * as applicationInsightsWebTest from './application-insights-web-test';
export * as applicationInsightsWorkbook from './application-insights-workbook';
export * as applicationInsightsWorkbookTemplate from './application-insights-workbook-template';
export * as applicationLoadBalancer from './application-load-balancer';
export * as applicationLoadBalancerFrontend from './application-load-balancer-frontend';
export * as applicationLoadBalancerSubnetAssociation from './application-load-balancer-subnet-association';
export * as applicationSecurityGroup from './application-security-group';
export * as arcKubernetesCluster from './arc-kubernetes-cluster';
export * as arcKubernetesClusterExtension from './arc-kubernetes-cluster-extension';
export * as arcKubernetesFluxConfiguration from './arc-kubernetes-flux-configuration';
export * as arcMachineExtension from './arc-machine-extension';
export * as arcPrivateLinkScope from './arc-private-link-scope';
export * as arcResourceBridgeAppliance from './arc-resource-bridge-appliance';
export * as attestationProvider from './attestation-provider';
export * as automanageConfiguration from './automanage-configuration';
export * as automationAccount from './automation-account';
export * as automationCertificate from './automation-certificate';
export * as automationConnection from './automation-connection';
export * as automationConnectionCertificate from './automation-connection-certificate';
export * as automationConnectionClassicCertificate from './automation-connection-classic-certificate';
export * as automationConnectionServicePrincipal from './automation-connection-service-principal';
export * as automationConnectionType from './automation-connection-type';
export * as automationCredential from './automation-credential';
export * as automationDscConfiguration from './automation-dsc-configuration';
export * as automationDscNodeconfiguration from './automation-dsc-nodeconfiguration';
export * as automationHybridRunbookWorker from './automation-hybrid-runbook-worker';
export * as automationHybridRunbookWorkerGroup from './automation-hybrid-runbook-worker-group';
export * as automationJobSchedule from './automation-job-schedule';
export * as automationModule from './automation-module';
export * as automationPython3Package from './automation-python3-package';
export * as automationRunbook from './automation-runbook';
export * as automationSchedule from './automation-schedule';
export * as automationSoftwareUpdateConfiguration from './automation-software-update-configuration';
export * as automationSourceControl from './automation-source-control';
export * as automationVariableBool from './automation-variable-bool';
export * as automationVariableDatetime from './automation-variable-datetime';
export * as automationVariableInt from './automation-variable-int';
export * as automationVariableObject from './automation-variable-object';
export * as automationVariableString from './automation-variable-string';
export * as automationWatcher from './automation-watcher';
export * as automationWebhook from './automation-webhook';
export * as availabilitySet from './availability-set';
export * as backupContainerStorageAccount from './backup-container-storage-account';
export * as backupPolicyFileShare from './backup-policy-file-share';
export * as backupPolicyVm from './backup-policy-vm';
export * as backupPolicyVmWorkload from './backup-policy-vm-workload';
export * as backupProtectedFileShare from './backup-protected-file-share';
export * as backupProtectedVm from './backup-protected-vm';
export * as bastionHost from './bastion-host';
export * as batchAccount from './batch-account';
export * as batchApplication from './batch-application';
export * as batchCertificate from './batch-certificate';
export * as batchJob from './batch-job';
export * as batchPool from './batch-pool';
export * as billingAccountCostManagementExport from './billing-account-cost-management-export';
export * as blueprintAssignment from './blueprint-assignment';
export * as botChannelAlexa from './bot-channel-alexa';
export * as botChannelDirectLineSpeech from './bot-channel-direct-line-speech';
export * as botChannelDirectline from './bot-channel-directline';
export * as botChannelEmail from './bot-channel-email';
export * as botChannelFacebook from './bot-channel-facebook';
export * as botChannelLine from './bot-channel-line';
export * as botChannelMsTeams from './bot-channel-ms-teams';
export * as botChannelSlack from './bot-channel-slack';
export * as botChannelSms from './bot-channel-sms';
export * as botChannelWebChat from './bot-channel-web-chat';
export * as botChannelsRegistration from './bot-channels-registration';
export * as botConnection from './bot-connection';
export * as botServiceAzureBot from './bot-service-azure-bot';
export * as botWebApp from './bot-web-app';
export * as capacityReservation from './capacity-reservation';
export * as capacityReservationGroup from './capacity-reservation-group';
export * as cdnEndpoint from './cdn-endpoint';
export * as cdnEndpointCustomDomain from './cdn-endpoint-custom-domain';
export * as cdnFrontdoorCustomDomain from './cdn-frontdoor-custom-domain';
export * as cdnFrontdoorCustomDomainAssociation from './cdn-frontdoor-custom-domain-association';
export * as cdnFrontdoorEndpoint from './cdn-frontdoor-endpoint';
export * as cdnFrontdoorFirewallPolicy from './cdn-frontdoor-firewall-policy';
export * as cdnFrontdoorOrigin from './cdn-frontdoor-origin';
export * as cdnFrontdoorOriginGroup from './cdn-frontdoor-origin-group';
export * as cdnFrontdoorProfile from './cdn-frontdoor-profile';
export * as cdnFrontdoorRoute from './cdn-frontdoor-route';
export * as cdnFrontdoorRouteDisableLinkToDefaultDomain from './cdn-frontdoor-route-disable-link-to-default-domain';
export * as cdnFrontdoorRule from './cdn-frontdoor-rule';
export * as cdnFrontdoorRuleSet from './cdn-frontdoor-rule-set';
export * as cdnFrontdoorSecret from './cdn-frontdoor-secret';
export * as cdnFrontdoorSecurityPolicy from './cdn-frontdoor-security-policy';
export * as cdnProfile from './cdn-profile';
export * as cognitiveAccount from './cognitive-account';
export * as cognitiveAccountCustomerManagedKey from './cognitive-account-customer-managed-key';
export * as cognitiveDeployment from './cognitive-deployment';
export * as communicationService from './communication-service';
export * as confidentialLedger from './confidential-ledger';
export * as consumptionBudgetManagementGroup from './consumption-budget-management-group';
export * as consumptionBudgetResourceGroup from './consumption-budget-resource-group';
export * as consumptionBudgetSubscription from './consumption-budget-subscription';
export * as containerApp from './container-app';
export * as containerAppEnvironment from './container-app-environment';
export * as containerAppEnvironmentCertificate from './container-app-environment-certificate';
export * as containerAppEnvironmentDaprComponent from './container-app-environment-dapr-component';
export * as containerAppEnvironmentStorage from './container-app-environment-storage';
export * as containerConnectedRegistry from './container-connected-registry';
export * as containerGroup from './container-group';
export * as containerRegistry from './container-registry';
export * as containerRegistryAgentPool from './container-registry-agent-pool';
export * as containerRegistryScopeMap from './container-registry-scope-map';
export * as containerRegistryTask from './container-registry-task';
export * as containerRegistryTaskScheduleRunNow from './container-registry-task-schedule-run-now';
export * as containerRegistryToken from './container-registry-token';
export * as containerRegistryTokenPassword from './container-registry-token-password';
export * as containerRegistryWebhook from './container-registry-webhook';
export * as cosmosdbAccount from './cosmosdb-account';
export * as cosmosdbCassandraCluster from './cosmosdb-cassandra-cluster';
export * as cosmosdbCassandraDatacenter from './cosmosdb-cassandra-datacenter';
export * as cosmosdbCassandraKeyspace from './cosmosdb-cassandra-keyspace';
export * as cosmosdbCassandraTable from './cosmosdb-cassandra-table';
export * as cosmosdbGremlinDatabase from './cosmosdb-gremlin-database';
export * as cosmosdbGremlinGraph from './cosmosdb-gremlin-graph';
export * as cosmosdbMongoCollection from './cosmosdb-mongo-collection';
export * as cosmosdbMongoDatabase from './cosmosdb-mongo-database';
export * as cosmosdbMongoRoleDefinition from './cosmosdb-mongo-role-definition';
export * as cosmosdbMongoUserDefinition from './cosmosdb-mongo-user-definition';
export * as cosmosdbNotebookWorkspace from './cosmosdb-notebook-workspace';
export * as cosmosdbPostgresqlCluster from './cosmosdb-postgresql-cluster';
export * as cosmosdbPostgresqlCoordinatorConfiguration from './cosmosdb-postgresql-coordinator-configuration';
export * as cosmosdbPostgresqlFirewallRule from './cosmosdb-postgresql-firewall-rule';
export * as cosmosdbPostgresqlNodeConfiguration from './cosmosdb-postgresql-node-configuration';
export * as cosmosdbPostgresqlRole from './cosmosdb-postgresql-role';
export * as cosmosdbSqlContainer from './cosmosdb-sql-container';
export * as cosmosdbSqlDatabase from './cosmosdb-sql-database';
export * as cosmosdbSqlDedicatedGateway from './cosmosdb-sql-dedicated-gateway';
export * as cosmosdbSqlFunction from './cosmosdb-sql-function';
export * as cosmosdbSqlRoleAssignment from './cosmosdb-sql-role-assignment';
export * as cosmosdbSqlRoleDefinition from './cosmosdb-sql-role-definition';
export * as cosmosdbSqlStoredProcedure from './cosmosdb-sql-stored-procedure';
export * as cosmosdbSqlTrigger from './cosmosdb-sql-trigger';
export * as cosmosdbTable from './cosmosdb-table';
export * as costAnomalyAlert from './cost-anomaly-alert';
export * as costManagementScheduledAction from './cost-management-scheduled-action';
export * as customIpPrefix from './custom-ip-prefix';
export * as customProvider from './custom-provider';
export * as dashboard from './dashboard';
export * as dashboardGrafana from './dashboard-grafana';
export * as dataFactory from './data-factory';
export * as dataFactoryCustomDataset from './data-factory-custom-dataset';
export * as dataFactoryDataFlow from './data-factory-data-flow';
export * as dataFactoryDatasetAzureBlob from './data-factory-dataset-azure-blob';
export * as dataFactoryDatasetAzureSqlTable from './data-factory-dataset-azure-sql-table';
export * as dataFactoryDatasetBinary from './data-factory-dataset-binary';
export * as dataFactoryDatasetCosmosdbSqlapi from './data-factory-dataset-cosmosdb-sqlapi';
export * as dataFactoryDatasetDelimitedText from './data-factory-dataset-delimited-text';
export * as dataFactoryDatasetHttp from './data-factory-dataset-http';
export * as dataFactoryDatasetJson from './data-factory-dataset-json';
export * as dataFactoryDatasetMysql from './data-factory-dataset-mysql';
export * as dataFactoryDatasetParquet from './data-factory-dataset-parquet';
export * as dataFactoryDatasetPostgresql from './data-factory-dataset-postgresql';
export * as dataFactoryDatasetSnowflake from './data-factory-dataset-snowflake';
export * as dataFactoryDatasetSqlServerTable from './data-factory-dataset-sql-server-table';
export * as dataFactoryFlowletDataFlow from './data-factory-flowlet-data-flow';
export * as dataFactoryIntegrationRuntimeAzure from './data-factory-integration-runtime-azure';
export * as dataFactoryIntegrationRuntimeAzureSsis from './data-factory-integration-runtime-azure-ssis';
export * as dataFactoryIntegrationRuntimeManaged from './data-factory-integration-runtime-managed';
export * as dataFactoryIntegrationRuntimeSelfHosted from './data-factory-integration-runtime-self-hosted';
export * as dataFactoryLinkedCustomService from './data-factory-linked-custom-service';
export * as dataFactoryLinkedServiceAzureBlobStorage from './data-factory-linked-service-azure-blob-storage';
export * as dataFactoryLinkedServiceAzureDatabricks from './data-factory-linked-service-azure-databricks';
export * as dataFactoryLinkedServiceAzureFileStorage from './data-factory-linked-service-azure-file-storage';
export * as dataFactoryLinkedServiceAzureFunction from './data-factory-linked-service-azure-function';
export * as dataFactoryLinkedServiceAzureSearch from './data-factory-linked-service-azure-search';
export * as dataFactoryLinkedServiceAzureSqlDatabase from './data-factory-linked-service-azure-sql-database';
export * as dataFactoryLinkedServiceAzureTableStorage from './data-factory-linked-service-azure-table-storage';
export * as dataFactoryLinkedServiceCosmosdb from './data-factory-linked-service-cosmosdb';
export * as dataFactoryLinkedServiceCosmosdbMongoapi from './data-factory-linked-service-cosmosdb-mongoapi';
export * as dataFactoryLinkedServiceDataLakeStorageGen2 from './data-factory-linked-service-data-lake-storage-gen2';
export * as dataFactoryLinkedServiceKeyVault from './data-factory-linked-service-key-vault';
export * as dataFactoryLinkedServiceKusto from './data-factory-linked-service-kusto';
export * as dataFactoryLinkedServiceMysql from './data-factory-linked-service-mysql';
export * as dataFactoryLinkedServiceOdata from './data-factory-linked-service-odata';
export * as dataFactoryLinkedServiceOdbc from './data-factory-linked-service-odbc';
export * as dataFactoryLinkedServicePostgresql from './data-factory-linked-service-postgresql';
export * as dataFactoryLinkedServiceSftp from './data-factory-linked-service-sftp';
export * as dataFactoryLinkedServiceSnowflake from './data-factory-linked-service-snowflake';
export * as dataFactoryLinkedServiceSqlServer from './data-factory-linked-service-sql-server';
export * as dataFactoryLinkedServiceSynapse from './data-factory-linked-service-synapse';
export * as dataFactoryLinkedServiceWeb from './data-factory-linked-service-web';
export * as dataFactoryManagedPrivateEndpoint from './data-factory-managed-private-endpoint';
export * as dataFactoryPipeline from './data-factory-pipeline';
export * as dataFactoryTriggerBlobEvent from './data-factory-trigger-blob-event';
export * as dataFactoryTriggerCustomEvent from './data-factory-trigger-custom-event';
export * as dataFactoryTriggerSchedule from './data-factory-trigger-schedule';
export * as dataFactoryTriggerTumblingWindow from './data-factory-trigger-tumbling-window';
export * as dataProtectionBackupInstanceBlobStorage from './data-protection-backup-instance-blob-storage';
export * as dataProtectionBackupInstanceDisk from './data-protection-backup-instance-disk';
export * as dataProtectionBackupInstancePostgresql from './data-protection-backup-instance-postgresql';
export * as dataProtectionBackupPolicyBlobStorage from './data-protection-backup-policy-blob-storage';
export * as dataProtectionBackupPolicyDisk from './data-protection-backup-policy-disk';
export * as dataProtectionBackupPolicyPostgresql from './data-protection-backup-policy-postgresql';
export * as dataProtectionBackupVault from './data-protection-backup-vault';
export * as dataProtectionResourceGuard from './data-protection-resource-guard';
export * as dataShare from './data-share';
export * as dataShareAccount from './data-share-account';
export * as dataShareDatasetBlobStorage from './data-share-dataset-blob-storage';
export * as dataShareDatasetDataLakeGen2 from './data-share-dataset-data-lake-gen2';
export * as dataShareDatasetKustoCluster from './data-share-dataset-kusto-cluster';
export * as dataShareDatasetKustoDatabase from './data-share-dataset-kusto-database';
export * as databaseMigrationProject from './database-migration-project';
export * as databaseMigrationService from './database-migration-service';
export * as databoxEdgeDevice from './databox-edge-device';
export * as databoxEdgeOrder from './databox-edge-order';
export * as databricksAccessConnector from './databricks-access-connector';
export * as databricksVirtualNetworkPeering from './databricks-virtual-network-peering';
export * as databricksWorkspace from './databricks-workspace';
export * as databricksWorkspaceCustomerManagedKey from './databricks-workspace-customer-managed-key';
export * as databricksWorkspaceRootDbfsCustomerManagedKey from './databricks-workspace-root-dbfs-customer-managed-key';
export * as datadogMonitor from './datadog-monitor';
export * as datadogMonitorSsoConfiguration from './datadog-monitor-sso-configuration';
export * as datadogMonitorTagRule from './datadog-monitor-tag-rule';
export * as dedicatedHardwareSecurityModule from './dedicated-hardware-security-module';
export * as dedicatedHost from './dedicated-host';
export * as dedicatedHostGroup from './dedicated-host-group';
export * as devCenter from './dev-center';
export * as devCenterProject from './dev-center-project';
export * as devTestGlobalVmShutdownSchedule from './dev-test-global-vm-shutdown-schedule';
export * as devTestLab from './dev-test-lab';
export * as devTestLinuxVirtualMachine from './dev-test-linux-virtual-machine';
export * as devTestPolicy from './dev-test-policy';
export * as devTestSchedule from './dev-test-schedule';
export * as devTestVirtualNetwork from './dev-test-virtual-network';
export * as devTestWindowsVirtualMachine from './dev-test-windows-virtual-machine';
export * as digitalTwinsEndpointEventgrid from './digital-twins-endpoint-eventgrid';
export * as digitalTwinsEndpointEventhub from './digital-twins-endpoint-eventhub';
export * as digitalTwinsEndpointServicebus from './digital-twins-endpoint-servicebus';
export * as digitalTwinsInstance from './digital-twins-instance';
export * as digitalTwinsTimeSeriesDatabaseConnection from './digital-twins-time-series-database-connection';
export * as diskAccess from './disk-access';
export * as diskEncryptionSet from './disk-encryption-set';
export * as diskPool from './disk-pool';
export * as diskPoolIscsiTarget from './disk-pool-iscsi-target';
export * as diskPoolIscsiTargetLun from './disk-pool-iscsi-target-lun';
export * as diskPoolManagedDiskAttachment from './disk-pool-managed-disk-attachment';
export * as dnsARecord from './dns-a-record';
export * as dnsAaaaRecord from './dns-aaaa-record';
export * as dnsCaaRecord from './dns-caa-record';
export * as dnsCnameRecord from './dns-cname-record';
export * as dnsMxRecord from './dns-mx-record';
export * as dnsNsRecord from './dns-ns-record';
export * as dnsPtrRecord from './dns-ptr-record';
export * as dnsSrvRecord from './dns-srv-record';
export * as dnsTxtRecord from './dns-txt-record';
export * as dnsZone from './dns-zone';
export * as elasticCloudElasticsearch from './elastic-cloud-elasticsearch';
export * as elasticSan from './elastic-san';
export * as emailCommunicationService from './email-communication-service';
export * as eventgridDomain from './eventgrid-domain';
export * as eventgridDomainTopic from './eventgrid-domain-topic';
export * as eventgridEventSubscription from './eventgrid-event-subscription';
export * as eventgridSystemTopic from './eventgrid-system-topic';
export * as eventgridSystemTopicEventSubscription from './eventgrid-system-topic-event-subscription';
export * as eventgridTopic from './eventgrid-topic';
export * as eventhub from './eventhub';
export * as eventhubAuthorizationRule from './eventhub-authorization-rule';
export * as eventhubCluster from './eventhub-cluster';
export * as eventhubConsumerGroup from './eventhub-consumer-group';
export * as eventhubNamespace from './eventhub-namespace';
export * as eventhubNamespaceAuthorizationRule from './eventhub-namespace-authorization-rule';
export * as eventhubNamespaceCustomerManagedKey from './eventhub-namespace-customer-managed-key';
export * as eventhubNamespaceDisasterRecoveryConfig from './eventhub-namespace-disaster-recovery-config';
export * as eventhubNamespaceSchemaGroup from './eventhub-namespace-schema-group';
export * as expressRouteCircuit from './express-route-circuit';
export * as expressRouteCircuitAuthorization from './express-route-circuit-authorization';
export * as expressRouteCircuitConnection from './express-route-circuit-connection';
export * as expressRouteCircuitPeering from './express-route-circuit-peering';
export * as expressRouteConnection from './express-route-connection';
export * as expressRouteGateway from './express-route-gateway';
export * as expressRoutePort from './express-route-port';
export * as expressRoutePortAuthorization from './express-route-port-authorization';
export * as federatedIdentityCredential from './federated-identity-credential';
export * as firewall from './firewall';
export * as firewallApplicationRuleCollection from './firewall-application-rule-collection';
export * as firewallNatRuleCollection from './firewall-nat-rule-collection';
export * as firewallNetworkRuleCollection from './firewall-network-rule-collection';
export * as firewallPolicy from './firewall-policy';
export * as firewallPolicyRuleCollectionGroup from './firewall-policy-rule-collection-group';
export * as fluidRelayServer from './fluid-relay-server';
export * as frontdoor from './frontdoor';
export * as frontdoorCustomHttpsConfiguration from './frontdoor-custom-https-configuration';
export * as frontdoorFirewallPolicy from './frontdoor-firewall-policy';
export * as frontdoorRulesEngine from './frontdoor-rules-engine';
export * as functionApp from './function-app';
export * as functionAppActiveSlot from './function-app-active-slot';
export * as functionAppConnection from './function-app-connection';
export * as functionAppFunction from './function-app-function';
export * as functionAppHybridConnection from './function-app-hybrid-connection';
export * as functionAppSlot from './function-app-slot';
export * as galleryApplication from './gallery-application';
export * as galleryApplicationVersion from './gallery-application-version';
export * as graphAccount from './graph-account';
export * as graphServicesAccount from './graph-services-account';
export * as hdinsightHadoopCluster from './hdinsight-hadoop-cluster';
export * as hdinsightHbaseCluster from './hdinsight-hbase-cluster';
export * as hdinsightInteractiveQueryCluster from './hdinsight-interactive-query-cluster';
export * as hdinsightKafkaCluster from './hdinsight-kafka-cluster';
export * as hdinsightSparkCluster from './hdinsight-spark-cluster';
export * as healthbot from './healthbot';
export * as healthcareDicomService from './healthcare-dicom-service';
export * as healthcareFhirService from './healthcare-fhir-service';
export * as healthcareMedtechService from './healthcare-medtech-service';
export * as healthcareMedtechServiceFhirDestination from './healthcare-medtech-service-fhir-destination';
export * as healthcareService from './healthcare-service';
export * as healthcareWorkspace from './healthcare-workspace';
export * as hpcCache from './hpc-cache';
export * as hpcCacheAccessPolicy from './hpc-cache-access-policy';
export * as hpcCacheBlobNfsTarget from './hpc-cache-blob-nfs-target';
export * as hpcCacheBlobTarget from './hpc-cache-blob-target';
export * as hpcCacheNfsTarget from './hpc-cache-nfs-target';
export * as image from './image';
export * as integrationServiceEnvironment from './integration-service-environment';
export * as iotSecurityDeviceGroup from './iot-security-device-group';
export * as iotSecuritySolution from './iot-security-solution';
export * as iotTimeSeriesInsightsAccessPolicy from './iot-time-series-insights-access-policy';
export * as iotTimeSeriesInsightsEventSourceEventhub from './iot-time-series-insights-event-source-eventhub';
export * as iotTimeSeriesInsightsEventSourceIothub from './iot-time-series-insights-event-source-iothub';
export * as iotTimeSeriesInsightsGen2Environment from './iot-time-series-insights-gen2-environment';
export * as iotTimeSeriesInsightsReferenceDataSet from './iot-time-series-insights-reference-data-set';
export * as iotTimeSeriesInsightsStandardEnvironment from './iot-time-series-insights-standard-environment';
export * as iotcentralApplication from './iotcentral-application';
export * as iotcentralApplicationNetworkRuleSet from './iotcentral-application-network-rule-set';
export * as iothub from './iothub';
export * as iothubCertificate from './iothub-certificate';
export * as iothubConsumerGroup from './iothub-consumer-group';
export * as iothubDeviceUpdateAccount from './iothub-device-update-account';
export * as iothubDeviceUpdateInstance from './iothub-device-update-instance';
export * as iothubDps from './iothub-dps';
export * as iothubDpsCertificate from './iothub-dps-certificate';
export * as iothubDpsSharedAccessPolicy from './iothub-dps-shared-access-policy';
export * as iothubEndpointCosmosdbAccount from './iothub-endpoint-cosmosdb-account';
export * as iothubEndpointEventhub from './iothub-endpoint-eventhub';
export * as iothubEndpointServicebusQueue from './iothub-endpoint-servicebus-queue';
export * as iothubEndpointServicebusTopic from './iothub-endpoint-servicebus-topic';
export * as iothubEndpointStorageContainer from './iothub-endpoint-storage-container';
export * as iothubEnrichment from './iothub-enrichment';
export * as iothubFallbackRoute from './iothub-fallback-route';
export * as iothubFileUpload from './iothub-file-upload';
export * as iothubRoute from './iothub-route';
export * as iothubSharedAccessPolicy from './iothub-shared-access-policy';
export * as ipGroup from './ip-group';
export * as ipGroupCidr from './ip-group-cidr';
export * as keyVault from './key-vault';
export * as keyVaultAccessPolicy from './key-vault-access-policy';
export * as keyVaultCertificate from './key-vault-certificate';
export * as keyVaultCertificateContacts from './key-vault-certificate-contacts';
export * as keyVaultCertificateIssuer from './key-vault-certificate-issuer';
export * as keyVaultKey from './key-vault-key';
export * as keyVaultManagedHardwareSecurityModule from './key-vault-managed-hardware-security-module';
export * as keyVaultManagedHardwareSecurityModuleRoleAssignment from './key-vault-managed-hardware-security-module-role-assignment';
export * as keyVaultManagedHardwareSecurityModuleRoleDefinition from './key-vault-managed-hardware-security-module-role-definition';
export * as keyVaultManagedStorageAccount from './key-vault-managed-storage-account';
export * as keyVaultManagedStorageAccountSasTokenDefinition from './key-vault-managed-storage-account-sas-token-definition';
export * as keyVaultSecret from './key-vault-secret';
export * as kubernetesCluster from './kubernetes-cluster';
export * as kubernetesClusterExtension from './kubernetes-cluster-extension';
export * as kubernetesClusterNodePool from './kubernetes-cluster-node-pool';
export * as kubernetesClusterTrustedAccessRoleBinding from './kubernetes-cluster-trusted-access-role-binding';
export * as kubernetesFleetManager from './kubernetes-fleet-manager';
export * as kubernetesFluxConfiguration from './kubernetes-flux-configuration';
export * as kustoAttachedDatabaseConfiguration from './kusto-attached-database-configuration';
export * as kustoCluster from './kusto-cluster';
export * as kustoClusterCustomerManagedKey from './kusto-cluster-customer-managed-key';
export * as kustoClusterManagedPrivateEndpoint from './kusto-cluster-managed-private-endpoint';
export * as kustoClusterPrincipalAssignment from './kusto-cluster-principal-assignment';
export * as kustoCosmosdbDataConnection from './kusto-cosmosdb-data-connection';
export * as kustoDatabase from './kusto-database';
export * as kustoDatabasePrincipalAssignment from './kusto-database-principal-assignment';
export * as kustoEventgridDataConnection from './kusto-eventgrid-data-connection';
export * as kustoEventhubDataConnection from './kusto-eventhub-data-connection';
export * as kustoIothubDataConnection from './kusto-iothub-data-connection';
export * as kustoScript from './kusto-script';
export * as labServiceLab from './lab-service-lab';
export * as labServicePlan from './lab-service-plan';
export * as labServiceSchedule from './lab-service-schedule';
export * as labServiceUser from './lab-service-user';
export * as lb from './lb';
export * as lbBackendAddressPool from './lb-backend-address-pool';
export * as lbBackendAddressPoolAddress from './lb-backend-address-pool-address';
export * as lbNatPool from './lb-nat-pool';
export * as lbNatRule from './lb-nat-rule';
export * as lbOutboundRule from './lb-outbound-rule';
export * as lbProbe from './lb-probe';
export * as lbRule from './lb-rule';
export * as lighthouseAssignment from './lighthouse-assignment';
export * as lighthouseDefinition from './lighthouse-definition';
export * as linuxFunctionApp from './linux-function-app';
export * as linuxFunctionAppSlot from './linux-function-app-slot';
export * as linuxVirtualMachine from './linux-virtual-machine';
export * as linuxVirtualMachineScaleSet from './linux-virtual-machine-scale-set';
export * as linuxWebApp from './linux-web-app';
export * as linuxWebAppSlot from './linux-web-app-slot';
export * as loadTest from './load-test';
export * as localNetworkGateway from './local-network-gateway';
export * as logAnalyticsCluster from './log-analytics-cluster';
export * as logAnalyticsClusterCustomerManagedKey from './log-analytics-cluster-customer-managed-key';
export * as logAnalyticsDataExportRule from './log-analytics-data-export-rule';
export * as logAnalyticsDatasourceWindowsEvent from './log-analytics-datasource-windows-event';
export * as logAnalyticsDatasourceWindowsPerformanceCounter from './log-analytics-datasource-windows-performance-counter';
export * as logAnalyticsLinkedService from './log-analytics-linked-service';
export * as logAnalyticsLinkedStorageAccount from './log-analytics-linked-storage-account';
export * as logAnalyticsQueryPack from './log-analytics-query-pack';
export * as logAnalyticsQueryPackQuery from './log-analytics-query-pack-query';
export * as logAnalyticsSavedSearch from './log-analytics-saved-search';
export * as logAnalyticsSolution from './log-analytics-solution';
export * as logAnalyticsStorageInsights from './log-analytics-storage-insights';
export * as logAnalyticsWorkspace from './log-analytics-workspace';
export * as logicAppActionCustom from './logic-app-action-custom';
export * as logicAppActionHttp from './logic-app-action-http';
export * as logicAppIntegrationAccount from './logic-app-integration-account';
export * as logicAppIntegrationAccountAgreement from './logic-app-integration-account-agreement';
export * as logicAppIntegrationAccountAssembly from './logic-app-integration-account-assembly';
export * as logicAppIntegrationAccountBatchConfiguration from './logic-app-integration-account-batch-configuration';
export * as logicAppIntegrationAccountCertificate from './logic-app-integration-account-certificate';
export * as logicAppIntegrationAccountMap from './logic-app-integration-account-map';
export * as logicAppIntegrationAccountPartner from './logic-app-integration-account-partner';
export * as logicAppIntegrationAccountSchema from './logic-app-integration-account-schema';
export * as logicAppIntegrationAccountSession from './logic-app-integration-account-session';
export * as logicAppStandard from './logic-app-standard';
export * as logicAppTriggerCustom from './logic-app-trigger-custom';
export * as logicAppTriggerHttpRequest from './logic-app-trigger-http-request';
export * as logicAppTriggerRecurrence from './logic-app-trigger-recurrence';
export * as logicAppWorkflow from './logic-app-workflow';
export * as logzMonitor from './logz-monitor';
export * as logzSubAccount from './logz-sub-account';
export * as logzSubAccountTagRule from './logz-sub-account-tag-rule';
export * as logzTagRule from './logz-tag-rule';
export * as machineLearningComputeCluster from './machine-learning-compute-cluster';
export * as machineLearningComputeInstance from './machine-learning-compute-instance';
export * as machineLearningDatastoreBlobstorage from './machine-learning-datastore-blobstorage';
export * as machineLearningDatastoreDatalakeGen2 from './machine-learning-datastore-datalake-gen2';
export * as machineLearningDatastoreFileshare from './machine-learning-datastore-fileshare';
export * as machineLearningInferenceCluster from './machine-learning-inference-cluster';
export * as machineLearningSynapseSpark from './machine-learning-synapse-spark';
export * as machineLearningWorkspace from './machine-learning-workspace';
export * as maintenanceAssignmentDedicatedHost from './maintenance-assignment-dedicated-host';
export * as maintenanceAssignmentVirtualMachine from './maintenance-assignment-virtual-machine';
export * as maintenanceAssignmentVirtualMachineScaleSet from './maintenance-assignment-virtual-machine-scale-set';
export * as maintenanceConfiguration from './maintenance-configuration';
export * as managedApplication from './managed-application';
export * as managedApplicationDefinition from './managed-application-definition';
export * as managedDisk from './managed-disk';
export * as managedDiskSasToken from './managed-disk-sas-token';
export * as managedLustreFileSystem from './managed-lustre-file-system';
export * as managementGroup from './management-group';
export * as managementGroupPolicyAssignment from './management-group-policy-assignment';
export * as managementGroupPolicyExemption from './management-group-policy-exemption';
export * as managementGroupPolicyRemediation from './management-group-policy-remediation';
export * as managementGroupSubscriptionAssociation from './management-group-subscription-association';
export * as managementGroupTemplateDeployment from './management-group-template-deployment';
export * as managementLock from './management-lock';
export * as mapsAccount from './maps-account';
export * as mapsCreator from './maps-creator';
export * as mariadbConfiguration from './mariadb-configuration';
export * as mariadbDatabase from './mariadb-database';
export * as mariadbFirewallRule from './mariadb-firewall-rule';
export * as mariadbServer from './mariadb-server';
export * as mariadbVirtualNetworkRule from './mariadb-virtual-network-rule';
export * as marketplaceAgreement from './marketplace-agreement';
export * as marketplaceRoleAssignment from './marketplace-role-assignment';
export * as mediaAsset from './media-asset';
export * as mediaAssetFilter from './media-asset-filter';
export * as mediaContentKeyPolicy from './media-content-key-policy';
export * as mediaJob from './media-job';
export * as mediaLiveEvent from './media-live-event';
export * as mediaLiveEventOutput from './media-live-event-output';
export * as mediaServicesAccount from './media-services-account';
export * as mediaServicesAccountFilter from './media-services-account-filter';
export * as mediaStreamingEndpoint from './media-streaming-endpoint';
export * as mediaStreamingLocator from './media-streaming-locator';
export * as mediaStreamingPolicy from './media-streaming-policy';
export * as mediaTransform from './media-transform';
export * as mobileNetwork from './mobile-network';
export * as mobileNetworkAttachedDataNetwork from './mobile-network-attached-data-network';
export * as mobileNetworkDataNetwork from './mobile-network-data-network';
export * as mobileNetworkPacketCoreControlPlane from './mobile-network-packet-core-control-plane';
export * as mobileNetworkPacketCoreDataPlane from './mobile-network-packet-core-data-plane';
export * as mobileNetworkService from './mobile-network-service';
export * as mobileNetworkSim from './mobile-network-sim';
export * as mobileNetworkSimGroup from './mobile-network-sim-group';
export * as mobileNetworkSimPolicy from './mobile-network-sim-policy';
export * as mobileNetworkSite from './mobile-network-site';
export * as mobileNetworkSlice from './mobile-network-slice';
export * as monitorAadDiagnosticSetting from './monitor-aad-diagnostic-setting';
export * as monitorActionGroup from './monitor-action-group';
export * as monitorActionRuleActionGroup from './monitor-action-rule-action-group';
export * as monitorActionRuleSuppression from './monitor-action-rule-suppression';
export * as monitorActivityLogAlert from './monitor-activity-log-alert';
export * as monitorAlertProcessingRuleActionGroup from './monitor-alert-processing-rule-action-group';
export * as monitorAlertProcessingRuleSuppression from './monitor-alert-processing-rule-suppression';
export * as monitorAlertPrometheusRuleGroup from './monitor-alert-prometheus-rule-group';
export * as monitorAutoscaleSetting from './monitor-autoscale-setting';
export * as monitorDataCollectionEndpoint from './monitor-data-collection-endpoint';
export * as monitorDataCollectionRule from './monitor-data-collection-rule';
export * as monitorDataCollectionRuleAssociation from './monitor-data-collection-rule-association';
export * as monitorDiagnosticSetting from './monitor-diagnostic-setting';
export * as monitorLogProfile from './monitor-log-profile';
export * as monitorMetricAlert from './monitor-metric-alert';
export * as monitorPrivateLinkScope from './monitor-private-link-scope';
export * as monitorPrivateLinkScopedService from './monitor-private-link-scoped-service';
export * as monitorScheduledQueryRulesAlert from './monitor-scheduled-query-rules-alert';
export * as monitorScheduledQueryRulesAlertV2 from './monitor-scheduled-query-rules-alert-v2';
export * as monitorScheduledQueryRulesLog from './monitor-scheduled-query-rules-log';
export * as monitorSmartDetectorAlertRule from './monitor-smart-detector-alert-rule';
export * as monitorWorkspace from './monitor-workspace';
export * as mssqlDatabase from './mssql-database';
export * as mssqlDatabaseExtendedAuditingPolicy from './mssql-database-extended-auditing-policy';
export * as mssqlDatabaseVulnerabilityAssessmentRuleBaseline from './mssql-database-vulnerability-assessment-rule-baseline';
export * as mssqlElasticpool from './mssql-elasticpool';
export * as mssqlFailoverGroup from './mssql-failover-group';
export * as mssqlFirewallRule from './mssql-firewall-rule';
export * as mssqlJobAgent from './mssql-job-agent';
export * as mssqlJobCredential from './mssql-job-credential';
export * as mssqlManagedDatabase from './mssql-managed-database';
export * as mssqlManagedInstance from './mssql-managed-instance';
export * as mssqlManagedInstanceActiveDirectoryAdministrator from './mssql-managed-instance-active-directory-administrator';
export * as mssqlManagedInstanceFailoverGroup from './mssql-managed-instance-failover-group';
export * as mssqlManagedInstanceSecurityAlertPolicy from './mssql-managed-instance-security-alert-policy';
export * as mssqlManagedInstanceTransparentDataEncryption from './mssql-managed-instance-transparent-data-encryption';
export * as mssqlManagedInstanceVulnerabilityAssessment from './mssql-managed-instance-vulnerability-assessment';
export * as mssqlOutboundFirewallRule from './mssql-outbound-firewall-rule';
export * as mssqlServer from './mssql-server';
export * as mssqlServerDnsAlias from './mssql-server-dns-alias';
export * as mssqlServerExtendedAuditingPolicy from './mssql-server-extended-auditing-policy';
export * as mssqlServerMicrosoftSupportAuditingPolicy from './mssql-server-microsoft-support-auditing-policy';
export * as mssqlServerSecurityAlertPolicy from './mssql-server-security-alert-policy';
export * as mssqlServerTransparentDataEncryption from './mssql-server-transparent-data-encryption';
export * as mssqlServerVulnerabilityAssessment from './mssql-server-vulnerability-assessment';
export * as mssqlVirtualMachine from './mssql-virtual-machine';
export * as mssqlVirtualMachineAvailabilityGroupListener from './mssql-virtual-machine-availability-group-listener';
export * as mssqlVirtualMachineGroup from './mssql-virtual-machine-group';
export * as mssqlVirtualNetworkRule from './mssql-virtual-network-rule';
export * as mysqlActiveDirectoryAdministrator from './mysql-active-directory-administrator';
export * as mysqlConfiguration from './mysql-configuration';
export * as mysqlDatabase from './mysql-database';
export * as mysqlFirewallRule from './mysql-firewall-rule';
export * as mysqlFlexibleDatabase from './mysql-flexible-database';
export * as mysqlFlexibleServer from './mysql-flexible-server';
export * as mysqlFlexibleServerActiveDirectoryAdministrator from './mysql-flexible-server-active-directory-administrator';
export * as mysqlFlexibleServerConfiguration from './mysql-flexible-server-configuration';
export * as mysqlFlexibleServerFirewallRule from './mysql-flexible-server-firewall-rule';
export * as mysqlServer from './mysql-server';
export * as mysqlServerKey from './mysql-server-key';
export * as mysqlVirtualNetworkRule from './mysql-virtual-network-rule';
export * as natGateway from './nat-gateway';
export * as natGatewayPublicIpAssociation from './nat-gateway-public-ip-association';
export * as natGatewayPublicIpPrefixAssociation from './nat-gateway-public-ip-prefix-association';
export * as netappAccount from './netapp-account';
export * as netappPool from './netapp-pool';
export * as netappSnapshot from './netapp-snapshot';
export * as netappSnapshotPolicy from './netapp-snapshot-policy';
export * as netappVolume from './netapp-volume';
export * as netappVolumeGroupSapHana from './netapp-volume-group-sap-hana';
export * as netappVolumeQuotaRule from './netapp-volume-quota-rule';
export * as networkConnectionMonitor from './network-connection-monitor';
export * as networkDdosProtectionPlan from './network-ddos-protection-plan';
export * as networkFunctionAzureTrafficCollector from './network-function-azure-traffic-collector';
export * as networkFunctionCollectorPolicy from './network-function-collector-policy';
export * as networkInterface from './network-interface';
export * as networkInterfaceApplicationGatewayBackendAddressPoolAssociation from './network-interface-application-gateway-backend-address-pool-association';
export * as networkInterfaceApplicationSecurityGroupAssociation from './network-interface-application-security-group-association';
export * as networkInterfaceBackendAddressPoolAssociation from './network-interface-backend-address-pool-association';
export * as networkInterfaceNatRuleAssociation from './network-interface-nat-rule-association';
export * as networkInterfaceSecurityGroupAssociation from './network-interface-security-group-association';
export * as networkManager from './network-manager';
export * as networkManagerAdminRule from './network-manager-admin-rule';
export * as networkManagerAdminRuleCollection from './network-manager-admin-rule-collection';
export * as networkManagerConnectivityConfiguration from './network-manager-connectivity-configuration';
export * as networkManagerDeployment from './network-manager-deployment';
export * as networkManagerManagementGroupConnection from './network-manager-management-group-connection';
export * as networkManagerNetworkGroup from './network-manager-network-group';
export * as networkManagerScopeConnection from './network-manager-scope-connection';
export * as networkManagerSecurityAdminConfiguration from './network-manager-security-admin-configuration';
export * as networkManagerStaticMember from './network-manager-static-member';
export * as networkManagerSubscriptionConnection from './network-manager-subscription-connection';
export * as networkPacketCapture from './network-packet-capture';
export * as networkProfile from './network-profile';
export * as networkSecurityGroup from './network-security-group';
export * as networkSecurityRule from './network-security-rule';
export * as networkWatcher from './network-watcher';
export * as networkWatcherFlowLog from './network-watcher-flow-log';
export * as newRelicMonitor from './new-relic-monitor';
export * as newRelicTagRule from './new-relic-tag-rule';
export * as nginxCertificate from './nginx-certificate';
export * as nginxConfiguration from './nginx-configuration';
export * as nginxDeployment from './nginx-deployment';
export * as notificationHub from './notification-hub';
export * as notificationHubAuthorizationRule from './notification-hub-authorization-rule';
export * as notificationHubNamespace from './notification-hub-namespace';
export * as orbitalContact from './orbital-contact';
export * as orbitalContactProfile from './orbital-contact-profile';
export * as orbitalSpacecraft from './orbital-spacecraft';
export * as orchestratedVirtualMachineScaleSet from './orchestrated-virtual-machine-scale-set';
export * as paloAltoLocalRulestack from './palo-alto-local-rulestack';
export * as paloAltoLocalRulestackCertificate from './palo-alto-local-rulestack-certificate';
export * as paloAltoLocalRulestackFqdnList from './palo-alto-local-rulestack-fqdn-list';
export * as paloAltoLocalRulestackOutboundTrustCertificateAssociation from './palo-alto-local-rulestack-outbound-trust-certificate-association';
export * as paloAltoLocalRulestackOutboundUntrustCertificateAssociation from './palo-alto-local-rulestack-outbound-untrust-certificate-association';
export * as paloAltoLocalRulestackPrefixList from './palo-alto-local-rulestack-prefix-list';
export * as paloAltoLocalRulestackRule from './palo-alto-local-rulestack-rule';
export * as paloAltoNextGenerationFirewallVirtualHubLocalRulestack from './palo-alto-next-generation-firewall-virtual-hub-local-rulestack';
export * as paloAltoNextGenerationFirewallVirtualHubPanorama from './palo-alto-next-generation-firewall-virtual-hub-panorama';
export * as paloAltoNextGenerationFirewallVirtualNetworkLocalRulestack from './palo-alto-next-generation-firewall-virtual-network-local-rulestack';
export * as paloAltoNextGenerationFirewallVirtualNetworkPanorama from './palo-alto-next-generation-firewall-virtual-network-panorama';
export * as paloAltoVirtualNetworkAppliance from './palo-alto-virtual-network-appliance';
export * as pimActiveRoleAssignment from './pim-active-role-assignment';
export * as pimEligibleRoleAssignment from './pim-eligible-role-assignment';
export * as pointToSiteVpnGateway from './point-to-site-vpn-gateway';
export * as policyDefinition from './policy-definition';
export * as policySetDefinition from './policy-set-definition';
export * as policyVirtualMachineConfigurationAssignment from './policy-virtual-machine-configuration-assignment';
export * as portalDashboard from './portal-dashboard';
export * as portalTenantConfiguration from './portal-tenant-configuration';
export * as postgresqlActiveDirectoryAdministrator from './postgresql-active-directory-administrator';
export * as postgresqlConfiguration from './postgresql-configuration';
export * as postgresqlDatabase from './postgresql-database';
export * as postgresqlFirewallRule from './postgresql-firewall-rule';
export * as postgresqlFlexibleServer from './postgresql-flexible-server';
export * as postgresqlFlexibleServerActiveDirectoryAdministrator from './postgresql-flexible-server-active-directory-administrator';
export * as postgresqlFlexibleServerConfiguration from './postgresql-flexible-server-configuration';
export * as postgresqlFlexibleServerDatabase from './postgresql-flexible-server-database';
export * as postgresqlFlexibleServerFirewallRule from './postgresql-flexible-server-firewall-rule';
export * as postgresqlServer from './postgresql-server';
export * as postgresqlServerKey from './postgresql-server-key';
export * as postgresqlVirtualNetworkRule from './postgresql-virtual-network-rule';
export * as powerbiEmbedded from './powerbi-embedded';
export * as privateDnsARecord from './private-dns-a-record';
export * as privateDnsAaaaRecord from './private-dns-aaaa-record';
export * as privateDnsCnameRecord from './private-dns-cname-record';
export * as privateDnsMxRecord from './private-dns-mx-record';
export * as privateDnsPtrRecord from './private-dns-ptr-record';
export * as privateDnsResolver from './private-dns-resolver';
export * as privateDnsResolverDnsForwardingRuleset from './private-dns-resolver-dns-forwarding-ruleset';
export * as privateDnsResolverForwardingRule from './private-dns-resolver-forwarding-rule';
export * as privateDnsResolverInboundEndpoint from './private-dns-resolver-inbound-endpoint';
export * as privateDnsResolverOutboundEndpoint from './private-dns-resolver-outbound-endpoint';
export * as privateDnsResolverVirtualNetworkLink from './private-dns-resolver-virtual-network-link';
export * as privateDnsSrvRecord from './private-dns-srv-record';
export * as privateDnsTxtRecord from './private-dns-txt-record';
export * as privateDnsZone from './private-dns-zone';
export * as privateDnsZoneVirtualNetworkLink from './private-dns-zone-virtual-network-link';
export * as privateEndpoint from './private-endpoint';
export * as privateEndpointApplicationSecurityGroupAssociation from './private-endpoint-application-security-group-association';
export * as privateLinkService from './private-link-service';
export * as proximityPlacementGroup from './proximity-placement-group';
export * as publicIp from './public-ip';
export * as publicIpPrefix from './public-ip-prefix';
export * as purviewAccount from './purview-account';
export * as recoveryServicesVault from './recovery-services-vault';
export * as recoveryServicesVaultResourceGuardAssociation from './recovery-services-vault-resource-guard-association';
export * as redisCache from './redis-cache';
export * as redisEnterpriseCluster from './redis-enterprise-cluster';
export * as redisEnterpriseDatabase from './redis-enterprise-database';
export * as redisFirewallRule from './redis-firewall-rule';
export * as redisLinkedServer from './redis-linked-server';
export * as relayHybridConnection from './relay-hybrid-connection';
export * as relayHybridConnectionAuthorizationRule from './relay-hybrid-connection-authorization-rule';
export * as relayNamespace from './relay-namespace';
export * as relayNamespaceAuthorizationRule from './relay-namespace-authorization-rule';
export * as resourceDeploymentScriptAzureCli from './resource-deployment-script-azure-cli';
export * as resourceDeploymentScriptAzurePowerShell from './resource-deployment-script-azure-power-shell';
export * as resourceGroup from './resource-group';
export * as resourceGroupCostManagementExport from './resource-group-cost-management-export';
export * as resourceGroupCostManagementView from './resource-group-cost-management-view';
export * as resourceGroupPolicyAssignment from './resource-group-policy-assignment';
export * as resourceGroupPolicyExemption from './resource-group-policy-exemption';
export * as resourceGroupPolicyRemediation from './resource-group-policy-remediation';
export * as resourceGroupTemplateDeployment from './resource-group-template-deployment';
export * as resourceManagementPrivateLink from './resource-management-private-link';
export * as resourceManagementPrivateLinkAssociation from './resource-management-private-link-association';
export * as resourcePolicyAssignment from './resource-policy-assignment';
export * as resourcePolicyExemption from './resource-policy-exemption';
export * as resourcePolicyRemediation from './resource-policy-remediation';
export * as resourceProviderRegistration from './resource-provider-registration';
export * as roleAssignment from './role-assignment';
export * as roleDefinition from './role-definition';
export * as route from './route';
export * as routeFilter from './route-filter';
export * as routeMap from './route-map';
export * as routeServer from './route-server';
export * as routeServerBgpConnection from './route-server-bgp-connection';
export * as routeTable from './route-table';
export * as searchService from './search-service';
export * as searchSharedPrivateLinkService from './search-shared-private-link-service';
export * as securityCenterAssessment from './security-center-assessment';
export * as securityCenterAssessmentPolicy from './security-center-assessment-policy';
export * as securityCenterAutoProvisioning from './security-center-auto-provisioning';
export * as securityCenterAutomation from './security-center-automation';
export * as securityCenterContact from './security-center-contact';
export * as securityCenterServerVulnerabilityAssessment from './security-center-server-vulnerability-assessment';
export * as securityCenterServerVulnerabilityAssessmentVirtualMachine from './security-center-server-vulnerability-assessment-virtual-machine';
export * as securityCenterSetting from './security-center-setting';
export * as securityCenterStorageDefender from './security-center-storage-defender';
export * as securityCenterSubscriptionPricing from './security-center-subscription-pricing';
export * as securityCenterWorkspace from './security-center-workspace';
export * as sentinelAlertRuleAnomalyBuiltIn from './sentinel-alert-rule-anomaly-built-in';
export * as sentinelAlertRuleAnomalyDuplicate from './sentinel-alert-rule-anomaly-duplicate';
export * as sentinelAlertRuleFusion from './sentinel-alert-rule-fusion';
export * as sentinelAlertRuleMachineLearningBehaviorAnalytics from './sentinel-alert-rule-machine-learning-behavior-analytics';
export * as sentinelAlertRuleMsSecurityIncident from './sentinel-alert-rule-ms-security-incident';
export * as sentinelAlertRuleNrt from './sentinel-alert-rule-nrt';
export * as sentinelAlertRuleScheduled from './sentinel-alert-rule-scheduled';
export * as sentinelAlertRuleThreatIntelligence from './sentinel-alert-rule-threat-intelligence';
export * as sentinelAutomationRule from './sentinel-automation-rule';
export * as sentinelDataConnectorAwsCloudTrail from './sentinel-data-connector-aws-cloud-trail';
export * as sentinelDataConnectorAwsS3 from './sentinel-data-connector-aws-s3';
export * as sentinelDataConnectorAzureActiveDirectory from './sentinel-data-connector-azure-active-directory';
export * as sentinelDataConnectorAzureAdvancedThreatProtection from './sentinel-data-connector-azure-advanced-threat-protection';
export * as sentinelDataConnectorAzureSecurityCenter from './sentinel-data-connector-azure-security-center';
export * as sentinelDataConnectorDynamics365 from './sentinel-data-connector-dynamics-365';
export * as sentinelDataConnectorIot from './sentinel-data-connector-iot';
export * as sentinelDataConnectorMicrosoftCloudAppSecurity from './sentinel-data-connector-microsoft-cloud-app-security';
export * as sentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection from './sentinel-data-connector-microsoft-defender-advanced-threat-protection';
export * as sentinelDataConnectorMicrosoftThreatIntelligence from './sentinel-data-connector-microsoft-threat-intelligence';
export * as sentinelDataConnectorMicrosoftThreatProtection from './sentinel-data-connector-microsoft-threat-protection';
export * as sentinelDataConnectorOffice365 from './sentinel-data-connector-office-365';
export * as sentinelDataConnectorOffice365Project from './sentinel-data-connector-office-365-project';
export * as sentinelDataConnectorOfficeAtp from './sentinel-data-connector-office-atp';
export * as sentinelDataConnectorOfficeIrm from './sentinel-data-connector-office-irm';
export * as sentinelDataConnectorOfficePowerBi from './sentinel-data-connector-office-power-bi';
export * as sentinelDataConnectorThreatIntelligence from './sentinel-data-connector-threat-intelligence';
export * as sentinelDataConnectorThreatIntelligenceTaxii from './sentinel-data-connector-threat-intelligence-taxii';
export * as sentinelLogAnalyticsWorkspaceOnboarding from './sentinel-log-analytics-workspace-onboarding';
export * as sentinelMetadata from './sentinel-metadata';
export * as sentinelThreatIntelligenceIndicator from './sentinel-threat-intelligence-indicator';
export * as sentinelWatchlist from './sentinel-watchlist';
export * as sentinelWatchlistItem from './sentinel-watchlist-item';
export * as serviceFabricCluster from './service-fabric-cluster';
export * as serviceFabricManagedCluster from './service-fabric-managed-cluster';
export * as servicePlan from './service-plan';
export * as servicebusNamespace from './servicebus-namespace';
export * as servicebusNamespaceAuthorizationRule from './servicebus-namespace-authorization-rule';
export * as servicebusNamespaceDisasterRecoveryConfig from './servicebus-namespace-disaster-recovery-config';
export * as servicebusNamespaceNetworkRuleSet from './servicebus-namespace-network-rule-set';
export * as servicebusQueue from './servicebus-queue';
export * as servicebusQueueAuthorizationRule from './servicebus-queue-authorization-rule';
export * as servicebusSubscription from './servicebus-subscription';
export * as servicebusSubscriptionRule from './servicebus-subscription-rule';
export * as servicebusTopic from './servicebus-topic';
export * as servicebusTopicAuthorizationRule from './servicebus-topic-authorization-rule';
export * as sharedImage from './shared-image';
export * as sharedImageGallery from './shared-image-gallery';
export * as sharedImageVersion from './shared-image-version';
export * as signalrService from './signalr-service';
export * as signalrServiceCustomCertificate from './signalr-service-custom-certificate';
export * as signalrServiceCustomDomain from './signalr-service-custom-domain';
export * as signalrServiceNetworkAcl from './signalr-service-network-acl';
export * as signalrSharedPrivateLinkResource from './signalr-shared-private-link-resource';
export * as siteRecoveryFabric from './site-recovery-fabric';
export * as siteRecoveryHypervNetworkMapping from './site-recovery-hyperv-network-mapping';
export * as siteRecoveryHypervReplicationPolicy from './site-recovery-hyperv-replication-policy';
export * as siteRecoveryHypervReplicationPolicyAssociation from './site-recovery-hyperv-replication-policy-association';
export * as siteRecoveryNetworkMapping from './site-recovery-network-mapping';
export * as siteRecoveryProtectionContainer from './site-recovery-protection-container';
export * as siteRecoveryProtectionContainerMapping from './site-recovery-protection-container-mapping';
export * as siteRecoveryReplicatedVm from './site-recovery-replicated-vm';
export * as siteRecoveryReplicationPolicy from './site-recovery-replication-policy';
export * as siteRecoveryReplicationRecoveryPlan from './site-recovery-replication-recovery-plan';
export * as siteRecoveryServicesVaultHypervSite from './site-recovery-services-vault-hyperv-site';
export * as siteRecoveryVmwareReplicationPolicy from './site-recovery-vmware-replication-policy';
export * as siteRecoveryVmwareReplicationPolicyAssociation from './site-recovery-vmware-replication-policy-association';
export * as snapshot from './snapshot';
export * as sourceControlToken from './source-control-token';
export * as spatialAnchorsAccount from './spatial-anchors-account';
export * as springCloudAccelerator from './spring-cloud-accelerator';
export * as springCloudActiveDeployment from './spring-cloud-active-deployment';
export * as springCloudApiPortal from './spring-cloud-api-portal';
export * as springCloudApiPortalCustomDomain from './spring-cloud-api-portal-custom-domain';
export * as springCloudApp from './spring-cloud-app';
export * as springCloudAppCosmosdbAssociation from './spring-cloud-app-cosmosdb-association';
export * as springCloudAppMysqlAssociation from './spring-cloud-app-mysql-association';
export * as springCloudAppRedisAssociation from './spring-cloud-app-redis-association';
export * as springCloudApplicationInsightsApplicationPerformanceMonitoring from './spring-cloud-application-insights-application-performance-monitoring';
export * as springCloudApplicationLiveView from './spring-cloud-application-live-view';
export * as springCloudBuildDeployment from './spring-cloud-build-deployment';
export * as springCloudBuildPackBinding from './spring-cloud-build-pack-binding';
export * as springCloudBuilder from './spring-cloud-builder';
export * as springCloudCertificate from './spring-cloud-certificate';
export * as springCloudConfigurationService from './spring-cloud-configuration-service';
export * as springCloudConnection from './spring-cloud-connection';
export * as springCloudContainerDeployment from './spring-cloud-container-deployment';
export * as springCloudCustomDomain from './spring-cloud-custom-domain';
export * as springCloudCustomizedAccelerator from './spring-cloud-customized-accelerator';
export * as springCloudDevToolPortal from './spring-cloud-dev-tool-portal';
export * as springCloudGateway from './spring-cloud-gateway';
export * as springCloudGatewayCustomDomain from './spring-cloud-gateway-custom-domain';
export * as springCloudGatewayRouteConfig from './spring-cloud-gateway-route-config';
export * as springCloudJavaDeployment from './spring-cloud-java-deployment';
export * as springCloudService from './spring-cloud-service';
export * as springCloudStorage from './spring-cloud-storage';
export * as sqlActiveDirectoryAdministrator from './sql-active-directory-administrator';
export * as sqlDatabase from './sql-database';
export * as sqlElasticpool from './sql-elasticpool';
export * as sqlFailoverGroup from './sql-failover-group';
export * as sqlFirewallRule from './sql-firewall-rule';
export * as sqlManagedDatabase from './sql-managed-database';
export * as sqlManagedInstance from './sql-managed-instance';
export * as sqlManagedInstanceActiveDirectoryAdministrator from './sql-managed-instance-active-directory-administrator';
export * as sqlManagedInstanceFailoverGroup from './sql-managed-instance-failover-group';
export * as sqlServer from './sql-server';
export * as sqlVirtualNetworkRule from './sql-virtual-network-rule';
export * as sshPublicKey from './ssh-public-key';
export * as stackHciCluster from './stack-hci-cluster';
export * as staticSite from './static-site';
export * as staticSiteCustomDomain from './static-site-custom-domain';
export * as storageAccount from './storage-account';
export * as storageAccountCustomerManagedKey from './storage-account-customer-managed-key';
export * as storageAccountLocalUser from './storage-account-local-user';
export * as storageAccountNetworkRules from './storage-account-network-rules';
export * as storageBlob from './storage-blob';
export * as storageBlobInventoryPolicy from './storage-blob-inventory-policy';
export * as storageContainer from './storage-container';
export * as storageDataLakeGen2Filesystem from './storage-data-lake-gen2-filesystem';
export * as storageDataLakeGen2Path from './storage-data-lake-gen2-path';
export * as storageEncryptionScope from './storage-encryption-scope';
export * as storageManagementPolicy from './storage-management-policy';
export * as storageMover from './storage-mover';
export * as storageMoverAgent from './storage-mover-agent';
export * as storageMoverJobDefinition from './storage-mover-job-definition';
export * as storageMoverProject from './storage-mover-project';
export * as storageMoverSourceEndpoint from './storage-mover-source-endpoint';
export * as storageMoverTargetEndpoint from './storage-mover-target-endpoint';
export * as storageObjectReplication from './storage-object-replication';
export * as storageQueue from './storage-queue';
export * as storageShare from './storage-share';
export * as storageShareDirectory from './storage-share-directory';
export * as storageShareFile from './storage-share-file';
export * as storageSync from './storage-sync';
export * as storageSyncCloudEndpoint from './storage-sync-cloud-endpoint';
export * as storageSyncGroup from './storage-sync-group';
export * as storageTable from './storage-table';
export * as storageTableEntity from './storage-table-entity';
export * as streamAnalyticsCluster from './stream-analytics-cluster';
export * as streamAnalyticsFunctionJavascriptUda from './stream-analytics-function-javascript-uda';
export * as streamAnalyticsFunctionJavascriptUdf from './stream-analytics-function-javascript-udf';
export * as streamAnalyticsJob from './stream-analytics-job';
export * as streamAnalyticsJobSchedule from './stream-analytics-job-schedule';
export * as streamAnalyticsManagedPrivateEndpoint from './stream-analytics-managed-private-endpoint';
export * as streamAnalyticsOutputBlob from './stream-analytics-output-blob';
export * as streamAnalyticsOutputCosmosdb from './stream-analytics-output-cosmosdb';
export * as streamAnalyticsOutputEventhub from './stream-analytics-output-eventhub';
export * as streamAnalyticsOutputFunction from './stream-analytics-output-function';
export * as streamAnalyticsOutputMssql from './stream-analytics-output-mssql';
export * as streamAnalyticsOutputPowerbi from './stream-analytics-output-powerbi';
export * as streamAnalyticsOutputServicebusQueue from './stream-analytics-output-servicebus-queue';
export * as streamAnalyticsOutputServicebusTopic from './stream-analytics-output-servicebus-topic';
export * as streamAnalyticsOutputSynapse from './stream-analytics-output-synapse';
export * as streamAnalyticsOutputTable from './stream-analytics-output-table';
export * as streamAnalyticsReferenceInputBlob from './stream-analytics-reference-input-blob';
export * as streamAnalyticsReferenceInputMssql from './stream-analytics-reference-input-mssql';
export * as streamAnalyticsStreamInputBlob from './stream-analytics-stream-input-blob';
export * as streamAnalyticsStreamInputEventhub from './stream-analytics-stream-input-eventhub';
export * as streamAnalyticsStreamInputEventhubV2 from './stream-analytics-stream-input-eventhub-v2';
export * as streamAnalyticsStreamInputIothub from './stream-analytics-stream-input-iothub';
export * as subnet from './subnet';
export * as subnetNatGatewayAssociation from './subnet-nat-gateway-association';
export * as subnetNetworkSecurityGroupAssociation from './subnet-network-security-group-association';
export * as subnetRouteTableAssociation from './subnet-route-table-association';
export * as subnetServiceEndpointStoragePolicy from './subnet-service-endpoint-storage-policy';
export * as subscription from './subscription';
export * as subscriptionCostManagementExport from './subscription-cost-management-export';
export * as subscriptionCostManagementView from './subscription-cost-management-view';
export * as subscriptionPolicyAssignment from './subscription-policy-assignment';
export * as subscriptionPolicyExemption from './subscription-policy-exemption';
export * as subscriptionPolicyRemediation from './subscription-policy-remediation';
export * as subscriptionTemplateDeployment from './subscription-template-deployment';
export * as synapseFirewallRule from './synapse-firewall-rule';
export * as synapseIntegrationRuntimeAzure from './synapse-integration-runtime-azure';
export * as synapseIntegrationRuntimeSelfHosted from './synapse-integration-runtime-self-hosted';
export * as synapseLinkedService from './synapse-linked-service';
export * as synapseManagedPrivateEndpoint from './synapse-managed-private-endpoint';
export * as synapsePrivateLinkHub from './synapse-private-link-hub';
export * as synapseRoleAssignment from './synapse-role-assignment';
export * as synapseSparkPool from './synapse-spark-pool';
export * as synapseSqlPool from './synapse-sql-pool';
export * as synapseSqlPoolExtendedAuditingPolicy from './synapse-sql-pool-extended-auditing-policy';
export * as synapseSqlPoolSecurityAlertPolicy from './synapse-sql-pool-security-alert-policy';
export * as synapseSqlPoolVulnerabilityAssessment from './synapse-sql-pool-vulnerability-assessment';
export * as synapseSqlPoolVulnerabilityAssessmentBaseline from './synapse-sql-pool-vulnerability-assessment-baseline';
export * as synapseSqlPoolWorkloadClassifier from './synapse-sql-pool-workload-classifier';
export * as synapseSqlPoolWorkloadGroup from './synapse-sql-pool-workload-group';
export * as synapseWorkspace from './synapse-workspace';
export * as synapseWorkspaceAadAdmin from './synapse-workspace-aad-admin';
export * as synapseWorkspaceExtendedAuditingPolicy from './synapse-workspace-extended-auditing-policy';
export * as synapseWorkspaceKey from './synapse-workspace-key';
export * as synapseWorkspaceSecurityAlertPolicy from './synapse-workspace-security-alert-policy';
export * as synapseWorkspaceSqlAadAdmin from './synapse-workspace-sql-aad-admin';
export * as synapseWorkspaceVulnerabilityAssessment from './synapse-workspace-vulnerability-assessment';
export * as templateDeployment from './template-deployment';
export * as tenantTemplateDeployment from './tenant-template-deployment';
export * as trafficManagerAzureEndpoint from './traffic-manager-azure-endpoint';
export * as trafficManagerExternalEndpoint from './traffic-manager-external-endpoint';
export * as trafficManagerNestedEndpoint from './traffic-manager-nested-endpoint';
export * as trafficManagerProfile from './traffic-manager-profile';
export * as userAssignedIdentity from './user-assigned-identity';
export * as videoAnalyzer from './video-analyzer';
export * as videoAnalyzerEdgeModule from './video-analyzer-edge-module';
export * as virtualDesktopApplication from './virtual-desktop-application';
export * as virtualDesktopApplicationGroup from './virtual-desktop-application-group';
export * as virtualDesktopHostPool from './virtual-desktop-host-pool';
export * as virtualDesktopHostPoolRegistrationInfo from './virtual-desktop-host-pool-registration-info';
export * as virtualDesktopScalingPlan from './virtual-desktop-scaling-plan';
export * as virtualDesktopWorkspace from './virtual-desktop-workspace';
export * as virtualDesktopWorkspaceApplicationGroupAssociation from './virtual-desktop-workspace-application-group-association';
export * as virtualHub from './virtual-hub';
export * as virtualHubBgpConnection from './virtual-hub-bgp-connection';
export * as virtualHubConnection from './virtual-hub-connection';
export * as virtualHubIp from './virtual-hub-ip';
export * as virtualHubRouteTable from './virtual-hub-route-table';
export * as virtualHubRouteTableRoute from './virtual-hub-route-table-route';
export * as virtualHubRoutingIntent from './virtual-hub-routing-intent';
export * as virtualHubSecurityPartnerProvider from './virtual-hub-security-partner-provider';
export * as virtualMachine from './virtual-machine';
export * as virtualMachineDataDiskAttachment from './virtual-machine-data-disk-attachment';
export * as virtualMachineExtension from './virtual-machine-extension';
export * as virtualMachinePacketCapture from './virtual-machine-packet-capture';
export * as virtualMachineScaleSet from './virtual-machine-scale-set';
export * as virtualMachineScaleSetExtension from './virtual-machine-scale-set-extension';
export * as virtualMachineScaleSetPacketCapture from './virtual-machine-scale-set-packet-capture';
export * as virtualNetwork from './virtual-network';
export * as virtualNetworkDnsServers from './virtual-network-dns-servers';
export * as virtualNetworkGateway from './virtual-network-gateway';
export * as virtualNetworkGatewayConnection from './virtual-network-gateway-connection';
export * as virtualNetworkGatewayNatRule from './virtual-network-gateway-nat-rule';
export * as virtualNetworkPeering from './virtual-network-peering';
export * as virtualWan from './virtual-wan';
export * as vmwareCluster from './vmware-cluster';
export * as vmwareExpressRouteAuthorization from './vmware-express-route-authorization';
export * as vmwareNetappVolumeAttachment from './vmware-netapp-volume-attachment';
export * as vmwarePrivateCloud from './vmware-private-cloud';
export * as voiceServicesCommunicationsGateway from './voice-services-communications-gateway';
export * as voiceServicesCommunicationsGatewayTestLine from './voice-services-communications-gateway-test-line';
export * as vpnGateway from './vpn-gateway';
export * as vpnGatewayConnection from './vpn-gateway-connection';
export * as vpnGatewayNatRule from './vpn-gateway-nat-rule';
export * as vpnServerConfiguration from './vpn-server-configuration';
export * as vpnServerConfigurationPolicyGroup from './vpn-server-configuration-policy-group';
export * as vpnSite from './vpn-site';
export * as webAppActiveSlot from './web-app-active-slot';
export * as webAppHybridConnection from './web-app-hybrid-connection';
export * as webApplicationFirewallPolicy from './web-application-firewall-policy';
export * as webPubsub from './web-pubsub';
export * as webPubsubCustomCertificate from './web-pubsub-custom-certificate';
export * as webPubsubCustomDomain from './web-pubsub-custom-domain';
export * as webPubsubHub from './web-pubsub-hub';
export * as webPubsubNetworkAcl from './web-pubsub-network-acl';
export * as webPubsubSharedPrivateLinkResource from './web-pubsub-shared-private-link-resource';
export * as windowsFunctionApp from './windows-function-app';
export * as windowsFunctionAppSlot from './windows-function-app-slot';
export * as windowsVirtualMachine from './windows-virtual-machine';
export * as windowsVirtualMachineScaleSet from './windows-virtual-machine-scale-set';
export * as windowsWebApp from './windows-web-app';
export * as windowsWebAppSlot from './windows-web-app-slot';
export * as dataAzurermAadb2CDirectory from './data-azurerm-aadb2c-directory';
export * as dataAzurermActiveDirectoryDomainService from './data-azurerm-active-directory-domain-service';
export * as dataAzurermAdvisorRecommendations from './data-azurerm-advisor-recommendations';
export * as dataAzurermApiManagement from './data-azurerm-api-management';
export * as dataAzurermApiManagementApi from './data-azurerm-api-management-api';
export * as dataAzurermApiManagementApiVersionSet from './data-azurerm-api-management-api-version-set';
export * as dataAzurermApiManagementGateway from './data-azurerm-api-management-gateway';
export * as dataAzurermApiManagementGatewayHostNameConfiguration from './data-azurerm-api-management-gateway-host-name-configuration';
export * as dataAzurermApiManagementGroup from './data-azurerm-api-management-group';
export * as dataAzurermApiManagementProduct from './data-azurerm-api-management-product';
export * as dataAzurermApiManagementUser from './data-azurerm-api-management-user';
export * as dataAzurermAppConfiguration from './data-azurerm-app-configuration';
export * as dataAzurermAppConfigurationKey from './data-azurerm-app-configuration-key';
export * as dataAzurermAppConfigurationKeys from './data-azurerm-app-configuration-keys';
export * as dataAzurermAppService from './data-azurerm-app-service';
export * as dataAzurermAppServiceCertificate from './data-azurerm-app-service-certificate';
export * as dataAzurermAppServiceCertificateOrder from './data-azurerm-app-service-certificate-order';
export * as dataAzurermAppServiceEnvironment from './data-azurerm-app-service-environment';
export * as dataAzurermAppServiceEnvironmentV3 from './data-azurerm-app-service-environment-v3';
export * as dataAzurermAppServicePlan from './data-azurerm-app-service-plan';
export * as dataAzurermApplicationGateway from './data-azurerm-application-gateway';
export * as dataAzurermApplicationInsights from './data-azurerm-application-insights';
export * as dataAzurermApplicationSecurityGroup from './data-azurerm-application-security-group';
export * as dataAzurermArcMachine from './data-azurerm-arc-machine';
export * as dataAzurermAttestationProvider from './data-azurerm-attestation-provider';
export * as dataAzurermAutomationAccount from './data-azurerm-automation-account';
export * as dataAzurermAutomationVariableBool from './data-azurerm-automation-variable-bool';
export * as dataAzurermAutomationVariableDatetime from './data-azurerm-automation-variable-datetime';
export * as dataAzurermAutomationVariableInt from './data-azurerm-automation-variable-int';
export * as dataAzurermAutomationVariableObject from './data-azurerm-automation-variable-object';
export * as dataAzurermAutomationVariableString from './data-azurerm-automation-variable-string';
export * as dataAzurermAutomationVariables from './data-azurerm-automation-variables';
export * as dataAzurermAvailabilitySet from './data-azurerm-availability-set';
export * as dataAzurermBackupPolicyFileShare from './data-azurerm-backup-policy-file-share';
export * as dataAzurermBackupPolicyVm from './data-azurerm-backup-policy-vm';
export * as dataAzurermBastionHost from './data-azurerm-bastion-host';
export * as dataAzurermBatchAccount from './data-azurerm-batch-account';
export * as dataAzurermBatchApplication from './data-azurerm-batch-application';
export * as dataAzurermBatchCertificate from './data-azurerm-batch-certificate';
export * as dataAzurermBatchPool from './data-azurerm-batch-pool';
export * as dataAzurermBillingEnrollmentAccountScope from './data-azurerm-billing-enrollment-account-scope';
export * as dataAzurermBillingMcaAccountScope from './data-azurerm-billing-mca-account-scope';
export * as dataAzurermBillingMpaAccountScope from './data-azurerm-billing-mpa-account-scope';
export * as dataAzurermBlueprintDefinition from './data-azurerm-blueprint-definition';
export * as dataAzurermBlueprintPublishedVersion from './data-azurerm-blueprint-published-version';
export * as dataAzurermCdnFrontdoorCustomDomain from './data-azurerm-cdn-frontdoor-custom-domain';
export * as dataAzurermCdnFrontdoorEndpoint from './data-azurerm-cdn-frontdoor-endpoint';
export * as dataAzurermCdnFrontdoorFirewallPolicy from './data-azurerm-cdn-frontdoor-firewall-policy';
export * as dataAzurermCdnFrontdoorOriginGroup from './data-azurerm-cdn-frontdoor-origin-group';
export * as dataAzurermCdnFrontdoorProfile from './data-azurerm-cdn-frontdoor-profile';
export * as dataAzurermCdnFrontdoorRuleSet from './data-azurerm-cdn-frontdoor-rule-set';
export * as dataAzurermCdnFrontdoorSecret from './data-azurerm-cdn-frontdoor-secret';
export * as dataAzurermCdnProfile from './data-azurerm-cdn-profile';
export * as dataAzurermClientConfig from './data-azurerm-client-config';
export * as dataAzurermCognitiveAccount from './data-azurerm-cognitive-account';
export * as dataAzurermCommunicationService from './data-azurerm-communication-service';
export * as dataAzurermConfidentialLedger from './data-azurerm-confidential-ledger';
export * as dataAzurermConsumptionBudgetResourceGroup from './data-azurerm-consumption-budget-resource-group';
export * as dataAzurermConsumptionBudgetSubscription from './data-azurerm-consumption-budget-subscription';
export * as dataAzurermContainerApp from './data-azurerm-container-app';
export * as dataAzurermContainerAppEnvironment from './data-azurerm-container-app-environment';
export * as dataAzurermContainerAppEnvironmentCertificate from './data-azurerm-container-app-environment-certificate';
export * as dataAzurermContainerGroup from './data-azurerm-container-group';
export * as dataAzurermContainerRegistry from './data-azurerm-container-registry';
export * as dataAzurermContainerRegistryScopeMap from './data-azurerm-container-registry-scope-map';
export * as dataAzurermContainerRegistryToken from './data-azurerm-container-registry-token';
export * as dataAzurermCosmosdbAccount from './data-azurerm-cosmosdb-account';
export * as dataAzurermCosmosdbMongoDatabase from './data-azurerm-cosmosdb-mongo-database';
export * as dataAzurermCosmosdbRestorableDatabaseAccounts from './data-azurerm-cosmosdb-restorable-database-accounts';
export * as dataAzurermCosmosdbSqlDatabase from './data-azurerm-cosmosdb-sql-database';
export * as dataAzurermCosmosdbSqlRoleDefinition from './data-azurerm-cosmosdb-sql-role-definition';
export * as dataAzurermDataFactory from './data-azurerm-data-factory';
export * as dataAzurermDataProtectionBackupVault from './data-azurerm-data-protection-backup-vault';
export * as dataAzurermDataShare from './data-azurerm-data-share';
export * as dataAzurermDataShareAccount from './data-azurerm-data-share-account';
export * as dataAzurermDataShareDatasetBlobStorage from './data-azurerm-data-share-dataset-blob-storage';
export * as dataAzurermDataShareDatasetDataLakeGen2 from './data-azurerm-data-share-dataset-data-lake-gen2';
export * as dataAzurermDataShareDatasetKustoCluster from './data-azurerm-data-share-dataset-kusto-cluster';
export * as dataAzurermDataShareDatasetKustoDatabase from './data-azurerm-data-share-dataset-kusto-database';
export * as dataAzurermDatabaseMigrationProject from './data-azurerm-database-migration-project';
export * as dataAzurermDatabaseMigrationService from './data-azurerm-database-migration-service';
export * as dataAzurermDataboxEdgeDevice from './data-azurerm-databox-edge-device';
export * as dataAzurermDatabricksWorkspace from './data-azurerm-databricks-workspace';
export * as dataAzurermDatabricksWorkspacePrivateEndpointConnection from './data-azurerm-databricks-workspace-private-endpoint-connection';
export * as dataAzurermDedicatedHost from './data-azurerm-dedicated-host';
export * as dataAzurermDedicatedHostGroup from './data-azurerm-dedicated-host-group';
export * as dataAzurermDevTestLab from './data-azurerm-dev-test-lab';
export * as dataAzurermDevTestVirtualNetwork from './data-azurerm-dev-test-virtual-network';
export * as dataAzurermDigitalTwinsInstance from './data-azurerm-digital-twins-instance';
export * as dataAzurermDiskAccess from './data-azurerm-disk-access';
export * as dataAzurermDiskEncryptionSet from './data-azurerm-disk-encryption-set';
export * as dataAzurermDnsARecord from './data-azurerm-dns-a-record';
export * as dataAzurermDnsAaaaRecord from './data-azurerm-dns-aaaa-record';
export * as dataAzurermDnsCaaRecord from './data-azurerm-dns-caa-record';
export * as dataAzurermDnsCnameRecord from './data-azurerm-dns-cname-record';
export * as dataAzurermDnsMxRecord from './data-azurerm-dns-mx-record';
export * as dataAzurermDnsNsRecord from './data-azurerm-dns-ns-record';
export * as dataAzurermDnsPtrRecord from './data-azurerm-dns-ptr-record';
export * as dataAzurermDnsSoaRecord from './data-azurerm-dns-soa-record';
export * as dataAzurermDnsSrvRecord from './data-azurerm-dns-srv-record';
export * as dataAzurermDnsTxtRecord from './data-azurerm-dns-txt-record';
export * as dataAzurermDnsZone from './data-azurerm-dns-zone';
export * as dataAzurermElasticCloudElasticsearch from './data-azurerm-elastic-cloud-elasticsearch';
export * as dataAzurermEventgridDomain from './data-azurerm-eventgrid-domain';
export * as dataAzurermEventgridDomainTopic from './data-azurerm-eventgrid-domain-topic';
export * as dataAzurermEventgridSystemTopic from './data-azurerm-eventgrid-system-topic';
export * as dataAzurermEventgridTopic from './data-azurerm-eventgrid-topic';
export * as dataAzurermEventhub from './data-azurerm-eventhub';
export * as dataAzurermEventhubAuthorizationRule from './data-azurerm-eventhub-authorization-rule';
export * as dataAzurermEventhubCluster from './data-azurerm-eventhub-cluster';
export * as dataAzurermEventhubConsumerGroup from './data-azurerm-eventhub-consumer-group';
export * as dataAzurermEventhubNamespace from './data-azurerm-eventhub-namespace';
export * as dataAzurermEventhubNamespaceAuthorizationRule from './data-azurerm-eventhub-namespace-authorization-rule';
export * as dataAzurermEventhubSas from './data-azurerm-eventhub-sas';
export * as dataAzurermExpressRouteCircuit from './data-azurerm-express-route-circuit';
export * as dataAzurermExtendedLocations from './data-azurerm-extended-locations';
export * as dataAzurermFirewall from './data-azurerm-firewall';
export * as dataAzurermFirewallPolicy from './data-azurerm-firewall-policy';
export * as dataAzurermFunctionApp from './data-azurerm-function-app';
export * as dataAzurermFunctionAppHostKeys from './data-azurerm-function-app-host-keys';
export * as dataAzurermHdinsightCluster from './data-azurerm-hdinsight-cluster';
export * as dataAzurermHealthcareDicomService from './data-azurerm-healthcare-dicom-service';
export * as dataAzurermHealthcareFhirService from './data-azurerm-healthcare-fhir-service';
export * as dataAzurermHealthcareMedtechService from './data-azurerm-healthcare-medtech-service';
export * as dataAzurermHealthcareService from './data-azurerm-healthcare-service';
export * as dataAzurermHealthcareWorkspace from './data-azurerm-healthcare-workspace';
export * as dataAzurermHybridComputeMachine from './data-azurerm-hybrid-compute-machine';
export * as dataAzurermImage from './data-azurerm-image';
export * as dataAzurermImages from './data-azurerm-images';
export * as dataAzurermIothub from './data-azurerm-iothub';
export * as dataAzurermIothubDps from './data-azurerm-iothub-dps';
export * as dataAzurermIothubDpsSharedAccessPolicy from './data-azurerm-iothub-dps-shared-access-policy';
export * as dataAzurermIothubSharedAccessPolicy from './data-azurerm-iothub-shared-access-policy';
export * as dataAzurermIpGroup from './data-azurerm-ip-group';
export * as dataAzurermKeyVault from './data-azurerm-key-vault';
export * as dataAzurermKeyVaultAccessPolicy from './data-azurerm-key-vault-access-policy';
export * as dataAzurermKeyVaultCertificate from './data-azurerm-key-vault-certificate';
export * as dataAzurermKeyVaultCertificateData from './data-azurerm-key-vault-certificate-data';
export * as dataAzurermKeyVaultCertificateIssuer from './data-azurerm-key-vault-certificate-issuer';
export * as dataAzurermKeyVaultCertificates from './data-azurerm-key-vault-certificates';
export * as dataAzurermKeyVaultEncryptedValue from './data-azurerm-key-vault-encrypted-value';
export * as dataAzurermKeyVaultKey from './data-azurerm-key-vault-key';
export * as dataAzurermKeyVaultManagedHardwareSecurityModule from './data-azurerm-key-vault-managed-hardware-security-module';
export * as dataAzurermKeyVaultManagedHardwareSecurityModuleRoleDefinition from './data-azurerm-key-vault-managed-hardware-security-module-role-definition';
export * as dataAzurermKeyVaultSecret from './data-azurerm-key-vault-secret';
export * as dataAzurermKeyVaultSecrets from './data-azurerm-key-vault-secrets';
export * as dataAzurermKubernetesCluster from './data-azurerm-kubernetes-cluster';
export * as dataAzurermKubernetesClusterNodePool from './data-azurerm-kubernetes-cluster-node-pool';
export * as dataAzurermKubernetesNodePoolSnapshot from './data-azurerm-kubernetes-node-pool-snapshot';
export * as dataAzurermKubernetesServiceVersions from './data-azurerm-kubernetes-service-versions';
export * as dataAzurermKustoCluster from './data-azurerm-kusto-cluster';
export * as dataAzurermKustoDatabase from './data-azurerm-kusto-database';
export * as dataAzurermLb from './data-azurerm-lb';
export * as dataAzurermLbBackendAddressPool from './data-azurerm-lb-backend-address-pool';
export * as dataAzurermLbOutboundRule from './data-azurerm-lb-outbound-rule';
export * as dataAzurermLbRule from './data-azurerm-lb-rule';
export * as dataAzurermLinuxFunctionApp from './data-azurerm-linux-function-app';
export * as dataAzurermLinuxWebApp from './data-azurerm-linux-web-app';
export * as dataAzurermLocalNetworkGateway from './data-azurerm-local-network-gateway';
export * as dataAzurermLogAnalyticsWorkspace from './data-azurerm-log-analytics-workspace';
export * as dataAzurermLogicAppIntegrationAccount from './data-azurerm-logic-app-integration-account';
export * as dataAzurermLogicAppStandard from './data-azurerm-logic-app-standard';
export * as dataAzurermLogicAppWorkflow from './data-azurerm-logic-app-workflow';
export * as dataAzurermMachineLearningWorkspace from './data-azurerm-machine-learning-workspace';
export * as dataAzurermMaintenanceConfiguration from './data-azurerm-maintenance-configuration';
export * as dataAzurermManagedApi from './data-azurerm-managed-api';
export * as dataAzurermManagedApplicationDefinition from './data-azurerm-managed-application-definition';
export * as dataAzurermManagedDisk from './data-azurerm-managed-disk';
export * as dataAzurermManagementGroup from './data-azurerm-management-group';
export * as dataAzurermManagementGroupTemplateDeployment from './data-azurerm-management-group-template-deployment';
export * as dataAzurermMapsAccount from './data-azurerm-maps-account';
export * as dataAzurermMariadbServer from './data-azurerm-mariadb-server';
export * as dataAzurermMarketplaceAgreement from './data-azurerm-marketplace-agreement';
export * as dataAzurermMobileNetwork from './data-azurerm-mobile-network';
export * as dataAzurermMobileNetworkAttachedDataNetwork from './data-azurerm-mobile-network-attached-data-network';
export * as dataAzurermMobileNetworkDataNetwork from './data-azurerm-mobile-network-data-network';
export * as dataAzurermMobileNetworkPacketCoreControlPlane from './data-azurerm-mobile-network-packet-core-control-plane';
export * as dataAzurermMobileNetworkPacketCoreDataPlane from './data-azurerm-mobile-network-packet-core-data-plane';
export * as dataAzurermMobileNetworkService from './data-azurerm-mobile-network-service';
export * as dataAzurermMobileNetworkSim from './data-azurerm-mobile-network-sim';
export * as dataAzurermMobileNetworkSimGroup from './data-azurerm-mobile-network-sim-group';
export * as dataAzurermMobileNetworkSimPolicy from './data-azurerm-mobile-network-sim-policy';
export * as dataAzurermMobileNetworkSite from './data-azurerm-mobile-network-site';
export * as dataAzurermMobileNetworkSlice from './data-azurerm-mobile-network-slice';
export * as dataAzurermMonitorActionGroup from './data-azurerm-monitor-action-group';
export * as dataAzurermMonitorDataCollectionEndpoint from './data-azurerm-monitor-data-collection-endpoint';
export * as dataAzurermMonitorDataCollectionRule from './data-azurerm-monitor-data-collection-rule';
export * as dataAzurermMonitorDiagnosticCategories from './data-azurerm-monitor-diagnostic-categories';
export * as dataAzurermMonitorLogProfile from './data-azurerm-monitor-log-profile';
export * as dataAzurermMonitorScheduledQueryRulesAlert from './data-azurerm-monitor-scheduled-query-rules-alert';
export * as dataAzurermMonitorScheduledQueryRulesLog from './data-azurerm-monitor-scheduled-query-rules-log';
export * as dataAzurermMonitorWorkspace from './data-azurerm-monitor-workspace';
export * as dataAzurermMssqlDatabase from './data-azurerm-mssql-database';
export * as dataAzurermMssqlElasticpool from './data-azurerm-mssql-elasticpool';
export * as dataAzurermMssqlManagedInstance from './data-azurerm-mssql-managed-instance';
export * as dataAzurermMssqlServer from './data-azurerm-mssql-server';
export * as dataAzurermMysqlFlexibleServer from './data-azurerm-mysql-flexible-server';
export * as dataAzurermMysqlServer from './data-azurerm-mysql-server';
export * as dataAzurermNatGateway from './data-azurerm-nat-gateway';
export * as dataAzurermNetappAccount from './data-azurerm-netapp-account';
export * as dataAzurermNetappPool from './data-azurerm-netapp-pool';
export * as dataAzurermNetappSnapshot from './data-azurerm-netapp-snapshot';
export * as dataAzurermNetappSnapshotPolicy from './data-azurerm-netapp-snapshot-policy';
export * as dataAzurermNetappVolume from './data-azurerm-netapp-volume';
export * as dataAzurermNetappVolumeGroupSapHana from './data-azurerm-netapp-volume-group-sap-hana';
export * as dataAzurermNetappVolumeQuotaRule from './data-azurerm-netapp-volume-quota-rule';
export * as dataAzurermNetworkDdosProtectionPlan from './data-azurerm-network-ddos-protection-plan';
export * as dataAzurermNetworkInterface from './data-azurerm-network-interface';
export * as dataAzurermNetworkManagerNetworkGroup from './data-azurerm-network-manager-network-group';
export * as dataAzurermNetworkSecurityGroup from './data-azurerm-network-security-group';
export * as dataAzurermNetworkServiceTags from './data-azurerm-network-service-tags';
export * as dataAzurermNetworkWatcher from './data-azurerm-network-watcher';
export * as dataAzurermNotificationHub from './data-azurerm-notification-hub';
export * as dataAzurermNotificationHubNamespace from './data-azurerm-notification-hub-namespace';
export * as dataAzurermOrchestratedVirtualMachineScaleSet from './data-azurerm-orchestrated-virtual-machine-scale-set';
export * as dataAzurermPaloAltoLocalRulestack from './data-azurerm-palo-alto-local-rulestack';
export * as dataAzurermPlatformImage from './data-azurerm-platform-image';
export * as dataAzurermPolicyAssignment from './data-azurerm-policy-assignment';
export * as dataAzurermPolicyDefinition from './data-azurerm-policy-definition';
export * as dataAzurermPolicyDefinitionBuiltIn from './data-azurerm-policy-definition-built-in';
export * as dataAzurermPolicySetDefinition from './data-azurerm-policy-set-definition';
export * as dataAzurermPolicyVirtualMachineConfigurationAssignment from './data-azurerm-policy-virtual-machine-configuration-assignment';
export * as dataAzurermPortalDashboard from './data-azurerm-portal-dashboard';
export * as dataAzurermPostgresqlFlexibleServer from './data-azurerm-postgresql-flexible-server';
export * as dataAzurermPostgresqlServer from './data-azurerm-postgresql-server';
export * as dataAzurermPrivateDnsARecord from './data-azurerm-private-dns-a-record';
export * as dataAzurermPrivateDnsAaaaRecord from './data-azurerm-private-dns-aaaa-record';
export * as dataAzurermPrivateDnsCnameRecord from './data-azurerm-private-dns-cname-record';
export * as dataAzurermPrivateDnsMxRecord from './data-azurerm-private-dns-mx-record';
export * as dataAzurermPrivateDnsPtrRecord from './data-azurerm-private-dns-ptr-record';
export * as dataAzurermPrivateDnsResolver from './data-azurerm-private-dns-resolver';
export * as dataAzurermPrivateDnsResolverDnsForwardingRuleset from './data-azurerm-private-dns-resolver-dns-forwarding-ruleset';
export * as dataAzurermPrivateDnsResolverForwardingRule from './data-azurerm-private-dns-resolver-forwarding-rule';
export * as dataAzurermPrivateDnsResolverInboundEndpoint from './data-azurerm-private-dns-resolver-inbound-endpoint';
export * as dataAzurermPrivateDnsResolverOutboundEndpoint from './data-azurerm-private-dns-resolver-outbound-endpoint';
export * as dataAzurermPrivateDnsResolverVirtualNetworkLink from './data-azurerm-private-dns-resolver-virtual-network-link';
export * as dataAzurermPrivateDnsSoaRecord from './data-azurerm-private-dns-soa-record';
export * as dataAzurermPrivateDnsSrvRecord from './data-azurerm-private-dns-srv-record';
export * as dataAzurermPrivateDnsTxtRecord from './data-azurerm-private-dns-txt-record';
export * as dataAzurermPrivateDnsZone from './data-azurerm-private-dns-zone';
export * as dataAzurermPrivateDnsZoneVirtualNetworkLink from './data-azurerm-private-dns-zone-virtual-network-link';
export * as dataAzurermPrivateEndpointConnection from './data-azurerm-private-endpoint-connection';
export * as dataAzurermPrivateLinkService from './data-azurerm-private-link-service';
export * as dataAzurermPrivateLinkServiceEndpointConnections from './data-azurerm-private-link-service-endpoint-connections';
export * as dataAzurermProximityPlacementGroup from './data-azurerm-proximity-placement-group';
export * as dataAzurermPublicIp from './data-azurerm-public-ip';
export * as dataAzurermPublicIpPrefix from './data-azurerm-public-ip-prefix';
export * as dataAzurermPublicIps from './data-azurerm-public-ips';
export * as dataAzurermPublicMaintenanceConfigurations from './data-azurerm-public-maintenance-configurations';
export * as dataAzurermRecoveryServicesVault from './data-azurerm-recovery-services-vault';
export * as dataAzurermRedisCache from './data-azurerm-redis-cache';
export * as dataAzurermRedisEnterpriseDatabase from './data-azurerm-redis-enterprise-database';
export * as dataAzurermResourceGroup from './data-azurerm-resource-group';
export * as dataAzurermResourceGroupTemplateDeployment from './data-azurerm-resource-group-template-deployment';
export * as dataAzurermResources from './data-azurerm-resources';
export * as dataAzurermRoleDefinition from './data-azurerm-role-definition';
export * as dataAzurermRouteFilter from './data-azurerm-route-filter';
export * as dataAzurermRouteTable from './data-azurerm-route-table';
export * as dataAzurermSearchService from './data-azurerm-search-service';
export * as dataAzurermSentinelAlertRule from './data-azurerm-sentinel-alert-rule';
export * as dataAzurermSentinelAlertRuleAnomaly from './data-azurerm-sentinel-alert-rule-anomaly';
export * as dataAzurermSentinelAlertRuleTemplate from './data-azurerm-sentinel-alert-rule-template';
export * as dataAzurermServicePlan from './data-azurerm-service-plan';
export * as dataAzurermServicebusNamespace from './data-azurerm-servicebus-namespace';
export * as dataAzurermServicebusNamespaceAuthorizationRule from './data-azurerm-servicebus-namespace-authorization-rule';
export * as dataAzurermServicebusNamespaceDisasterRecoveryConfig from './data-azurerm-servicebus-namespace-disaster-recovery-config';
export * as dataAzurermServicebusQueue from './data-azurerm-servicebus-queue';
export * as dataAzurermServicebusQueueAuthorizationRule from './data-azurerm-servicebus-queue-authorization-rule';
export * as dataAzurermServicebusSubscription from './data-azurerm-servicebus-subscription';
export * as dataAzurermServicebusTopic from './data-azurerm-servicebus-topic';
export * as dataAzurermServicebusTopicAuthorizationRule from './data-azurerm-servicebus-topic-authorization-rule';
export * as dataAzurermSharedImage from './data-azurerm-shared-image';
export * as dataAzurermSharedImageGallery from './data-azurerm-shared-image-gallery';
export * as dataAzurermSharedImageVersion from './data-azurerm-shared-image-version';
export * as dataAzurermSharedImageVersions from './data-azurerm-shared-image-versions';
export * as dataAzurermSignalrService from './data-azurerm-signalr-service';
export * as dataAzurermSiteRecoveryFabric from './data-azurerm-site-recovery-fabric';
export * as dataAzurermSiteRecoveryProtectionContainer from './data-azurerm-site-recovery-protection-container';
export * as dataAzurermSiteRecoveryReplicationPolicy from './data-azurerm-site-recovery-replication-policy';
export * as dataAzurermSiteRecoveryReplicationRecoveryPlan from './data-azurerm-site-recovery-replication-recovery-plan';
export * as dataAzurermSnapshot from './data-azurerm-snapshot';
export * as dataAzurermSourceControlToken from './data-azurerm-source-control-token';
export * as dataAzurermSpatialAnchorsAccount from './data-azurerm-spatial-anchors-account';
export * as dataAzurermSpringCloudApp from './data-azurerm-spring-cloud-app';
export * as dataAzurermSpringCloudService from './data-azurerm-spring-cloud-service';
export * as dataAzurermSqlDatabase from './data-azurerm-sql-database';
export * as dataAzurermSqlManagedInstance from './data-azurerm-sql-managed-instance';
export * as dataAzurermSqlServer from './data-azurerm-sql-server';
export * as dataAzurermSshPublicKey from './data-azurerm-ssh-public-key';
export * as dataAzurermStackHciCluster from './data-azurerm-stack-hci-cluster';
export * as dataAzurermStorageAccount from './data-azurerm-storage-account';
export * as dataAzurermStorageAccountBlobContainerSas from './data-azurerm-storage-account-blob-container-sas';
export * as dataAzurermStorageAccountSas from './data-azurerm-storage-account-sas';
export * as dataAzurermStorageBlob from './data-azurerm-storage-blob';
export * as dataAzurermStorageContainer from './data-azurerm-storage-container';
export * as dataAzurermStorageContainers from './data-azurerm-storage-containers';
export * as dataAzurermStorageEncryptionScope from './data-azurerm-storage-encryption-scope';
export * as dataAzurermStorageManagementPolicy from './data-azurerm-storage-management-policy';
export * as dataAzurermStorageShare from './data-azurerm-storage-share';
export * as dataAzurermStorageSync from './data-azurerm-storage-sync';
export * as dataAzurermStorageSyncGroup from './data-azurerm-storage-sync-group';
export * as dataAzurermStorageTableEntity from './data-azurerm-storage-table-entity';
export * as dataAzurermStreamAnalyticsJob from './data-azurerm-stream-analytics-job';
export * as dataAzurermSubnet from './data-azurerm-subnet';
export * as dataAzurermSubscription from './data-azurerm-subscription';
export * as dataAzurermSubscriptionTemplateDeployment from './data-azurerm-subscription-template-deployment';
export * as dataAzurermSubscriptions from './data-azurerm-subscriptions';
export * as dataAzurermSynapseWorkspace from './data-azurerm-synapse-workspace';
export * as dataAzurermTemplateSpecVersion from './data-azurerm-template-spec-version';
export * as dataAzurermTenantTemplateDeployment from './data-azurerm-tenant-template-deployment';
export * as dataAzurermTrafficManagerGeographicalLocation from './data-azurerm-traffic-manager-geographical-location';
export * as dataAzurermTrafficManagerProfile from './data-azurerm-traffic-manager-profile';
export * as dataAzurermUserAssignedIdentity from './data-azurerm-user-assigned-identity';
export * as dataAzurermVirtualDesktopHostPool from './data-azurerm-virtual-desktop-host-pool';
export * as dataAzurermVirtualHub from './data-azurerm-virtual-hub';
export * as dataAzurermVirtualHubConnection from './data-azurerm-virtual-hub-connection';
export * as dataAzurermVirtualHubRouteTable from './data-azurerm-virtual-hub-route-table';
export * as dataAzurermVirtualMachine from './data-azurerm-virtual-machine';
export * as dataAzurermVirtualMachineScaleSet from './data-azurerm-virtual-machine-scale-set';
export * as dataAzurermVirtualNetwork from './data-azurerm-virtual-network';
export * as dataAzurermVirtualNetworkGateway from './data-azurerm-virtual-network-gateway';
export * as dataAzurermVirtualNetworkGatewayConnection from './data-azurerm-virtual-network-gateway-connection';
export * as dataAzurermVirtualWan from './data-azurerm-virtual-wan';
export * as dataAzurermVmwarePrivateCloud from './data-azurerm-vmware-private-cloud';
export * as dataAzurermVpnGateway from './data-azurerm-vpn-gateway';
export * as dataAzurermWebApplicationFirewallPolicy from './data-azurerm-web-application-firewall-policy';
export * as dataAzurermWebPubsub from './data-azurerm-web-pubsub';
export * as dataAzurermWebPubsubPrivateLinkResource from './data-azurerm-web-pubsub-private-link-resource';
export * as dataAzurermWindowsFunctionApp from './data-azurerm-windows-function-app';
export * as dataAzurermWindowsWebApp from './data-azurerm-windows-web-app';
export * as provider from './provider';
