/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDiskSasTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#access_level ManagedDiskSasToken#access_level}
    */
    readonly accessLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#duration_in_seconds ManagedDiskSasToken#duration_in_seconds}
    */
    readonly durationInSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#id ManagedDiskSasToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#managed_disk_id ManagedDiskSasToken#managed_disk_id}
    */
    readonly managedDiskId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#timeouts ManagedDiskSasToken#timeouts}
    */
    readonly timeouts?: ManagedDiskSasTokenTimeouts;
}
export interface ManagedDiskSasTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#create ManagedDiskSasToken#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#delete ManagedDiskSasToken#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#read ManagedDiskSasToken#read}
    */
    readonly read?: string;
}
export declare function managedDiskSasTokenTimeoutsToTerraform(struct?: ManagedDiskSasTokenTimeouts | cdktf.IResolvable): any;
export declare class ManagedDiskSasTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedDiskSasTokenTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedDiskSasTokenTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token azurerm_managed_disk_sas_token}
*/
export declare class ManagedDiskSasToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_managed_disk_sas_token";
    /**
    * Generates CDKTF code for importing a ManagedDiskSasToken resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagedDiskSasToken to import
    * @param importFromId The id of the existing ManagedDiskSasToken that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagedDiskSasToken to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/managed_disk_sas_token azurerm_managed_disk_sas_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDiskSasTokenConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDiskSasTokenConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    get accessLevelInput(): string | undefined;
    private _durationInSeconds?;
    get durationInSeconds(): number;
    set durationInSeconds(value: number);
    get durationInSecondsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedDiskId?;
    get managedDiskId(): string;
    set managedDiskId(value: string);
    get managedDiskIdInput(): string | undefined;
    get sasUrl(): string;
    private _timeouts;
    get timeouts(): ManagedDiskSasTokenTimeoutsOutputReference;
    putTimeouts(value: ManagedDiskSasTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagedDiskSasTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
