/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#id NetworkSecurityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#location NetworkSecurityGroup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#name NetworkSecurityGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#resource_group_name NetworkSecurityGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#security_rule NetworkSecurityGroup#security_rule}
    */
    readonly securityRule?: NetworkSecurityGroupSecurityRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#tags NetworkSecurityGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#timeouts NetworkSecurityGroup#timeouts}
    */
    readonly timeouts?: NetworkSecurityGroupTimeouts;
}
export interface NetworkSecurityGroupSecurityRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#access NetworkSecurityGroup#access}
    */
    readonly access?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#description NetworkSecurityGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#destination_address_prefix NetworkSecurityGroup#destination_address_prefix}
    */
    readonly destinationAddressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#destination_address_prefixes NetworkSecurityGroup#destination_address_prefixes}
    */
    readonly destinationAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#destination_application_security_group_ids NetworkSecurityGroup#destination_application_security_group_ids}
    */
    readonly destinationApplicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#destination_port_range NetworkSecurityGroup#destination_port_range}
    */
    readonly destinationPortRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#destination_port_ranges NetworkSecurityGroup#destination_port_ranges}
    */
    readonly destinationPortRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#direction NetworkSecurityGroup#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#name NetworkSecurityGroup#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#priority NetworkSecurityGroup#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#protocol NetworkSecurityGroup#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#source_address_prefix NetworkSecurityGroup#source_address_prefix}
    */
    readonly sourceAddressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#source_address_prefixes NetworkSecurityGroup#source_address_prefixes}
    */
    readonly sourceAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#source_application_security_group_ids NetworkSecurityGroup#source_application_security_group_ids}
    */
    readonly sourceApplicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#source_port_range NetworkSecurityGroup#source_port_range}
    */
    readonly sourcePortRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#source_port_ranges NetworkSecurityGroup#source_port_ranges}
    */
    readonly sourcePortRanges?: string[];
}
export declare function networkSecurityGroupSecurityRuleToTerraform(struct?: NetworkSecurityGroupSecurityRule | cdktf.IResolvable): any;
export declare class NetworkSecurityGroupSecurityRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkSecurityGroupSecurityRule | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkSecurityGroupSecurityRule | cdktf.IResolvable | undefined);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationAddressPrefix?;
    get destinationAddressPrefix(): string;
    set destinationAddressPrefix(value: string);
    resetDestinationAddressPrefix(): void;
    get destinationAddressPrefixInput(): string | undefined;
    private _destinationAddressPrefixes?;
    get destinationAddressPrefixes(): string[];
    set destinationAddressPrefixes(value: string[]);
    resetDestinationAddressPrefixes(): void;
    get destinationAddressPrefixesInput(): string[] | undefined;
    private _destinationApplicationSecurityGroupIds?;
    get destinationApplicationSecurityGroupIds(): string[];
    set destinationApplicationSecurityGroupIds(value: string[]);
    resetDestinationApplicationSecurityGroupIds(): void;
    get destinationApplicationSecurityGroupIdsInput(): string[] | undefined;
    private _destinationPortRange?;
    get destinationPortRange(): string;
    set destinationPortRange(value: string);
    resetDestinationPortRange(): void;
    get destinationPortRangeInput(): string | undefined;
    private _destinationPortRanges?;
    get destinationPortRanges(): string[];
    set destinationPortRanges(value: string[]);
    resetDestinationPortRanges(): void;
    get destinationPortRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _sourceAddressPrefix?;
    get sourceAddressPrefix(): string;
    set sourceAddressPrefix(value: string);
    resetSourceAddressPrefix(): void;
    get sourceAddressPrefixInput(): string | undefined;
    private _sourceAddressPrefixes?;
    get sourceAddressPrefixes(): string[];
    set sourceAddressPrefixes(value: string[]);
    resetSourceAddressPrefixes(): void;
    get sourceAddressPrefixesInput(): string[] | undefined;
    private _sourceApplicationSecurityGroupIds?;
    get sourceApplicationSecurityGroupIds(): string[];
    set sourceApplicationSecurityGroupIds(value: string[]);
    resetSourceApplicationSecurityGroupIds(): void;
    get sourceApplicationSecurityGroupIdsInput(): string[] | undefined;
    private _sourcePortRange?;
    get sourcePortRange(): string;
    set sourcePortRange(value: string);
    resetSourcePortRange(): void;
    get sourcePortRangeInput(): string | undefined;
    private _sourcePortRanges?;
    get sourcePortRanges(): string[];
    set sourcePortRanges(value: string[]);
    resetSourcePortRanges(): void;
    get sourcePortRangesInput(): string[] | undefined;
}
export declare class NetworkSecurityGroupSecurityRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkSecurityGroupSecurityRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkSecurityGroupSecurityRuleOutputReference;
}
export interface NetworkSecurityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#create NetworkSecurityGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#delete NetworkSecurityGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#read NetworkSecurityGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#update NetworkSecurityGroup#update}
    */
    readonly update?: string;
}
export declare function networkSecurityGroupTimeoutsToTerraform(struct?: NetworkSecurityGroupTimeouts | cdktf.IResolvable): any;
export declare class NetworkSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkSecurityGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkSecurityGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group azurerm_network_security_group}
*/
export declare class NetworkSecurityGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_security_group";
    /**
    * Generates CDKTF code for importing a NetworkSecurityGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkSecurityGroup to import
    * @param importFromId The id of the existing NetworkSecurityGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkSecurityGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/network_security_group azurerm_network_security_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkSecurityGroupConfig
    */
    constructor(scope: Construct, id: string, config: NetworkSecurityGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _securityRule;
    get securityRule(): NetworkSecurityGroupSecurityRuleList;
    putSecurityRule(value: NetworkSecurityGroupSecurityRule[] | cdktf.IResolvable): void;
    resetSecurityRule(): void;
    get securityRuleInput(): cdktf.IResolvable | NetworkSecurityGroupSecurityRule[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): NetworkSecurityGroupTimeoutsOutputReference;
    putTimeouts(value: NetworkSecurityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkSecurityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
