/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceDeploymentScriptAzureCliConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#cleanup_preference ResourceDeploymentScriptAzureCli#cleanup_preference}
    */
    readonly cleanupPreference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#command_line ResourceDeploymentScriptAzureCli#command_line}
    */
    readonly commandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#force_update_tag ResourceDeploymentScriptAzureCli#force_update_tag}
    */
    readonly forceUpdateTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#id ResourceDeploymentScriptAzureCli#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#location ResourceDeploymentScriptAzureCli#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#name ResourceDeploymentScriptAzureCli#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#primary_script_uri ResourceDeploymentScriptAzureCli#primary_script_uri}
    */
    readonly primaryScriptUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#resource_group_name ResourceDeploymentScriptAzureCli#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#retention_interval ResourceDeploymentScriptAzureCli#retention_interval}
    */
    readonly retentionInterval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#script_content ResourceDeploymentScriptAzureCli#script_content}
    */
    readonly scriptContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#supporting_script_uris ResourceDeploymentScriptAzureCli#supporting_script_uris}
    */
    readonly supportingScriptUris?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#tags ResourceDeploymentScriptAzureCli#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#timeout ResourceDeploymentScriptAzureCli#timeout}
    */
    readonly timeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#version ResourceDeploymentScriptAzureCli#version}
    */
    readonly version: string;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#container ResourceDeploymentScriptAzureCli#container}
    */
    readonly container?: ResourceDeploymentScriptAzureCliContainer;
    /**
    * environment_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#environment_variable ResourceDeploymentScriptAzureCli#environment_variable}
    */
    readonly environmentVariable?: ResourceDeploymentScriptAzureCliEnvironmentVariable[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#identity ResourceDeploymentScriptAzureCli#identity}
    */
    readonly identity?: ResourceDeploymentScriptAzureCliIdentity;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#storage_account ResourceDeploymentScriptAzureCli#storage_account}
    */
    readonly storageAccount?: ResourceDeploymentScriptAzureCliStorageAccount;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#timeouts ResourceDeploymentScriptAzureCli#timeouts}
    */
    readonly timeouts?: ResourceDeploymentScriptAzureCliTimeouts;
}
export interface ResourceDeploymentScriptAzureCliContainer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#container_group_name ResourceDeploymentScriptAzureCli#container_group_name}
    */
    readonly containerGroupName?: string;
}
export declare function resourceDeploymentScriptAzureCliContainerToTerraform(struct?: ResourceDeploymentScriptAzureCliContainerOutputReference | ResourceDeploymentScriptAzureCliContainer): any;
export declare class ResourceDeploymentScriptAzureCliContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzureCliContainer | undefined;
    set internalValue(value: ResourceDeploymentScriptAzureCliContainer | undefined);
    private _containerGroupName?;
    get containerGroupName(): string;
    set containerGroupName(value: string);
    resetContainerGroupName(): void;
    get containerGroupNameInput(): string | undefined;
}
export interface ResourceDeploymentScriptAzureCliEnvironmentVariable {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#name ResourceDeploymentScriptAzureCli#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#secure_value ResourceDeploymentScriptAzureCli#secure_value}
    */
    readonly secureValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#value ResourceDeploymentScriptAzureCli#value}
    */
    readonly value?: string;
}
export declare function resourceDeploymentScriptAzureCliEnvironmentVariableToTerraform(struct?: ResourceDeploymentScriptAzureCliEnvironmentVariable | cdktf.IResolvable): any;
export declare class ResourceDeploymentScriptAzureCliEnvironmentVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceDeploymentScriptAzureCliEnvironmentVariable | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceDeploymentScriptAzureCliEnvironmentVariable | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secureValue?;
    get secureValue(): string;
    set secureValue(value: string);
    resetSecureValue(): void;
    get secureValueInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ResourceDeploymentScriptAzureCliEnvironmentVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceDeploymentScriptAzureCliEnvironmentVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceDeploymentScriptAzureCliEnvironmentVariableOutputReference;
}
export interface ResourceDeploymentScriptAzureCliIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#identity_ids ResourceDeploymentScriptAzureCli#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#type ResourceDeploymentScriptAzureCli#type}
    */
    readonly type: string;
}
export declare function resourceDeploymentScriptAzureCliIdentityToTerraform(struct?: ResourceDeploymentScriptAzureCliIdentityOutputReference | ResourceDeploymentScriptAzureCliIdentity): any;
export declare class ResourceDeploymentScriptAzureCliIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzureCliIdentity | undefined;
    set internalValue(value: ResourceDeploymentScriptAzureCliIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ResourceDeploymentScriptAzureCliStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#key ResourceDeploymentScriptAzureCli#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#name ResourceDeploymentScriptAzureCli#name}
    */
    readonly name: string;
}
export declare function resourceDeploymentScriptAzureCliStorageAccountToTerraform(struct?: ResourceDeploymentScriptAzureCliStorageAccountOutputReference | ResourceDeploymentScriptAzureCliStorageAccount): any;
export declare class ResourceDeploymentScriptAzureCliStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzureCliStorageAccount | undefined;
    set internalValue(value: ResourceDeploymentScriptAzureCliStorageAccount | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ResourceDeploymentScriptAzureCliTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#create ResourceDeploymentScriptAzureCli#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#delete ResourceDeploymentScriptAzureCli#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#read ResourceDeploymentScriptAzureCli#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#update ResourceDeploymentScriptAzureCli#update}
    */
    readonly update?: string;
}
export declare function resourceDeploymentScriptAzureCliTimeoutsToTerraform(struct?: ResourceDeploymentScriptAzureCliTimeouts | cdktf.IResolvable): any;
export declare class ResourceDeploymentScriptAzureCliTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceDeploymentScriptAzureCliTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceDeploymentScriptAzureCliTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli azurerm_resource_deployment_script_azure_cli}
*/
export declare class ResourceDeploymentScriptAzureCli extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_deployment_script_azure_cli";
    /**
    * Generates CDKTF code for importing a ResourceDeploymentScriptAzureCli resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceDeploymentScriptAzureCli to import
    * @param importFromId The id of the existing ResourceDeploymentScriptAzureCli that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceDeploymentScriptAzureCli to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/resource_deployment_script_azure_cli azurerm_resource_deployment_script_azure_cli} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceDeploymentScriptAzureCliConfig
    */
    constructor(scope: Construct, id: string, config: ResourceDeploymentScriptAzureCliConfig);
    private _cleanupPreference?;
    get cleanupPreference(): string;
    set cleanupPreference(value: string);
    resetCleanupPreference(): void;
    get cleanupPreferenceInput(): string | undefined;
    private _commandLine?;
    get commandLine(): string;
    set commandLine(value: string);
    resetCommandLine(): void;
    get commandLineInput(): string | undefined;
    private _forceUpdateTag?;
    get forceUpdateTag(): string;
    set forceUpdateTag(value: string);
    resetForceUpdateTag(): void;
    get forceUpdateTagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputs(): string;
    private _primaryScriptUri?;
    get primaryScriptUri(): string;
    set primaryScriptUri(value: string);
    resetPrimaryScriptUri(): void;
    get primaryScriptUriInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionInterval?;
    get retentionInterval(): string;
    set retentionInterval(value: string);
    get retentionIntervalInput(): string | undefined;
    private _scriptContent?;
    get scriptContent(): string;
    set scriptContent(value: string);
    resetScriptContent(): void;
    get scriptContentInput(): string | undefined;
    private _supportingScriptUris?;
    get supportingScriptUris(): string[];
    set supportingScriptUris(value: string[]);
    resetSupportingScriptUris(): void;
    get supportingScriptUrisInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _container;
    get container(): ResourceDeploymentScriptAzureCliContainerOutputReference;
    putContainer(value: ResourceDeploymentScriptAzureCliContainer): void;
    resetContainer(): void;
    get containerInput(): ResourceDeploymentScriptAzureCliContainer | undefined;
    private _environmentVariable;
    get environmentVariable(): ResourceDeploymentScriptAzureCliEnvironmentVariableList;
    putEnvironmentVariable(value: ResourceDeploymentScriptAzureCliEnvironmentVariable[] | cdktf.IResolvable): void;
    resetEnvironmentVariable(): void;
    get environmentVariableInput(): cdktf.IResolvable | ResourceDeploymentScriptAzureCliEnvironmentVariable[] | undefined;
    private _identity;
    get identity(): ResourceDeploymentScriptAzureCliIdentityOutputReference;
    putIdentity(value: ResourceDeploymentScriptAzureCliIdentity): void;
    resetIdentity(): void;
    get identityInput(): ResourceDeploymentScriptAzureCliIdentity | undefined;
    private _storageAccount;
    get storageAccount(): ResourceDeploymentScriptAzureCliStorageAccountOutputReference;
    putStorageAccount(value: ResourceDeploymentScriptAzureCliStorageAccount): void;
    resetStorageAccount(): void;
    get storageAccountInput(): ResourceDeploymentScriptAzureCliStorageAccount | undefined;
    private _timeouts;
    get timeouts(): ResourceDeploymentScriptAzureCliTimeoutsOutputReference;
    putTimeouts(value: ResourceDeploymentScriptAzureCliTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceDeploymentScriptAzureCliTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
