/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterAutomationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#description SecurityCenterAutomation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#enabled SecurityCenterAutomation#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#id SecurityCenterAutomation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#location SecurityCenterAutomation#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#name SecurityCenterAutomation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#resource_group_name SecurityCenterAutomation#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#scopes SecurityCenterAutomation#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#tags SecurityCenterAutomation#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#action SecurityCenterAutomation#action}
    */
    readonly action: SecurityCenterAutomationAction[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#source SecurityCenterAutomation#source}
    */
    readonly source: SecurityCenterAutomationSource[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#timeouts SecurityCenterAutomation#timeouts}
    */
    readonly timeouts?: SecurityCenterAutomationTimeouts;
}
export interface SecurityCenterAutomationAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#connection_string SecurityCenterAutomation#connection_string}
    */
    readonly connectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#resource_id SecurityCenterAutomation#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#trigger_url SecurityCenterAutomation#trigger_url}
    */
    readonly triggerUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#type SecurityCenterAutomation#type}
    */
    readonly type: string;
}
export declare function securityCenterAutomationActionToTerraform(struct?: SecurityCenterAutomationAction | cdktf.IResolvable): any;
export declare class SecurityCenterAutomationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityCenterAutomationAction | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAutomationAction | cdktf.IResolvable | undefined);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    resetConnectionString(): void;
    get connectionStringInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _triggerUrl?;
    get triggerUrl(): string;
    set triggerUrl(value: string);
    resetTriggerUrl(): void;
    get triggerUrlInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SecurityCenterAutomationActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityCenterAutomationAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityCenterAutomationActionOutputReference;
}
export interface SecurityCenterAutomationSourceRuleSetRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#expected_value SecurityCenterAutomation#expected_value}
    */
    readonly expectedValue: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#operator SecurityCenterAutomation#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#property_path SecurityCenterAutomation#property_path}
    */
    readonly propertyPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#property_type SecurityCenterAutomation#property_type}
    */
    readonly propertyType: string;
}
export declare function securityCenterAutomationSourceRuleSetRuleToTerraform(struct?: SecurityCenterAutomationSourceRuleSetRule | cdktf.IResolvable): any;
export declare class SecurityCenterAutomationSourceRuleSetRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityCenterAutomationSourceRuleSetRule | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAutomationSourceRuleSetRule | cdktf.IResolvable | undefined);
    private _expectedValue?;
    get expectedValue(): string;
    set expectedValue(value: string);
    get expectedValueInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _propertyPath?;
    get propertyPath(): string;
    set propertyPath(value: string);
    get propertyPathInput(): string | undefined;
    private _propertyType?;
    get propertyType(): string;
    set propertyType(value: string);
    get propertyTypeInput(): string | undefined;
}
export declare class SecurityCenterAutomationSourceRuleSetRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityCenterAutomationSourceRuleSetRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityCenterAutomationSourceRuleSetRuleOutputReference;
}
export interface SecurityCenterAutomationSourceRuleSet {
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#rule SecurityCenterAutomation#rule}
    */
    readonly rule: SecurityCenterAutomationSourceRuleSetRule[] | cdktf.IResolvable;
}
export declare function securityCenterAutomationSourceRuleSetToTerraform(struct?: SecurityCenterAutomationSourceRuleSet | cdktf.IResolvable): any;
export declare class SecurityCenterAutomationSourceRuleSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityCenterAutomationSourceRuleSet | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAutomationSourceRuleSet | cdktf.IResolvable | undefined);
    private _rule;
    get rule(): SecurityCenterAutomationSourceRuleSetRuleList;
    putRule(value: SecurityCenterAutomationSourceRuleSetRule[] | cdktf.IResolvable): void;
    get ruleInput(): cdktf.IResolvable | SecurityCenterAutomationSourceRuleSetRule[] | undefined;
}
export declare class SecurityCenterAutomationSourceRuleSetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityCenterAutomationSourceRuleSet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityCenterAutomationSourceRuleSetOutputReference;
}
export interface SecurityCenterAutomationSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#event_source SecurityCenterAutomation#event_source}
    */
    readonly eventSource: string;
    /**
    * rule_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#rule_set SecurityCenterAutomation#rule_set}
    */
    readonly ruleSet?: SecurityCenterAutomationSourceRuleSet[] | cdktf.IResolvable;
}
export declare function securityCenterAutomationSourceToTerraform(struct?: SecurityCenterAutomationSource | cdktf.IResolvable): any;
export declare class SecurityCenterAutomationSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurityCenterAutomationSource | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAutomationSource | cdktf.IResolvable | undefined);
    private _eventSource?;
    get eventSource(): string;
    set eventSource(value: string);
    get eventSourceInput(): string | undefined;
    private _ruleSet;
    get ruleSet(): SecurityCenterAutomationSourceRuleSetList;
    putRuleSet(value: SecurityCenterAutomationSourceRuleSet[] | cdktf.IResolvable): void;
    resetRuleSet(): void;
    get ruleSetInput(): cdktf.IResolvable | SecurityCenterAutomationSourceRuleSet[] | undefined;
}
export declare class SecurityCenterAutomationSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurityCenterAutomationSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurityCenterAutomationSourceOutputReference;
}
export interface SecurityCenterAutomationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#create SecurityCenterAutomation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#delete SecurityCenterAutomation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#read SecurityCenterAutomation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#update SecurityCenterAutomation#update}
    */
    readonly update?: string;
}
export declare function securityCenterAutomationTimeoutsToTerraform(struct?: SecurityCenterAutomationTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterAutomationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterAutomationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAutomationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation azurerm_security_center_automation}
*/
export declare class SecurityCenterAutomation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_automation";
    /**
    * Generates CDKTF code for importing a SecurityCenterAutomation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterAutomation to import
    * @param importFromId The id of the existing SecurityCenterAutomation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterAutomation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/security_center_automation azurerm_security_center_automation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterAutomationConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterAutomationConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _action;
    get action(): SecurityCenterAutomationActionList;
    putAction(value: SecurityCenterAutomationAction[] | cdktf.IResolvable): void;
    get actionInput(): cdktf.IResolvable | SecurityCenterAutomationAction[] | undefined;
    private _source;
    get source(): SecurityCenterAutomationSourceList;
    putSource(value: SecurityCenterAutomationSource[] | cdktf.IResolvable): void;
    get sourceInput(): cdktf.IResolvable | SecurityCenterAutomationSource[] | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterAutomationTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterAutomationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterAutomationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
