/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusNamespaceNetworkRuleSetAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#default_action ServicebusNamespaceNetworkRuleSetA#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#id ServicebusNamespaceNetworkRuleSetA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#ip_rules ServicebusNamespaceNetworkRuleSetA#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#namespace_id ServicebusNamespaceNetworkRuleSetA#namespace_id}
    */
    readonly namespaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#public_network_access_enabled ServicebusNamespaceNetworkRuleSetA#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#trusted_services_allowed ServicebusNamespaceNetworkRuleSetA#trusted_services_allowed}
    */
    readonly trustedServicesAllowed?: boolean | cdktf.IResolvable;
    /**
    * network_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#network_rules ServicebusNamespaceNetworkRuleSetA#network_rules}
    */
    readonly networkRules?: ServicebusNamespaceNetworkRuleSetNetworkRulesA[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#timeouts ServicebusNamespaceNetworkRuleSetA#timeouts}
    */
    readonly timeouts?: ServicebusNamespaceNetworkRuleSetTimeouts;
}
export interface ServicebusNamespaceNetworkRuleSetNetworkRulesA {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#ignore_missing_vnet_service_endpoint ServicebusNamespaceNetworkRuleSetA#ignore_missing_vnet_service_endpoint}
    */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#subnet_id ServicebusNamespaceNetworkRuleSetA#subnet_id}
    */
    readonly subnetId: string;
}
export declare function servicebusNamespaceNetworkRuleSetNetworkRulesAToTerraform(struct?: ServicebusNamespaceNetworkRuleSetNetworkRulesA | cdktf.IResolvable): any;
export declare class ServicebusNamespaceNetworkRuleSetNetworkRulesAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServicebusNamespaceNetworkRuleSetNetworkRulesA | cdktf.IResolvable | undefined;
    set internalValue(value: ServicebusNamespaceNetworkRuleSetNetworkRulesA | cdktf.IResolvable | undefined);
    private _ignoreMissingVnetServiceEndpoint?;
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    resetIgnoreMissingVnetServiceEndpoint(): void;
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class ServicebusNamespaceNetworkRuleSetNetworkRulesAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServicebusNamespaceNetworkRuleSetNetworkRulesA[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServicebusNamespaceNetworkRuleSetNetworkRulesAOutputReference;
}
export interface ServicebusNamespaceNetworkRuleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#create ServicebusNamespaceNetworkRuleSetA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#delete ServicebusNamespaceNetworkRuleSetA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#read ServicebusNamespaceNetworkRuleSetA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#update ServicebusNamespaceNetworkRuleSetA#update}
    */
    readonly update?: string;
}
export declare function servicebusNamespaceNetworkRuleSetTimeoutsToTerraform(struct?: ServicebusNamespaceNetworkRuleSetTimeouts | cdktf.IResolvable): any;
export declare class ServicebusNamespaceNetworkRuleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicebusNamespaceNetworkRuleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServicebusNamespaceNetworkRuleSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set azurerm_servicebus_namespace_network_rule_set}
*/
export declare class ServicebusNamespaceNetworkRuleSetA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_servicebus_namespace_network_rule_set";
    /**
    * Generates CDKTF code for importing a ServicebusNamespaceNetworkRuleSetA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServicebusNamespaceNetworkRuleSetA to import
    * @param importFromId The id of the existing ServicebusNamespaceNetworkRuleSetA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServicebusNamespaceNetworkRuleSetA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/servicebus_namespace_network_rule_set azurerm_servicebus_namespace_network_rule_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusNamespaceNetworkRuleSetAConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusNamespaceNetworkRuleSetAConfig);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    resetDefaultAction(): void;
    get defaultActionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    get namespaceIdInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _trustedServicesAllowed?;
    get trustedServicesAllowed(): boolean | cdktf.IResolvable;
    set trustedServicesAllowed(value: boolean | cdktf.IResolvable);
    resetTrustedServicesAllowed(): void;
    get trustedServicesAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _networkRules;
    get networkRules(): ServicebusNamespaceNetworkRuleSetNetworkRulesAList;
    putNetworkRules(value: ServicebusNamespaceNetworkRuleSetNetworkRulesA[] | cdktf.IResolvable): void;
    resetNetworkRules(): void;
    get networkRulesInput(): cdktf.IResolvable | ServicebusNamespaceNetworkRuleSetNetworkRulesA[] | undefined;
    private _timeouts;
    get timeouts(): ServicebusNamespaceNetworkRuleSetTimeoutsOutputReference;
    putTimeouts(value: ServicebusNamespaceNetworkRuleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServicebusNamespaceNetworkRuleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
