/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudConfigurationServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#generation SpringCloudConfigurationService#generation}
    */
    readonly generation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#id SpringCloudConfigurationService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#name SpringCloudConfigurationService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#spring_cloud_service_id SpringCloudConfigurationService#spring_cloud_service_id}
    */
    readonly springCloudServiceId: string;
    /**
    * repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#repository SpringCloudConfigurationService#repository}
    */
    readonly repository?: SpringCloudConfigurationServiceRepository[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#timeouts SpringCloudConfigurationService#timeouts}
    */
    readonly timeouts?: SpringCloudConfigurationServiceTimeouts;
}
export interface SpringCloudConfigurationServiceRepository {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#ca_certificate_id SpringCloudConfigurationService#ca_certificate_id}
    */
    readonly caCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#host_key SpringCloudConfigurationService#host_key}
    */
    readonly hostKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#host_key_algorithm SpringCloudConfigurationService#host_key_algorithm}
    */
    readonly hostKeyAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#label SpringCloudConfigurationService#label}
    */
    readonly label: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#name SpringCloudConfigurationService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#password SpringCloudConfigurationService#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#patterns SpringCloudConfigurationService#patterns}
    */
    readonly patterns: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#private_key SpringCloudConfigurationService#private_key}
    */
    readonly privateKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#search_paths SpringCloudConfigurationService#search_paths}
    */
    readonly searchPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#strict_host_key_checking SpringCloudConfigurationService#strict_host_key_checking}
    */
    readonly strictHostKeyChecking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#uri SpringCloudConfigurationService#uri}
    */
    readonly uri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#username SpringCloudConfigurationService#username}
    */
    readonly username?: string;
}
export declare function springCloudConfigurationServiceRepositoryToTerraform(struct?: SpringCloudConfigurationServiceRepository | cdktf.IResolvable): any;
export declare class SpringCloudConfigurationServiceRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudConfigurationServiceRepository | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudConfigurationServiceRepository | cdktf.IResolvable | undefined);
    private _caCertificateId?;
    get caCertificateId(): string;
    set caCertificateId(value: string);
    resetCaCertificateId(): void;
    get caCertificateIdInput(): string | undefined;
    private _hostKey?;
    get hostKey(): string;
    set hostKey(value: string);
    resetHostKey(): void;
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    get hostKeyAlgorithm(): string;
    set hostKeyAlgorithm(value: string);
    resetHostKeyAlgorithm(): void;
    get hostKeyAlgorithmInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _patterns?;
    get patterns(): string[];
    set patterns(value: string[]);
    get patternsInput(): string[] | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _searchPaths?;
    get searchPaths(): string[];
    set searchPaths(value: string[]);
    resetSearchPaths(): void;
    get searchPathsInput(): string[] | undefined;
    private _strictHostKeyChecking?;
    get strictHostKeyChecking(): boolean | cdktf.IResolvable;
    set strictHostKeyChecking(value: boolean | cdktf.IResolvable);
    resetStrictHostKeyChecking(): void;
    get strictHostKeyCheckingInput(): boolean | cdktf.IResolvable | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class SpringCloudConfigurationServiceRepositoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpringCloudConfigurationServiceRepository[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudConfigurationServiceRepositoryOutputReference;
}
export interface SpringCloudConfigurationServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#create SpringCloudConfigurationService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#delete SpringCloudConfigurationService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#read SpringCloudConfigurationService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#update SpringCloudConfigurationService#update}
    */
    readonly update?: string;
}
export declare function springCloudConfigurationServiceTimeoutsToTerraform(struct?: SpringCloudConfigurationServiceTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudConfigurationServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudConfigurationServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudConfigurationServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service azurerm_spring_cloud_configuration_service}
*/
export declare class SpringCloudConfigurationService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_configuration_service";
    /**
    * Generates CDKTF code for importing a SpringCloudConfigurationService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudConfigurationService to import
    * @param importFromId The id of the existing SpringCloudConfigurationService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudConfigurationService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/spring_cloud_configuration_service azurerm_spring_cloud_configuration_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudConfigurationServiceConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudConfigurationServiceConfig);
    private _generation?;
    get generation(): string;
    set generation(value: string);
    resetGeneration(): void;
    get generationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _springCloudServiceId?;
    get springCloudServiceId(): string;
    set springCloudServiceId(value: string);
    get springCloudServiceIdInput(): string | undefined;
    private _repository;
    get repository(): SpringCloudConfigurationServiceRepositoryList;
    putRepository(value: SpringCloudConfigurationServiceRepository[] | cdktf.IResolvable): void;
    resetRepository(): void;
    get repositoryInput(): cdktf.IResolvable | SpringCloudConfigurationServiceRepository[] | undefined;
    private _timeouts;
    get timeouts(): SpringCloudConfigurationServiceTimeoutsOutputReference;
    putTimeouts(value: SpringCloudConfigurationServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudConfigurationServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
