/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsOutputServicebusQueueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#authentication_mode StreamAnalyticsOutputServicebusQueue#authentication_mode}
    */
    readonly authenticationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#id StreamAnalyticsOutputServicebusQueue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#name StreamAnalyticsOutputServicebusQueue#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#property_columns StreamAnalyticsOutputServicebusQueue#property_columns}
    */
    readonly propertyColumns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#queue_name StreamAnalyticsOutputServicebusQueue#queue_name}
    */
    readonly queueName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#resource_group_name StreamAnalyticsOutputServicebusQueue#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#servicebus_namespace StreamAnalyticsOutputServicebusQueue#servicebus_namespace}
    */
    readonly servicebusNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#shared_access_policy_key StreamAnalyticsOutputServicebusQueue#shared_access_policy_key}
    */
    readonly sharedAccessPolicyKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#shared_access_policy_name StreamAnalyticsOutputServicebusQueue#shared_access_policy_name}
    */
    readonly sharedAccessPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#stream_analytics_job_name StreamAnalyticsOutputServicebusQueue#stream_analytics_job_name}
    */
    readonly streamAnalyticsJobName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#system_property_columns StreamAnalyticsOutputServicebusQueue#system_property_columns}
    */
    readonly systemPropertyColumns?: {
        [key: string]: string;
    };
    /**
    * serialization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#serialization StreamAnalyticsOutputServicebusQueue#serialization}
    */
    readonly serialization: StreamAnalyticsOutputServicebusQueueSerialization;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#timeouts StreamAnalyticsOutputServicebusQueue#timeouts}
    */
    readonly timeouts?: StreamAnalyticsOutputServicebusQueueTimeouts;
}
export interface StreamAnalyticsOutputServicebusQueueSerialization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#encoding StreamAnalyticsOutputServicebusQueue#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#field_delimiter StreamAnalyticsOutputServicebusQueue#field_delimiter}
    */
    readonly fieldDelimiter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#format StreamAnalyticsOutputServicebusQueue#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#type StreamAnalyticsOutputServicebusQueue#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsOutputServicebusQueueSerializationToTerraform(struct?: StreamAnalyticsOutputServicebusQueueSerializationOutputReference | StreamAnalyticsOutputServicebusQueueSerialization): any;
export declare class StreamAnalyticsOutputServicebusQueueSerializationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsOutputServicebusQueueSerialization | undefined;
    set internalValue(value: StreamAnalyticsOutputServicebusQueueSerialization | undefined);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string;
    set fieldDelimiter(value: string);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StreamAnalyticsOutputServicebusQueueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#create StreamAnalyticsOutputServicebusQueue#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#delete StreamAnalyticsOutputServicebusQueue#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#read StreamAnalyticsOutputServicebusQueue#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#update StreamAnalyticsOutputServicebusQueue#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsOutputServicebusQueueTimeoutsToTerraform(struct?: StreamAnalyticsOutputServicebusQueueTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsOutputServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsOutputServicebusQueueTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsOutputServicebusQueueTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue azurerm_stream_analytics_output_servicebus_queue}
*/
export declare class StreamAnalyticsOutputServicebusQueue extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stream_analytics_output_servicebus_queue";
    /**
    * Generates CDKTF code for importing a StreamAnalyticsOutputServicebusQueue resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StreamAnalyticsOutputServicebusQueue to import
    * @param importFromId The id of the existing StreamAnalyticsOutputServicebusQueue that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StreamAnalyticsOutputServicebusQueue to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/stream_analytics_output_servicebus_queue azurerm_stream_analytics_output_servicebus_queue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsOutputServicebusQueueConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputServicebusQueueConfig);
    private _authenticationMode?;
    get authenticationMode(): string;
    set authenticationMode(value: string);
    resetAuthenticationMode(): void;
    get authenticationModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _propertyColumns?;
    get propertyColumns(): string[];
    set propertyColumns(value: string[]);
    resetPropertyColumns(): void;
    get propertyColumnsInput(): string[] | undefined;
    private _queueName?;
    get queueName(): string;
    set queueName(value: string);
    get queueNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _servicebusNamespace?;
    get servicebusNamespace(): string;
    set servicebusNamespace(value: string);
    get servicebusNamespaceInput(): string | undefined;
    private _sharedAccessPolicyKey?;
    get sharedAccessPolicyKey(): string;
    set sharedAccessPolicyKey(value: string);
    resetSharedAccessPolicyKey(): void;
    get sharedAccessPolicyKeyInput(): string | undefined;
    private _sharedAccessPolicyName?;
    get sharedAccessPolicyName(): string;
    set sharedAccessPolicyName(value: string);
    resetSharedAccessPolicyName(): void;
    get sharedAccessPolicyNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    get streamAnalyticsJobName(): string;
    set streamAnalyticsJobName(value: string);
    get streamAnalyticsJobNameInput(): string | undefined;
    private _systemPropertyColumns?;
    get systemPropertyColumns(): {
        [key: string]: string;
    };
    set systemPropertyColumns(value: {
        [key: string]: string;
    });
    resetSystemPropertyColumns(): void;
    get systemPropertyColumnsInput(): {
        [key: string]: string;
    } | undefined;
    private _serialization;
    get serialization(): StreamAnalyticsOutputServicebusQueueSerializationOutputReference;
    putSerialization(value: StreamAnalyticsOutputServicebusQueueSerialization): void;
    get serializationInput(): StreamAnalyticsOutputServicebusQueueSerialization | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsOutputServicebusQueueTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsOutputServicebusQueueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StreamAnalyticsOutputServicebusQueueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
