"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.P6Namer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambdajs = require("@aws-cdk/aws-lambda-nodejs");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
const floyd = require("cdk-iam-floyd");
/**
 * @stability stable
 */
class P6Namer extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const policy = new floyd.Iam()
            .allow()
            .toCreateAccountAlias();
        // XXX: https://github.com/aws/aws-cdk/pull/11729
        const entry = fs.existsSync(path.join(__dirname, 'p6namer.p6namer.ts'))
            ? path.join(__dirname, 'p6namer.p6namer.ts') // local development
            : path.join(__dirname, 'p6namer.p6namer.js'); // when published in npm
        const onEvent = new lambdajs.NodejsFunction(this, 'p6namer', {
            entry,
            runtime: lambda.Runtime.NODEJS_12_X,
            timeout: cdk.Duration.seconds(2),
            tracing: lambda.Tracing.ACTIVE,
            bundling: {
                minify: true,
                externalModules: [
                    'aws-sdk',
                ],
            },
        });
        onEvent.addToRolePolicy(policy);
        const provider = new cr.Provider(this, 'P6Namer/Provider', {
            onEventHandler: onEvent,
        });
        new cdk.CustomResource(this, 'P6Namer/CR', {
            serviceToken: provider.serviceToken,
            properties: {
                AccountAlias: props.accountAlias,
            },
        });
    }
}
exports.P6Namer = P6Namer;
_a = JSII_RTTI_SYMBOL_1;
P6Namer[_a] = { fqn: "p6-namer.P6Namer", version: "0.7.145" };
//# sourceMappingURL=data:application/json;base64,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