# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from across.sdk.v1.models.across_server_routes_v1_user_schemas_group import AcrossServerRoutesV1UserSchemasGroup
from across.sdk.v1.models.across_server_routes_v1_user_schemas_group_invite import AcrossServerRoutesV1UserSchemasGroupInvite
from across.sdk.v1.models.across_server_routes_v1_user_schemas_group_role import AcrossServerRoutesV1UserSchemasGroupRole
from across.sdk.v1.models.role_base import RoleBase
from typing import Optional, Set
from typing_extensions import Self

class AcrossServerRoutesV1UserSchemasUser(BaseModel):
    """
    AcrossServerRoutesV1UserSchemasUser
    """ # noqa: E501
    username: StrictStr
    first_name: StrictStr
    last_name: StrictStr
    email: StrictStr
    id: StrictStr
    groups: List[AcrossServerRoutesV1UserSchemasGroup]
    roles: List[RoleBase]
    group_roles: List[AcrossServerRoutesV1UserSchemasGroupRole]
    received_invites: List[AcrossServerRoutesV1UserSchemasGroupInvite]
    __properties: ClassVar[List[str]] = ["username", "first_name", "last_name", "email", "id", "groups", "roles", "group_roles", "received_invites"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcrossServerRoutesV1UserSchemasUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item_roles in self.roles:
                if _item_roles:
                    _items.append(_item_roles.to_dict())
            _dict['roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in group_roles (list)
        _items = []
        if self.group_roles:
            for _item_group_roles in self.group_roles:
                if _item_group_roles:
                    _items.append(_item_group_roles.to_dict())
            _dict['group_roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in received_invites (list)
        _items = []
        if self.received_invites:
            for _item_received_invites in self.received_invites:
                if _item_received_invites:
                    _items.append(_item_received_invites.to_dict())
            _dict['received_invites'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcrossServerRoutesV1UserSchemasUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email": obj.get("email"),
            "id": obj.get("id"),
            "groups": [AcrossServerRoutesV1UserSchemasGroup.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "roles": [RoleBase.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "group_roles": [AcrossServerRoutesV1UserSchemasGroupRole.from_dict(_item) for _item in obj["group_roles"]] if obj.get("group_roles") is not None else None,
            "received_invites": [AcrossServerRoutesV1UserSchemasGroupInvite.from_dict(_item) for _item in obj["received_invites"]] if obj.get("received_invites") is not None else None
        })
        return _obj


