# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Filter(BaseModel):
    """
    A Pydantic model class representing a created Filter  Notes ----- Inherits from FilterBase
    """ # noqa: E501
    id: StrictStr
    created_on: datetime
    name: StrictStr
    peak_wavelength: Optional[Union[StrictFloat, StrictInt]]
    min_wavelength: Union[StrictFloat, StrictInt]
    max_wavelength: Union[StrictFloat, StrictInt]
    is_operational: StrictBool
    sensitivity_depth_unit: Optional[Union[StrictFloat, StrictInt]]
    sensitivity_depth: Optional[Union[StrictFloat, StrictInt]]
    sensitivity_time_seconds: Optional[Union[StrictFloat, StrictInt]]
    reference_url: Optional[StrictStr]
    instrument_id: StrictStr
    __properties: ClassVar[List[str]] = ["id", "created_on", "name", "peak_wavelength", "min_wavelength", "max_wavelength", "is_operational", "sensitivity_depth_unit", "sensitivity_depth", "sensitivity_time_seconds", "reference_url", "instrument_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Filter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if peak_wavelength (nullable) is None
        # and model_fields_set contains the field
        if self.peak_wavelength is None and "peak_wavelength" in self.model_fields_set:
            _dict['peak_wavelength'] = None

        # set to None if sensitivity_depth_unit (nullable) is None
        # and model_fields_set contains the field
        if self.sensitivity_depth_unit is None and "sensitivity_depth_unit" in self.model_fields_set:
            _dict['sensitivity_depth_unit'] = None

        # set to None if sensitivity_depth (nullable) is None
        # and model_fields_set contains the field
        if self.sensitivity_depth is None and "sensitivity_depth" in self.model_fields_set:
            _dict['sensitivity_depth'] = None

        # set to None if sensitivity_time_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.sensitivity_time_seconds is None and "sensitivity_time_seconds" in self.model_fields_set:
            _dict['sensitivity_time_seconds'] = None

        # set to None if reference_url (nullable) is None
        # and model_fields_set contains the field
        if self.reference_url is None and "reference_url" in self.model_fields_set:
            _dict['reference_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Filter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_on": obj.get("created_on"),
            "name": obj.get("name"),
            "peak_wavelength": obj.get("peak_wavelength"),
            "min_wavelength": obj.get("min_wavelength"),
            "max_wavelength": obj.get("max_wavelength"),
            "is_operational": obj.get("is_operational"),
            "sensitivity_depth_unit": obj.get("sensitivity_depth_unit"),
            "sensitivity_depth": obj.get("sensitivity_depth"),
            "sensitivity_time_seconds": obj.get("sensitivity_time_seconds"),
            "reference_url": obj.get("reference_url"),
            "instrument_id": obj.get("instrument_id")
        })
        return _obj


