# coding: utf-8

"""
    ACROSS Server

    Server providing tools and utilities for various NASA missions to aid in coordination of large observation efforts.

    The version of the OpenAPI document: 0.3.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from across.sdk.v1.models.ground_parameters import GroundParameters
from across.sdk.v1.models.jpl_parameters import JPLParameters
from across.sdk.v1.models.spice_parameters import SPICEParameters
from across.sdk.v1.models.tle_parameters import TLEParameters
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

PARAMETERS_ANY_OF_SCHEMAS = ["GroundParameters", "JPLParameters", "SPICEParameters", "TLEParameters"]

class Parameters(BaseModel):
    """
    Parameters
    """

    # data type: TLEParameters
    anyof_schema_1_validator: Optional[TLEParameters] = None
    # data type: JPLParameters
    anyof_schema_2_validator: Optional[JPLParameters] = None
    # data type: SPICEParameters
    anyof_schema_3_validator: Optional[SPICEParameters] = None
    # data type: GroundParameters
    anyof_schema_4_validator: Optional[GroundParameters] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[GroundParameters, JPLParameters, SPICEParameters, TLEParameters]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "GroundParameters", "JPLParameters", "SPICEParameters", "TLEParameters" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = Parameters.model_construct()
        error_messages = []
        # validate data type: TLEParameters
        if not isinstance(v, TLEParameters):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TLEParameters`")
        else:
            return v

        # validate data type: JPLParameters
        if not isinstance(v, JPLParameters):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JPLParameters`")
        else:
            return v

        # validate data type: SPICEParameters
        if not isinstance(v, SPICEParameters):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SPICEParameters`")
        else:
            return v

        # validate data type: GroundParameters
        if not isinstance(v, GroundParameters):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GroundParameters`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Parameters with anyOf schemas: GroundParameters, JPLParameters, SPICEParameters, TLEParameters. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[TLEParameters] = None
        try:
            instance.actual_instance = TLEParameters.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[JPLParameters] = None
        try:
            instance.actual_instance = JPLParameters.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[SPICEParameters] = None
        try:
            instance.actual_instance = SPICEParameters.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[GroundParameters] = None
        try:
            instance.actual_instance = GroundParameters.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Parameters with anyOf schemas: GroundParameters, JPLParameters, SPICEParameters, TLEParameters. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], GroundParameters, JPLParameters, SPICEParameters, TLEParameters]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


