"""Auto-generated combined character transliterator.

Replace each combined character with its corresponding individual characters.
"""

from collections.abc import Iterable
from typing import Any

from ..chars import Char

__all__ = ["Transliterator"]

# Generated mapping data
COMBINED_MAPPINGS = {
    "\u2116": ["N", "o"],
    "\u2120": ["S", "M"],
    "\u2121": ["T", "E", "L"],
    "\u2122": ["T", "M"],
    "\u213b": ["F", "A", "X"],
    "\u2150": ["1", "/", "7"],
    "\u2151": ["1", "/", "9"],
    "\u2152": ["1", "/", "1", "0"],
    "\u2153": ["1", "/", "3"],
    "\u2154": ["2", "/", "3"],
    "\u2155": ["1", "/", "5"],
    "\u2156": ["2", "/", "5"],
    "\u2157": ["3", "/", "5"],
    "\u2158": ["4", "/", "5"],
    "\u2159": ["1", "/", "6"],
    "\u215a": ["5", "/", "6"],
    "\u215b": ["1", "/", "8"],
    "\u215c": ["3", "/", "8"],
    "\u215d": ["5", "/", "8"],
    "\u215e": ["7", "/", "8"],
    "\u215f": ["1", "/"],
    "\u2189": ["0", "/", "3"],
    "\u2400": ["N", "U", "L"],
    "\u2401": ["S", "O", "H"],
    "\u2402": ["S", "T", "X"],
    "\u2403": ["E", "T", "X"],
    "\u2404": ["E", "O", "T"],
    "\u2405": ["E", "N", "Q"],
    "\u2406": ["A", "C", "K"],
    "\u2407": ["B", "E", "L"],
    "\u2408": ["B", "S"],
    "\u2409": ["H", "T"],
    "\u240a": ["L", "F"],
    "\u240b": ["V", "T"],
    "\u240c": ["F", "F"],
    "\u240d": ["C", "R"],
    "\u240e": ["S", "O"],
    "\u240f": ["S", "I"],
    "\u2410": ["D", "L", "E"],
    "\u2411": ["D", "C", "1"],
    "\u2412": ["D", "C", "2"],
    "\u2413": ["D", "C", "3"],
    "\u2414": ["D", "C", "4"],
    "\u2415": ["N", "A", "K"],
    "\u2416": ["S", "Y", "N"],
    "\u2417": ["E", "T", "B"],
    "\u2418": ["C", "A", "N"],
    "\u2419": ["E", "M"],
    "\u241a": ["S", "U", "B"],
    "\u241b": ["E", "S", "C"],
    "\u241c": ["F", "S"],
    "\u241d": ["G", "S"],
    "\u241e": ["R", "S"],
    "\u241f": ["U", "S"],
    "\u2420": ["S", "P"],
    "\u2421": ["D", "E", "L"],
    "\u2474": ["(", "1", ")"],
    "\u2475": ["(", "2", ")"],
    "\u2476": ["(", "3", ")"],
    "\u2477": ["(", "4", ")"],
    "\u2478": ["(", "5", ")"],
    "\u2479": ["(", "6", ")"],
    "\u247a": ["(", "7", ")"],
    "\u247b": ["(", "8", ")"],
    "\u247c": ["(", "9", ")"],
    "\u247d": ["(", "1", "0", ")"],
    "\u247e": ["(", "1", "1", ")"],
    "\u247f": ["(", "1", "2", ")"],
    "\u2480": ["(", "1", "3", ")"],
    "\u2481": ["(", "1", "4", ")"],
    "\u2482": ["(", "1", "5", ")"],
    "\u2483": ["(", "1", "6", ")"],
    "\u2484": ["(", "1", "7", ")"],
    "\u2485": ["(", "1", "8", ")"],
    "\u2486": ["(", "1", "9", ")"],
    "\u2487": ["(", "2", "0", ")"],
    "\u2488": ["1", "."],
    "\u2489": ["2", "."],
    "\u248a": ["3", "."],
    "\u248b": ["4", "."],
    "\u248c": ["5", "."],
    "\u248d": ["6", "."],
    "\u248e": ["7", "."],
    "\u248f": ["8", "."],
    "\u2490": ["9", "."],
    "\u2491": ["1", "0", "."],
    "\u2492": ["1", "1", "."],
    "\u2493": ["1", "2", "."],
    "\u2494": ["1", "3", "."],
    "\u2495": ["1", "4", "."],
    "\u2496": ["1", "5", "."],
    "\u2497": ["1", "6", "."],
    "\u2498": ["1", "7", "."],
    "\u2499": ["1", "8", "."],
    "\u249a": ["1", "9", "."],
    "\u249b": ["2", "0", "."],
    "\u249c": ["(", "a", ")"],
    "\u249d": ["(", "b", ")"],
    "\u249e": ["(", "c", ")"],
    "\u249f": ["(", "d", ")"],
    "\u24a0": ["(", "e", ")"],
    "\u24a1": ["(", "f", ")"],
    "\u24a2": ["(", "g", ")"],
    "\u24a3": ["(", "h", ")"],
    "\u24a4": ["(", "i", ")"],
    "\u24a5": ["(", "j", ")"],
    "\u24a6": ["(", "k", ")"],
    "\u24a7": ["(", "l", ")"],
    "\u24a8": ["(", "m", ")"],
    "\u24a9": ["(", "n", ")"],
    "\u24aa": ["(", "o", ")"],
    "\u24ab": ["(", "p", ")"],
    "\u24ac": ["(", "q", ")"],
    "\u24ad": ["(", "r", ")"],
    "\u24ae": ["(", "s", ")"],
    "\u24af": ["(", "t", ")"],
    "\u24b0": ["(", "u", ")"],
    "\u24b1": ["(", "v", ")"],
    "\u24b2": ["(", "w", ")"],
    "\u24b3": ["(", "x", ")"],
    "\u24b4": ["(", "y", ")"],
    "\u24b5": ["(", "z", ")"],
    "\u3220": ["(", "一", ")"],
    "\u3221": ["(", "二", ")"],
    "\u3222": ["(", "三", ")"],
    "\u3223": ["(", "四", ")"],
    "\u3224": ["(", "五", ")"],
    "\u3225": ["(", "六", ")"],
    "\u3226": ["(", "七", ")"],
    "\u3227": ["(", "八", ")"],
    "\u3228": ["(", "九", ")"],
    "\u3229": ["(", "十", ")"],
    "\u322a": ["(", "月", ")"],
    "\u322b": ["(", "火", ")"],
    "\u322c": ["(", "水", ")"],
    "\u322d": ["(", "木", ")"],
    "\u322e": ["(", "金", ")"],
    "\u322f": ["(", "土", ")"],
    "\u3230": ["(", "日", ")"],
    "\u3231": ["(", "株", ")"],
    "\u3232": ["(", "有", ")"],
    "\u3233": ["(", "社", ")"],
    "\u3234": ["(", "名", ")"],
    "\u3235": ["(", "特", ")"],
    "\u3236": ["(", "財", ")"],
    "\u3237": ["(", "祝", ")"],
    "\u3238": ["(", "労", ")"],
    "\u3239": ["(", "代", ")"],
    "\u323a": ["(", "呼", ")"],
    "\u323b": ["(", "学", ")"],
    "\u323c": ["(", "監", ")"],
    "\u323d": ["(", "企", ")"],
    "\u323e": ["(", "資", ")"],
    "\u323f": ["(", "協", ")"],
    "\u3240": ["(", "祭", ")"],
    "\u3241": ["(", "休", ")"],
    "\u3242": ["(", "自", ")"],
    "\u3243": ["(", "至", ")"],
    "\u3250": ["P", "T", "E"],
    "\u32c0": ["1", "月"],
    "\u32c1": ["2", "月"],
    "\u32c2": ["3", "月"],
    "\u32c3": ["4", "月"],
    "\u32c4": ["5", "月"],
    "\u32c5": ["6", "月"],
    "\u32c6": ["7", "月"],
    "\u32c7": ["8", "月"],
    "\u32c8": ["9", "月"],
    "\u32c9": ["1", "0", "月"],
    "\u32ca": ["1", "1", "月"],
    "\u32cb": ["1", "2", "月"],
    "\u32cc": ["H", "g"],
    "\u32cd": ["e", "r", "g"],
    "\u32ce": ["e", "V"],
    "\u32cf": ["L", "T", "D"],
    "\u32ff": ["令", "和"],
    "\u3300": ["ア", "パ", "ー", "ト"],
    "\u3301": ["ア", "ル", "フ", "ァ"],
    "\u3302": ["ア", "ン", "ペ", "ア"],
    "\u3303": ["ア", "ー", "ル"],
    "\u3304": ["イ", "ニ", "ン", "グ"],
    "\u3305": ["イ", "ン", "チ"],
    "\u3306": ["ウ", "ォ", "ン"],
    "\u3307": ["エ", "ス", "ク", "ー", "ド"],
    "\u3308": ["エ", "ー", "カ", "ー"],
    "\u3309": ["オ", "ン", "ス"],
    "\u330a": ["オ", "ー", "ム"],
    "\u330b": ["カ", "イ", "リ"],
    "\u330c": ["カ", "ラ", "ッ", "ト"],
    "\u330d": ["カ", "ロ", "リ", "ー"],
    "\u330e": ["ガ", "ロ", "ン"],
    "\u330f": ["ガ", "ン", "マ"],
    "\u3310": ["ギ", "ガ"],
    "\u3311": ["ギ", "ニ", "ー"],
    "\u3312": ["キ", "ュ", "リ", "ー"],
    "\u3313": ["ギ", "ル", "ダ", "ー"],
    "\u3314": ["キ", "ロ"],
    "\u3315": ["キ", "ロ", "グ", "ラ", "ム"],
    "\u3316": ["キ", "ロ", "メ", "ー", "ト", "ル"],
    "\u3317": ["キ", "ロ", "ワ", "ッ", "ト"],
    "\u3318": ["グ", "ラ", "ム"],
    "\u3319": ["グ", "ラ", "ム", "ト", "ン"],
    "\u331a": ["ク", "ル", "ゼ", "イ", "ロ"],
    "\u331b": ["ク", "ロ", "ー", "ネ"],
    "\u331c": ["ケ", "ー", "ス"],
    "\u331d": ["コ", "ル", "ナ"],
    "\u331e": ["コ", "ー", "ポ"],
    "\u331f": ["サ", "イ", "ク", "ル"],
    "\u3320": ["サ", "ン", "チ", "ー", "ム"],
    "\u3321": ["シ", "リ", "ン", "グ"],
    "\u3322": ["セ", "ン", "チ"],
    "\u3323": ["セ", "ン", "ト"],
    "\u3324": ["ダ", "ー", "ス"],
    "\u3325": ["デ", "シ"],
    "\u3326": ["ド", "ル"],
    "\u3327": ["ト", "ン"],
    "\u3328": ["ナ", "ノ"],
    "\u3329": ["ノ", "ッ", "ト"],
    "\u332a": ["ハ", "イ", "ツ"],
    "\u332b": ["パ", "ー", "セ", "ン", "ト"],
    "\u332c": ["パ", "ー", "ツ"],
    "\u332d": ["バ", "ー", "レ", "ル"],
    "\u332e": ["ピ", "ア", "ス", "ト", "ル"],
    "\u332f": ["ピ", "ク", "ル"],
    "\u3330": ["ピ", "コ"],
    "\u3331": ["ビ", "ル"],
    "\u3332": ["フ", "ァ", "ラ", "ッ", "ド"],
    "\u3333": ["フ", "ィ", "ー", "ト"],
    "\u3334": ["ブ", "ッ", "シ", "ェ", "ル"],
    "\u3335": ["フ", "ラ", "ン"],
    "\u3336": ["ヘ", "ク", "タ", "ー", "ル"],
    "\u3337": ["ペ", "ソ"],
    "\u3338": ["ペ", "ニ", "ヒ"],
    "\u3339": ["ヘ", "ル", "ツ"],
    "\u333a": ["ペ", "ン", "ス"],
    "\u333b": ["ペ", "ー", "ジ"],
    "\u333c": ["ベ", "ー", "タ"],
    "\u333d": ["ポ", "イ", "ン", "ト"],
    "\u333e": ["ボ", "ル", "ト"],
    "\u333f": ["ホ", "ン"],
    "\u3340": ["ポ", "ン", "ド"],
    "\u3341": ["ホ", "ー", "ル"],
    "\u3342": ["ホ", "ー", "ン"],
    "\u3343": ["マ", "イ", "ク", "ロ"],
    "\u3344": ["マ", "イ", "ル"],
    "\u3345": ["マ", "ッ", "ハ"],
    "\u3346": ["マ", "ル", "ク"],
    "\u3347": ["マ", "ン", "シ", "ョ", "ン"],
    "\u3348": ["ミ", "ク", "ロ", "ン"],
    "\u3349": ["ミ", "リ"],
    "\u334a": ["ミ", "リ", "バ", "ー", "ル"],
    "\u334b": ["メ", "ガ"],
    "\u334c": ["メ", "ガ", "ト", "ン"],
    "\u334d": ["メ", "ー", "ト", "ル"],
    "\u334e": ["ヤ", "ー", "ド"],
    "\u334f": ["ヤ", "ー", "ル"],
    "\u3350": ["ユ", "ア", "ン"],
    "\u3351": ["リ", "ッ", "ト", "ル"],
    "\u3352": ["リ", "ラ"],
    "\u3353": ["ル", "ピ", "ー"],
    "\u3354": ["ル", "ー", "ブ", "ル"],
    "\u3355": ["レ", "ム"],
    "\u3356": ["レ", "ン", "ト", "ゲ", "ン"],
    "\u3357": ["ワ", "ッ", "ト"],
    "\u3358": ["0", "点"],
    "\u3359": ["1", "点"],
    "\u335a": ["2", "点"],
    "\u335b": ["3", "点"],
    "\u335c": ["4", "点"],
    "\u335d": ["5", "点"],
    "\u335e": ["6", "点"],
    "\u335f": ["7", "点"],
    "\u3360": ["8", "点"],
    "\u3361": ["9", "点"],
    "\u3362": ["1", "0", "点"],
    "\u3363": ["1", "1", "点"],
    "\u3364": ["1", "2", "点"],
    "\u3365": ["1", "3", "点"],
    "\u3366": ["1", "4", "点"],
    "\u3367": ["1", "5", "点"],
    "\u3368": ["1", "6", "点"],
    "\u3369": ["1", "7", "点"],
    "\u336a": ["1", "8", "点"],
    "\u336b": ["1", "9", "点"],
    "\u336c": ["2", "0", "点"],
    "\u336d": ["2", "1", "点"],
    "\u336e": ["2", "2", "点"],
    "\u336f": ["2", "3", "点"],
    "\u3370": ["2", "4", "点"],
    "\u3371": ["h", "P", "a"],
    "\u3372": ["d", "a"],
    "\u3373": ["A", "U"],
    "\u3374": ["b", "a", "r"],
    "\u3375": ["o", "V"],
    "\u3376": ["p", "c"],
    "\u3377": ["d", "m"],
    "\u3378": ["d", "m", "2"],
    "\u3379": ["d", "m", "3"],
    "\u337a": ["I", "U"],
    "\u337b": ["平", "成"],
    "\u337c": ["昭", "和"],
    "\u337d": ["大", "正"],
    "\u337e": ["明", "治"],
    "\u337f": ["株", "式", "会", "社"],
    "\u3380": ["p", "A"],
    "\u3381": ["n", "A"],
    "\u3382": ["µ", "A"],
    "\u3383": ["m", "A"],
    "\u3384": ["k", "A"],
    "\u3385": ["K", "B"],
    "\u3386": ["M", "B"],
    "\u3387": ["G", "B"],
    "\u3388": ["c", "a", "l"],
    "\u3389": ["k", "c", "a", "l"],
    "\u338a": ["p", "F"],
    "\u338b": ["n", "F"],
    "\u338c": ["µ", "F"],
    "\u338d": ["µ", "g"],
    "\u338e": ["m", "g"],
    "\u338f": ["k", "g"],
    "\u3390": ["H", "z"],
    "\u3391": ["k", "H", "z"],
    "\u3392": ["M", "H", "z"],
    "\u3393": ["G", "H", "z"],
    "\u3394": ["T", "H", "z"],
    "\u3395": ["µ", "l"],
    "\u3396": ["m", "l"],
    "\u3397": ["d", "l"],
    "\u3398": ["k", "l"],
    "\u3399": ["f", "m"],
    "\u339a": ["n", "m"],
    "\u339b": ["µ", "m"],
    "\u339c": ["m", "m"],
    "\u339d": ["c", "m"],
    "\u339e": ["k", "m"],
    "\u339f": ["m", "m", "2"],
    "\u33a0": ["c", "m", "2"],
    "\u33a1": ["m", "2"],
    "\u33a2": ["k", "m", "2"],
    "\u33a3": ["m", "m", "3"],
    "\u33a4": ["c", "m", "3"],
    "\u33a5": ["m", "3"],
    "\u33a6": ["k", "m", "3"],
    "\u33a7": ["m", "/", "s"],
    "\u33a8": ["m", "/", "s", "2"],
    "\u33a9": ["P", "a"],
    "\u33aa": ["k", "P", "a"],
    "\u33ab": ["M", "P", "a"],
    "\u33ac": ["G", "P", "a"],
    "\u33ad": ["r", "a", "d"],
    "\u33ae": ["r", "a", "d", "/", "s"],
    "\u33af": ["r", "a", "d", "/", "s", "2"],
    "\u33b0": ["p", "s"],
    "\u33b1": ["n", "s"],
    "\u33b2": ["µ", "s"],
    "\u33b3": ["m", "s"],
    "\u33b4": ["p", "V"],
    "\u33b5": ["n", "V"],
    "\u33b6": ["µ", "V"],
    "\u33b7": ["m", "V"],
    "\u33b8": ["k", "V"],
    "\u33b9": ["M", "V"],
    "\u33ba": ["p", "W"],
    "\u33bb": ["n", "W"],
    "\u33bc": ["µ", "W"],
    "\u33bd": ["m", "W"],
    "\u33be": ["k", "W"],
    "\u33bf": ["M", "W"],
    "\u33c0": ["k", "Ω"],
    "\u33c1": ["M", "Ω"],
    "\u33c2": ["a", ".", "m", "."],
    "\u33c3": ["B", "q"],
    "\u33c4": ["c", "c"],
    "\u33c5": ["c", "d"],
    "\u33c6": ["C", "/", "k", "g"],
    "\u33c7": ["C", "o", "."],
    "\u33c8": ["d", "B"],
    "\u33c9": ["G", "y"],
    "\u33ca": ["h", "a"],
    "\u33cb": ["H", "P"],
    "\u33cc": ["i", "n"],
    "\u33cd": ["K", ".", "K", "."],
    "\u33ce": ["K", "M"],
    "\u33cf": ["k", "t"],
    "\u33d0": ["l", "m"],
    "\u33d1": ["l", "n"],
    "\u33d2": ["l", "o", "g"],
    "\u33d3": ["l", "x"],
    "\u33d4": ["m", "b"],
    "\u33d5": ["m", "i", "l"],
    "\u33d6": ["m", "o", "l"],
    "\u33d7": ["p", "H"],
    "\u33d8": ["p", ".", "m", "."],
    "\u33d9": ["p", "p", "m"],
    "\u33da": ["P", "R"],
    "\u33db": ["s", "r"],
    "\u33dc": ["S", "v"],
    "\u33dd": ["W", "b"],
    "\u33de": ["V", "/", "m"],
    "\u33df": ["A", "/", "m"],
    "\u33e0": ["1", "日"],
    "\u33e1": ["2", "日"],
    "\u33e2": ["3", "日"],
    "\u33e3": ["4", "日"],
    "\u33e4": ["5", "日"],
    "\u33e5": ["6", "日"],
    "\u33e6": ["7", "日"],
    "\u33e7": ["8", "日"],
    "\u33e8": ["9", "日"],
    "\u33e9": ["1", "0", "日"],
    "\u33ea": ["1", "1", "日"],
    "\u33eb": ["1", "2", "日"],
    "\u33ec": ["1", "3", "日"],
    "\u33ed": ["1", "4", "日"],
    "\u33ee": ["1", "5", "日"],
    "\u33ef": ["1", "6", "日"],
    "\u33f0": ["1", "7", "日"],
    "\u33f1": ["1", "8", "日"],
    "\u33f2": ["1", "9", "日"],
    "\u33f3": ["2", "0", "日"],
    "\u33f4": ["2", "1", "日"],
    "\u33f5": ["2", "2", "日"],
    "\u33f6": ["2", "3", "日"],
    "\u33f7": ["2", "4", "日"],
    "\u33f8": ["2", "5", "日"],
    "\u33f9": ["2", "6", "日"],
    "\u33fa": ["2", "7", "日"],
    "\u33fb": ["2", "8", "日"],
    "\u33fc": ["2", "9", "日"],
    "\u33fd": ["3", "0", "日"],
    "\u33fe": ["3", "1", "日"],
    "\u33ff": ["g", "a", "l"],
    "\U0001f100": ["0", "."],
    "\U0001f101": ["0", ","],
    "\U0001f102": ["1", ","],
    "\U0001f103": ["2", ","],
    "\U0001f104": ["3", ","],
    "\U0001f105": ["4", ","],
    "\U0001f106": ["5", ","],
    "\U0001f107": ["6", ","],
    "\U0001f108": ["7", ","],
    "\U0001f109": ["8", ","],
    "\U0001f10a": ["9", ","],
    "\U0001f110": ["(", "A", ")"],
    "\U0001f111": ["(", "B", ")"],
    "\U0001f112": ["(", "C", ")"],
    "\U0001f113": ["(", "D", ")"],
    "\U0001f114": ["(", "E", ")"],
    "\U0001f115": ["(", "F", ")"],
    "\U0001f116": ["(", "G", ")"],
    "\U0001f117": ["(", "H", ")"],
    "\U0001f118": ["(", "I", ")"],
    "\U0001f119": ["(", "J", ")"],
    "\U0001f11a": ["(", "K", ")"],
    "\U0001f11b": ["(", "L", ")"],
    "\U0001f11c": ["(", "M", ")"],
    "\U0001f11d": ["(", "N", ")"],
    "\U0001f11e": ["(", "O", ")"],
    "\U0001f11f": ["(", "P", ")"],
    "\U0001f120": ["(", "Q", ")"],
    "\U0001f121": ["(", "R", ")"],
    "\U0001f122": ["(", "S", ")"],
    "\U0001f123": ["(", "T", ")"],
    "\U0001f124": ["(", "U", ")"],
    "\U0001f125": ["(", "V", ")"],
    "\U0001f126": ["(", "W", ")"],
    "\U0001f127": ["(", "X", ")"],
    "\U0001f128": ["(", "Y", ")"],
    "\U0001f129": ["(", "Z", ")"],
    "\U0001f12a": ["〔", "S", "〕"],
    "\U0001f16a": ["M", "C"],
    "\U0001f16b": ["M", "D"],
    "\U0001f16c": ["M", "R"],
    "\U0001f200": ["ほ", "か"],
    "\U0001f240": ["〔", "本", "〕"],
    "\U0001f241": ["〔", "三", "〕"],
    "\U0001f242": ["〔", "二", "〕"],
    "\U0001f243": ["〔", "安", "〕"],
    "\U0001f244": ["〔", "点", "〕"],
    "\U0001f245": ["〔", "打", "〕"],
    "\U0001f246": ["〔", "盗", "〕"],
    "\U0001f247": ["〔", "勝", "〕"],
    "\U0001f248": ["〔", "敗", "〕"],
}


class Transliterator:
    """Transliterator for combined characters.

    Replace each combined character with its corresponding individual characters.
    """

    def __init__(self, **_options: Any) -> None:
        """Initialize the transliterator with options.

        :param _options: Configuration options (currently unused)
        """

    def __call__(self, input_chars: Iterable[Char]) -> Iterable[Char]:
        """Replace each combined character with its corresponding individual characters."""
        offset = 0
        for char in input_chars:
            replacement_list = COMBINED_MAPPINGS.get(char.c)
            if replacement_list is not None:
                for replacement_char in replacement_list:
                    yield Char(c=replacement_char, offset=offset, source=char)
                    offset += len(replacement_char)
            else:
                yield char.with_offset(offset)
                offset += len(char.c)
