"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginMutation = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
class OriginMutation extends edge_function_1.EdgeFunction {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            name: 'origin-mutation',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'origin-mutation')),
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.ORIGIN_REQUEST,
            edgeRole: props.edgeRole,
            configuration: {
                logLevel: props.logLevel ?? with_configuration_1.LogLevel.WARN,
            },
        });
    }
}
exports.OriginMutation = OriginMutation;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3JpZ2luLW11dGF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL29yaWdpbi1tdXRhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFDN0IsNkNBQXlEO0FBR3pELG1EQUF3RTtBQUN4RSw2REFBZ0Q7QUFNaEQsTUFBYSxjQUFlLFNBQVEsNEJBQVk7SUFDOUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE2QixFQUFFO1FBQ3ZFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsSUFBSSxFQUFFLGlCQUFpQjtZQUN2QixJQUFJLEVBQUUsd0JBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1lBQ25GLFNBQVMsRUFBRSw0QkFBYyxDQUFDLG1CQUFtQixDQUFDLGNBQWM7WUFDNUQsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLGFBQWEsRUFBRTtnQkFDYixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVEsSUFBSSw2QkFBUSxDQUFDLElBQUk7YUFDMUM7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFaRCx3Q0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBhd3NfY2xvdWRmcm9udCwgYXdzX2xhbWJkYSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5pbXBvcnQgeyBFZGdlRnVuY3Rpb24sIENvbW1vbkVkZ2VGdW5jdGlvblByb3BzIH0gZnJvbSAnLi9lZGdlLWZ1bmN0aW9uJztcbmltcG9ydCB7IExvZ0xldmVsIH0gZnJvbSAnLi93aXRoLWNvbmZpZ3VyYXRpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIE9yaWdpbk11dGF0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25FZGdlRnVuY3Rpb25Qcm9wcyB7XG4gIHJlYWRvbmx5IGxvZ0xldmVsPzogTG9nTGV2ZWw7XG59XG5cbmV4cG9ydCBjbGFzcyBPcmlnaW5NdXRhdGlvbiBleHRlbmRzIEVkZ2VGdW5jdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBPcmlnaW5NdXRhdGlvblByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIG5hbWU6ICdvcmlnaW4tbXV0YXRpb24nLFxuICAgICAgY29kZTogYXdzX2xhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGFtYmRhcycsICdvcmlnaW4tbXV0YXRpb24nKSksXG4gICAgICBldmVudFR5cGU6IGF3c19jbG91ZGZyb250LkxhbWJkYUVkZ2VFdmVudFR5cGUuT1JJR0lOX1JFUVVFU1QsXG4gICAgICBlZGdlUm9sZTogcHJvcHMuZWRnZVJvbGUsXG4gICAgICBjb25maWd1cmF0aW9uOiB7XG4gICAgICAgIGxvZ0xldmVsOiBwcm9wcy5sb2dMZXZlbCA/PyBMb2dMZXZlbC5XQVJOLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19