import { aws_lambda } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export declare enum LogLevel {
    NONE = "none",
    INFO = "info",
    WARN = "warn",
    ERROR = "error",
    DEBUG = "debug"
}
export interface Configuration {
    readonly logLevel: LogLevel;
    readonly [key: string]: unknown;
}
export interface WithConfigurationProps {
    readonly function: aws_lambda.IFunction;
    readonly configuration: Configuration;
}
export declare class WithConfiguration extends Construct {
    readonly functionVersion: aws_lambda.IVersion;
    constructor(scope: Construct, id: string, props: WithConfigurationProps);
}
