"use strict";
const cfn_parse_1 = require("../lib/cfn-parse");
module.exports = {
    'FromCloudFormation class': {
        '#parseCreationPolicy': {
            'returns undefined when given a non-object as the argument'(test) {
                test.equal(cfn_parse_1.FromCloudFormation.parseCreationPolicy('blah'), undefined);
                test.done();
            },
            'returns undefined when given an empty object as the argument'(test) {
                test.equal(cfn_parse_1.FromCloudFormation.parseCreationPolicy({}), undefined);
                test.done();
            },
            'returns undefined when given empty sub-objects as the argument'(test) {
                test.equal(cfn_parse_1.FromCloudFormation.parseCreationPolicy({
                    AutoScalingCreationPolicy: null,
                    ResourceSignal: {
                        Count: undefined,
                    },
                }), undefined);
                test.done();
            },
        },
        '#parseUpdatePolicy': {
            'returns undefined when given a non-object as the argument'(test) {
                test.equal(cfn_parse_1.FromCloudFormation.parseUpdatePolicy('blah'), undefined);
                test.done();
            },
            'returns undefined when given an empty object as the argument'(test) {
                test.equal(cfn_parse_1.FromCloudFormation.parseUpdatePolicy({}), undefined);
                test.done();
            },
            'returns undefined when given empty sub-objects as the argument'(test) {
                test.equal(cfn_parse_1.FromCloudFormation.parseUpdatePolicy({
                    AutoScalingReplacingUpdate: null,
                    AutoScalingRollingUpdate: {
                        PauseTime: undefined,
                    },
                }), undefined);
                test.done();
            },
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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