
# EIDA Embargo Roller

## Description
This program processes a `stationXML` file in input and updates channels epochs to reflect the embargo start date specified.

1. **If the channel epoch ends before the embargo**: No changes are made.
2. **If the channel epoch ends after the embargo**:
   - If the epoch starts before the embargo and the restriction policy is **closed**, the epoch is split at the embargo date:
     1. The restriction policy before the embargo is forced to **open**.
     2. The restriction policy after the embargo remains **closed**.
3. After processing, the program merges channels that are contiguous in time and have the same content.

---

## Usage

```bash
eida_embargo_roller [-i] [-e YYYY-MM-DD] station.xml
```
### Options:
- `-i`: Transform the `stationXML` file provided in place.
- `-e`: Embargo start date. All channels before this date will get unrestricted policy.

---

## Examples

### Writing a New XML File
Writing a new XML file for an embargo starting 2 years from now, on the 1 of january:
```bash
uv run eida_embargo_roller Z3.A190A.xml > result.xml
```

### Changing an existing XML file:
Transform the file in place:
```bash
uv run eida_embargo_roller -e 2025-01-01 -i Z3.A190A.xml
```

### Using Standard Input
Process an XML file from a remote source:
```bash
wget -qO- "ws.resif.fr/fdsnws/station/1/query?net=Z3&level=channel&sta=A190A" | uv run eida_embargo_roller - > result.xml
```
 
---

## Installation

### Using UV (Recommended)

### 1. Install uv

If uv is not already installed, you can add it by following [this guide](https://docs.astral.sh/uv/getting-started/installation/).


### 2. Sync Dependencies
Navigate to the project directory and run:
```bash
uv sync
```
This command will install all dependencies listed in `pyproject.toml`.

### 3. Run the Script
After syncing, use:
```bash
uv run eida_embargo_roller -e YYYY-MM-DD station.xml
```
#### **Rust and Cargo Requirement**

Certain dependencies (e.g., `pendulum`) require Rust and Cargo to build. If you encounter errors such as `maturin` failing due to missing Cargo, install Rust and Cargo by following the [official Rust installation guide](https://doc.rust-lang.org/cargo/getting-started/installation.html).
### As a Python Package
To install using pip:
```bash
python -m pip install --user eida_embargo_roller
```

### From Source
To install from source:
```bash
git clone https://github.com/your-repo/embargo-roller.git
cd embargo-roller

# Install dependencies using UV
uv sync

```
## **Tests and Debugging**

### Running Tests
To run the entire test suite using `pytest`, execute:
```bash
uv run pytest
```

### Debugging Specific Tests
To debug a specific test file (e.g., `test_processor.py`) and enable detailed logs:

```bash
uv run pytest -s tests/test_processor.py --log-cli-level=DEBUG
```

- **`--log-cli-level=DEBUG`**: Enables logging at the `DEBUG` level, showing detailed log messages.

#### Example Output
When debugging, you will see:
```
2024-06-17 12:00:00 - __main__ - DEBUG - Processing Channel: {'code': 'CH1', 'startDate': '2020-01-01T00:00:00'}
2024-06-17 12:00:00 - __main__ - DEBUG - Comparing with Previous Channel: {'code': 'CH1', 'endDate': '2020-06-01T00:00:00'}
2024-06-17 12:00:00 - __main__ - DEBUG - Channels merged successfully.
```

