﻿'''_1929.py

PowerFlowViewable
'''


from typing import List

from mastapy.system_model.analyses_and_results.power_flows import _3781, _3739
from mastapy._internal import constructor
from mastapy._internal.cast_exception import CastException
from mastapy import _0
from mastapy._internal.python_net import python_net_import

_POWER_FLOW_VIEWABLE = python_net_import('SMT.MastaAPI.SystemModel.Drawing', 'PowerFlowViewable')


__docformat__ = 'restructuredtext en'
__all__ = ('PowerFlowViewable',)


class PowerFlowViewable(_0.APIBase):
    '''PowerFlowViewable

    This is a mastapy class.
    '''

    TYPE = _POWER_FLOW_VIEWABLE

    __hash__ = None

    def __init__(self, instance_to_wrap: 'PowerFlowViewable.TYPE'):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def draw_style(self) -> '_3781.PowerFlowDrawStyle':
        '''PowerFlowDrawStyle: 'DrawStyle' is the original name of this property.

        Note:
            This property is readonly.
        '''

        if _3781.PowerFlowDrawStyle.TYPE not in self.wrapped.DrawStyle.__class__.__mro__:
            raise CastException('Failed to cast draw_style to PowerFlowDrawStyle. Expected: {}.'.format(self.wrapped.DrawStyle.__class__.__qualname__))

        return constructor.new_override(self.wrapped.DrawStyle.__class__)(self.wrapped.DrawStyle) if self.wrapped.DrawStyle else None

    @property
    def report_names(self) -> 'List[str]':
        '''List[str]: 'ReportNames' is the original name of this property.

        Note:
            This property is readonly.
        '''

        return self.wrapped.ReportNames

    def output_default_report_to(self, file_path: 'str'):
        ''' 'OutputDefaultReportTo' is the original name of this method.

        Args:
            file_path (str)
        '''

        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else None)

    def get_default_report_with_encoded_images(self) -> 'str':
        ''' 'GetDefaultReportWithEncodedImages' is the original name of this method.

        Returns:
            str
        '''

        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    def output_active_report_to(self, file_path: 'str'):
        ''' 'OutputActiveReportTo' is the original name of this method.

        Args:
            file_path (str)
        '''

        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else None)

    def output_active_report_as_text_to(self, file_path: 'str'):
        ''' 'OutputActiveReportAsTextTo' is the original name of this method.

        Args:
            file_path (str)
        '''

        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else None)

    def get_active_report_with_encoded_images(self) -> 'str':
        ''' 'GetActiveReportWithEncodedImages' is the original name of this method.

        Returns:
            str
        '''

        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    def output_named_report_to(self, report_name: 'str', file_path: 'str'):
        ''' 'OutputNamedReportTo' is the original name of this method.

        Args:
            report_name (str)
            file_path (str)
        '''

        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(report_name if report_name else None, file_path if file_path else None)

    def output_named_report_as_masta_report(self, report_name: 'str', file_path: 'str'):
        ''' 'OutputNamedReportAsMastaReport' is the original name of this method.

        Args:
            report_name (str)
            file_path (str)
        '''

        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(report_name if report_name else None, file_path if file_path else None)

    def output_named_report_as_text_to(self, report_name: 'str', file_path: 'str'):
        ''' 'OutputNamedReportAsTextTo' is the original name of this method.

        Args:
            report_name (str)
            file_path (str)
        '''

        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(report_name if report_name else None, file_path if file_path else None)

    def get_named_report_with_encoded_images(self, report_name: 'str') -> 'str':
        ''' 'GetNamedReportWithEncodedImages' is the original name of this method.

        Args:
            report_name (str)

        Returns:
            str
        '''

        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(report_name if report_name else None)
        return method_result
