import numpy

def beam3d_gen_Kl(A, E, G, Ixx, Iyy, Jv, L, alpha, fa, fby, fbz, k0a, k0b, rho, theta):
    return numpy.array([[A*E/L + (1/3)*L*k0a, 0, 0, 0, 0, 0, -A*E/L + (1/6)*L*k0a, 0, 0, 0, 0, 0], [0, 12*E*Iyy/L**3 + (13/35)*L*k0b, 0, 0, 0, (1/210)*(1260*E*Iyy + 11*L**4*k0b)/L**2, 0, -12*E*Iyy/L**3 + (9/70)*L*k0b, 0, 0, 0, (1/420)*(2520*E*Iyy - 13*L**4*k0b)/L**2], [0, 0, 12*E*Ixx/L**3 + (13/35)*L*k0b, 0, (1/210)*(-1260*E*Ixx - 11*L**4*k0b)/L**2, 0, 0, 0, -12*E*Ixx/L**3 + (9/70)*L*k0b, 0, (1/420)*(-2520*E*Ixx + 13*L**4*k0b)/L**2, 0], [0, 0, 0, G*Jv/L, 0, 0, 0, 0, 0, -G*Jv/L, 0, 0], [0, 0, (1/210)*(-1260*E*Ixx - 11*L**4*k0b)/L**2, 0, (1/105)*(420*E*Ixx + L**4*k0b)/L, 0, 0, 0, (1/420)*(2520*E*Ixx - 13*L**4*k0b)/L**2, 0, (1/140)*(280*E*Ixx - L**4*k0b)/L, 0], [0, (1/210)*(1260*E*Iyy + 11*L**4*k0b)/L**2, 0, 0, 0, (1/105)*(420*E*Iyy + L**4*k0b)/L, 0, (1/420)*(-2520*E*Iyy + 13*L**4*k0b)/L**2, 0, 0, 0, (1/140)*(280*E*Iyy - L**4*k0b)/L], [-A*E/L + (1/6)*L*k0a, 0, 0, 0, 0, 0, A*E/L + (1/3)*L*k0a, 0, 0, 0, 0, 0], [0, -12*E*Iyy/L**3 + (9/70)*L*k0b, 0, 0, 0, (1/420)*(-2520*E*Iyy + 13*L**4*k0b)/L**2, 0, 12*E*Iyy/L**3 + (13/35)*L*k0b, 0, 0, 0, (1/210)*(-1260*E*Iyy - 11*L**4*k0b)/L**2], [0, 0, -12*E*Ixx/L**3 + (9/70)*L*k0b, 0, (1/420)*(2520*E*Ixx - 13*L**4*k0b)/L**2, 0, 0, 0, 12*E*Ixx/L**3 + (13/35)*L*k0b, 0, (1/210)*(1260*E*Ixx + 11*L**4*k0b)/L**2, 0], [0, 0, 0, -G*Jv/L, 0, 0, 0, 0, 0, G*Jv/L, 0, 0], [0, 0, (1/420)*(-2520*E*Ixx + 13*L**4*k0b)/L**2, 0, (1/140)*(280*E*Ixx - L**4*k0b)/L, 0, 0, 0, (1/210)*(1260*E*Ixx + 11*L**4*k0b)/L**2, 0, (1/105)*(420*E*Ixx + L**4*k0b)/L, 0], [0, (1/420)*(2520*E*Iyy - 13*L**4*k0b)/L**2, 0, 0, 0, (1/140)*(280*E*Iyy - L**4*k0b)/L, 0, (1/210)*(-1260*E*Iyy - 11*L**4*k0b)/L**2, 0, 0, 0, (1/105)*(420*E*Iyy + L**4*k0b)/L]])

def beam3d_gen_Ml(A, E, G, Ixx, Iyy, Jv, L, alpha, fa, fby, fbz, k0a, k0b, rho, theta):
    return numpy.array([[(1/3)*A*L*rho, 0, 0, 0, 0, 0, (1/6)*A*L*rho, 0, 0, 0, 0, 0], [0, (1/35)*rho*(13*A*L**2 + 42*Iyy)/L, 0, 0, 0, (1/210)*rho*(11*A*L**2 + 21*Iyy), 0, (3/70)*rho*(3*A*L**2 - 28*Iyy)/L, 0, 0, 0, (1/420)*rho*(-13*A*L**2 + 42*Iyy)], [0, 0, (1/35)*rho*(13*A*L**2 + 42*Ixx)/L, 0, -1/210*rho*(11*A*L**2 + 21*Ixx), 0, 0, 0, (3/70)*rho*(3*A*L**2 - 28*Ixx)/L, 0, (1/420)*rho*(13*A*L**2 - 42*Ixx), 0], [0, 0, 0, (1/3)*Jv*L*rho, 0, 0, 0, 0, 0, (1/6)*Jv*L*rho, 0, 0], [0, 0, -1/210*rho*(11*A*L**2 + 21*Ixx), 0, (1/105)*L*rho*(A*L**2 + 14*Ixx), 0, 0, 0, (1/420)*rho*(-13*A*L**2 + 42*Ixx), 0, -1/420*L*rho*(3*A*L**2 + 14*Ixx), 0], [0, (1/210)*rho*(11*A*L**2 + 21*Iyy), 0, 0, 0, (1/105)*L*rho*(A*L**2 + 14*Iyy), 0, (1/420)*rho*(13*A*L**2 - 42*Iyy), 0, 0, 0, -1/420*L*rho*(3*A*L**2 + 14*Iyy)], [(1/6)*A*L*rho, 0, 0, 0, 0, 0, (1/3)*A*L*rho, 0, 0, 0, 0, 0], [0, (3/70)*rho*(3*A*L**2 - 28*Iyy)/L, 0, 0, 0, (1/420)*rho*(13*A*L**2 - 42*Iyy), 0, (1/35)*rho*(13*A*L**2 + 42*Iyy)/L, 0, 0, 0, -1/210*rho*(11*A*L**2 + 21*Iyy)], [0, 0, (3/70)*rho*(3*A*L**2 - 28*Ixx)/L, 0, (1/420)*rho*(-13*A*L**2 + 42*Ixx), 0, 0, 0, (1/35)*rho*(13*A*L**2 + 42*Ixx)/L, 0, (1/210)*rho*(11*A*L**2 + 21*Ixx), 0], [0, 0, 0, (1/6)*Jv*L*rho, 0, 0, 0, 0, 0, (1/3)*Jv*L*rho, 0, 0], [0, 0, (1/420)*rho*(13*A*L**2 - 42*Ixx), 0, -1/420*L*rho*(3*A*L**2 + 14*Ixx), 0, 0, 0, (1/210)*rho*(11*A*L**2 + 21*Ixx), 0, (1/105)*L*rho*(A*L**2 + 14*Ixx), 0], [0, (1/420)*rho*(-13*A*L**2 + 42*Iyy), 0, 0, 0, -1/420*L*rho*(3*A*L**2 + 14*Iyy), 0, -1/210*rho*(11*A*L**2 + 21*Iyy), 0, 0, 0, (1/105)*L*rho*(A*L**2 + 14*Iyy)]])

def beam3d_gen_rl(A, E, G, Ixx, Iyy, Jv, L, alpha, fa, fby, fbz, k0a, k0b, rho, theta):
    return numpy.array([[-A*E*alpha*theta + (1/2)*L*fa], [(1/2)*L*fby], [(1/2)*L*fbz], [0], [-1/12*L**2*fbz], [(1/12)*L**2*fby], [A*E*alpha*theta + (1/2)*L*fa], [(1/2)*L*fby], [(1/2)*L*fbz], [0], [(1/12)*L**2*fbz], [-1/12*L**2*fby]])

def beam3d_gen_Nl(A, E, G, Ixx, Iyy, Jv, L, alpha, fa, fby, fbz, k0a, k0b, rho, theta):
    return numpy.array([[1/2, 0, 0, 0, 0, 0, 1/2, 0, 0, 0, 0, 0], [0, 1/2, 0, 0, 0, (1/8)*L, 0, 1/2, 0, 0, 0, -1/8*L], [0, 0, 1/2, 0, -1/8*L, 0, 0, 0, 1/2, 0, (1/8)*L, 0]])

def beam3d_gen_Bl(A, E, G, Ixx, Iyy, Jv, L, alpha, fa, fby, fbz, k0a, k0b, rho, theta):
    return numpy.array([[-1/L, 0, 0, 0, 0, 0, L**(-1.0), 0, 0, 0, 0, 0], [0, 0, 0, 0, L**(-1.0), -1/L, 0, 0, 0, 0, -1/L, L**(-1.0)], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]])

def beam3d_gen_Dcs_mid(A, E, G, Ixx, Iyy, Jv, L, alpha, fa, fby, fbz, k0a, k0b, rho, theta):
    return numpy.array([[A*E, 0, 0], [0, E*Iyy, 0], [0, 0, E*Ixx]])

