import numpy

def plate_N(s, t):
    return numpy.array([[(1/4)*(s - 1)*(t - 1), 0, 0, -1/4*(s + 1)*(t - 1), 0, 0, (1/4)*(s + 1)*(t + 1), 0, 0, -1/4*(s - 1)*(t + 1), 0, 0], [0, (1/4)*(s - 1)*(t - 1), 0, 0, -1/4*(s + 1)*(t - 1), 0, 0, (1/4)*(s + 1)*(t + 1), 0, 0, -1/4*(s - 1)*(t + 1), 0], [0, 0, (1/4)*(s - 1)*(t - 1), 0, 0, -1/4*(s + 1)*(t - 1), 0, 0, (1/4)*(s + 1)*(t + 1), 0, 0, -1/4*(s - 1)*(t + 1)]])

def plate_Bb(s, t):
    return numpy.array([[0, (1/4)*t - 1/4, 0, 0, 1/4 - 1/4*t, 0, 0, (1/4)*t + 1/4, 0, 0, -1/4*t - 1/4, 0], [0, (1/4)*s - 1/4, 0, 0, -1/4*s - 1/4, 0, 0, (1/4)*s + 1/4, 0, 0, 1/4 - 1/4*s, 0], [0, 0, (1/4)*t - 1/4, 0, 0, 1/4 - 1/4*t, 0, 0, (1/4)*t + 1/4, 0, 0, -1/4*t - 1/4], [0, 0, (1/4)*s - 1/4, 0, 0, -1/4*s - 1/4, 0, 0, (1/4)*s + 1/4, 0, 0, 1/4 - 1/4*s]])

def plate_Db(E, nu):
    return numpy.array([[E*(nu - 1)/(2*nu**2 + nu - 1), -E*nu/(2*nu**2 + nu - 1), 0], [-E*nu/(2*nu**2 + nu - 1), E*(nu - 1)/(2*nu**2 + nu - 1), 0], [0, 0, (1/2)*E/(nu + 1)]])

def plate_Ds(E, nu):
    return numpy.array([[(1/2)*E/(nu + 1), 0], [0, (1/2)*E/(nu + 1)]])

def plate_Bs1(s, t):
    return numpy.array([[0, -1/4*(s - 1)*(t - 1), 0, 0, (1/4)*(s + 1)*(t - 1), 0, 0, -1/4*(s + 1)*(t + 1), 0, 0, (1/4)*(s - 1)*(t + 1), 0], [0, 0, -1/4*(s - 1)*(t - 1), 0, 0, (1/4)*(s + 1)*(t - 1), 0, 0, -1/4*(s + 1)*(t + 1), 0, 0, (1/4)*(s - 1)*(t + 1)]])

def plate_Bs2(s, t):
    return numpy.array([[(1/4)*t - 1/4, 0, 0, 1/4 - 1/4*t, 0, 0, (1/4)*t + 1/4, 0, 0, -1/4*t - 1/4, 0, 0], [(1/4)*s - 1/4, 0, 0, -1/4*s - 1/4, 0, 0, (1/4)*s + 1/4, 0, 0, 1/4 - 1/4*s, 0, 0]])

def plate_Jac(s, t, xe):
    return numpy.array([[(xe[:, :1].T).dot(numpy.array([[(1/4)*t - 1/4], [1/4 - 1/4*t], [(1/4)*t + 1/4], [-1/4*t - 1/4]])), (xe[:, 1:].T).dot(numpy.array([[(1/4)*t - 1/4], [1/4 - 1/4*t], [(1/4)*t + 1/4], [-1/4*t - 1/4]]))], [(xe[:, :1].T).dot(numpy.array([[(1/4)*s - 1/4], [-1/4*s - 1/4], [(1/4)*s + 1/4], [1/4 - 1/4*s]])), (xe[:, 1:].T).dot(numpy.array([[(1/4)*s - 1/4], [-1/4*s - 1/4], [(1/4)*s + 1/4], [1/4 - 1/4*s]]))]])

