import numpy

def solid_phi(s, t):
    return [(1/4)*(s - 1)*(t - 1), -1/4*(s + 1)*(t - 1), (1/4)*(s + 1)*(t + 1), -1/4*(s - 1)*(t + 1)]

def solid_N(s, t):
    return numpy.array([[(1/4)*(s - 1)*(t - 1), 0, -1/4*(s + 1)*(t - 1), 0, (1/4)*(s + 1)*(t + 1), 0, -1/4*(s - 1)*(t + 1), 0], [0, (1/4)*(s - 1)*(t - 1), 0, -1/4*(s + 1)*(t - 1), 0, (1/4)*(s + 1)*(t + 1), 0, -1/4*(s - 1)*(t + 1)]])

def solid_B(s, t):
    return numpy.array([[(1/4)*t - 1/4, 0, 1/4 - 1/4*t, 0, (1/4)*t + 1/4, 0, -1/4*t - 1/4, 0], [(1/4)*s - 1/4, 0, -1/4*s - 1/4, 0, (1/4)*s + 1/4, 0, 1/4 - 1/4*s, 0], [0, (1/4)*t - 1/4, 0, 1/4 - 1/4*t, 0, (1/4)*t + 1/4, 0, -1/4*t - 1/4], [0, (1/4)*s - 1/4, 0, -1/4*s - 1/4, 0, (1/4)*s + 1/4, 0, 1/4 - 1/4*s]])

def solid_Dax(E, nu):
    return numpy.array([[E*(nu - 1)/(2*nu**2 + nu - 1), -E*nu/(2*nu**2 + nu - 1), -E*nu/(2*nu**2 + nu - 1), 0], [-E*nu/(2*nu**2 + nu - 1), E*(nu - 1)/(2*nu**2 + nu - 1), -E*nu/(2*nu**2 + nu - 1), 0], [-E*nu/(2*nu**2 + nu - 1), -E*nu/(2*nu**2 + nu - 1), E*(nu - 1)/(2*nu**2 + nu - 1), 0], [0, 0, 0, (1/2)*E/(nu + 1)]])

def solid_Dpe(E, nu):
    return numpy.array([[E*(nu - 1)/(2*nu**2 + nu - 1), -E*nu/(2*nu**2 + nu - 1), 0], [-E*nu/(2*nu**2 + nu - 1), E*(nu - 1)/(2*nu**2 + nu - 1), 0], [0, 0, (1/2)*E/(nu + 1)]])

def solid_Dps(E, nu):
    return numpy.array([[-E/(nu**2 - 1), -E*nu/(nu**2 - 1), 0], [-E*nu/(nu**2 - 1), -E/(nu**2 - 1), 0], [0, 0, (1/2)*E/(nu + 1)]])

def solid_Jac(s, t, xe):
    return numpy.array([[(xe[:, :1].T).dot(numpy.array([[(1/4)*t - 1/4], [1/4 - 1/4*t], [(1/4)*t + 1/4], [-1/4*t - 1/4]])), (xe[:, 1:].T).dot(numpy.array([[(1/4)*t - 1/4], [1/4 - 1/4*t], [(1/4)*t + 1/4], [-1/4*t - 1/4]]))], [(xe[:, :1].T).dot(numpy.array([[(1/4)*s - 1/4], [-1/4*s - 1/4], [(1/4)*s + 1/4], [1/4 - 1/4*s]])), (xe[:, 1:].T).dot(numpy.array([[(1/4)*s - 1/4], [-1/4*s - 1/4], [(1/4)*s + 1/4], [1/4 - 1/4*s]]))]])

