/* DO NOT MODIFY: this is automatically generated by the cpptypes */

#include <cstring>
#include <stdexcept>
#include <cstdint>

#ifdef _WIN32
#define PYAPI __declspec(dllexport)
#else
#define PYAPI
#endif

static char* copy_error_message(const char* original) {
    auto n = std::strlen(original);
    auto copy = new char[n + 1];
    std::strcpy(copy, original);
    return copy;
}

uint8_t fetch_csv_booleans(void*, int32_t, uint8_t*, uint8_t);

uint8_t fetch_csv_numbers(void*, int32_t, double*, uint8_t*, uint8_t);

void fetch_csv_strings(void*, int32_t, char*, uint8_t);

void free_csv(void*);

void get_csv_column_stats(void*, int32_t, int32_t*, int32_t*, int32_t*);

int32_t get_csv_num_fields(void*);

int32_t get_csv_num_records(void*);

uint8_t get_csv_string_stats(void*, int32_t, int32_t*, uint8_t*);

void* load_csv(const char*);

void validate_csv(const char*);

extern "C" {

PYAPI void free_error_message(char** msg) {
    delete [] *msg;
}

PYAPI uint8_t py_fetch_csv_booleans(void* ptr, int32_t column, uint8_t* contents, uint8_t pop, int32_t* errcode, char** errmsg) {
    uint8_t output = 0;
    try {
        output = fetch_csv_booleans(ptr, column, contents, pop);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
    return output;
}

PYAPI uint8_t py_fetch_csv_numbers(void* ptr, int32_t column, double* contents, uint8_t* mask, uint8_t pop, int32_t* errcode, char** errmsg) {
    uint8_t output = 0;
    try {
        output = fetch_csv_numbers(ptr, column, contents, mask, pop);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
    return output;
}

PYAPI void py_fetch_csv_strings(void* ptr, int32_t column, char* contents, uint8_t pop, int32_t* errcode, char** errmsg) {
    try {
        fetch_csv_strings(ptr, column, contents, pop);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
}

PYAPI void py_free_csv(void* ptr, int32_t* errcode, char** errmsg) {
    try {
        free_csv(ptr);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
}

PYAPI void py_get_csv_column_stats(void* ptr, int32_t column, int32_t* type, int32_t* size, int32_t* loaded, int32_t* errcode, char** errmsg) {
    try {
        get_csv_column_stats(ptr, column, type, size, loaded);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
}

PYAPI int32_t py_get_csv_num_fields(void* ptr, int32_t* errcode, char** errmsg) {
    int32_t output = 0;
    try {
        output = get_csv_num_fields(ptr);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
    return output;
}

PYAPI int32_t py_get_csv_num_records(void* ptr, int32_t* errcode, char** errmsg) {
    int32_t output = 0;
    try {
        output = get_csv_num_records(ptr);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
    return output;
}

PYAPI uint8_t py_get_csv_string_stats(void* ptr, int32_t column, int32_t* lengths, uint8_t* mask, int32_t* errcode, char** errmsg) {
    uint8_t output = 0;
    try {
        output = get_csv_string_stats(ptr, column, lengths, mask);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
    return output;
}

PYAPI void* py_load_csv(const char* path, int32_t* errcode, char** errmsg) {
    void* output = NULL;
    try {
        output = load_csv(path);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
    return output;
}

PYAPI void py_validate_csv(const char* path, int32_t* errcode, char** errmsg) {
    try {
        validate_csv(path);
    } catch(std::exception& e) {
        *errcode = 1;
        *errmsg = copy_error_message(e.what());
    } catch(...) {
        *errcode = 1;
        *errmsg = copy_error_message("unknown C++ exception");
    }
}

}
