# generated by datamodel-codegen:
#   filename:  api/classification/createClassification.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReferenceList


class CreateClassificationRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: basic.EntityName
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this classification.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the classification.')
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            False,
            description='Tags under this classification are mutually exclusive. When mutually exclusive is `true` the tags from this classification are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this classification are used to **categorize** an entity. An entity can be in multiple categories simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
        ),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Classification belongs to.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this classification term.'),
    ]
