# generated by datamodel-codegen:
#   filename:  api/createType.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity import type
from ..type import basic


class CreateType(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        type.EntityName, Field(description='Unique name that identifies a Type.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Type.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Optional description of the type.')
    ]
    nameSpace: Annotated[
        str, Field(description='Namespace or group to which this type belongs to.')
    ]
    category: Optional[type.Category] = None
    schema_: Annotated[
        basic.JsonSchema,
        Field(
            alias='schema',
            description='JSON schema encoded as string. This will be used to validate the type values.',
        ),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Type belongs to.',
        ),
    ]
