# generated by datamodel-codegen:
#   filename:  api/docStore/createDocument.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.docStore import document
from ...type import basic


class CreateDocumentRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[basic.EntityName, Field(description='Name of the DocStore')]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this column name.'),
    ]
    fullyQualifiedName: basic.FullyQualifiedEntityName
    description: Annotated[
        Optional[str], Field(None, description='Description of the DocStore Entity.')
    ]
    entityType: Annotated[
        str, Field(description='Type of the Entity stored in DocStore.')
    ]
    data: document.Data
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Document belongs to.',
        ),
    ]
