# generated by datamodel-codegen:
#   filename:  api/tests/createTestSuite.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReference, entityReferenceList, tagLabel


class TestSuiteEntityName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Name of a test suite entity. For executable testSuite, this should match the entity FQN in the platform.',
            max_length=256,
            min_length=1,
        ),
    ]


class CreateTestSuiteRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        TestSuiteEntityName, Field(description='Name that identifies this test suite.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test suite.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the test suite.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this test suite'),
    ]
    basicEntityReference: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Entity reference the test suite needs to execute the test against. Only applicable if the test suite is basic.',
        ),
    ]
    executableEntityReference: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description="DEPRECATED in 1.6.2: use 'basicEntityReference'"),
    ]
    dataContract: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to the data contract that this test suite is associated with.',
        ),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Test Suite belongs to.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this TestSuite'),
    ]
