# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automatorAppConfig.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .automator import (
    addCustomProperties,
    addDataProductAction,
    addDescriptionAction,
    addDomainAction,
    addOwnerAction,
    addTagsAction,
    addTermsAction,
    addTestCaseAction,
    addTierAction,
    lineagePropagationAction,
    mlTaggingAction,
    removeCustomPropertiesAction,
    removeDataProductAction,
    removeDescriptionAction,
    removeDomainAction,
    removeOwnerAction,
    removeTagsAction,
    removeTermsAction,
    removeTestCaseAction,
    removeTierAction,
)


class AutomatorAppType(Enum):
    Automator = 'Automator'


class Resource(BaseModel):
    type: Annotated[
        Optional[List[str]],
        Field(None, description="Type of the entity. E.g., 'table', 'chart',..."),
    ]
    queryFilter: Annotated[
        Optional[str],
        Field(
            None,
            description='Query filter to be passed to ES. E.g., `{"query":{"bool":{"must":[{"bool":{"should":[{"term":{"domain.displayName.keyword":"DG Anim"}}]}}]}}}`. This is the same payload as in the Explore page.',
        ),
    ]
    filterJsonTree: Annotated[
        Optional[str],
        Field(
            None,
            description='Filter JSON tree to be used for rendering the filters in the UI. This comes from Immutable Tree type of react-awesome-query-builder.',
        ),
    ]


class Action(
    RootModel[
        Union[
            addTagsAction.AddTagsAction,
            removeTagsAction.RemoveTagsAction,
            addTermsAction.AddTermsAction,
            removeTermsAction.RemoveTermsAction,
            addDomainAction.AddDomainAction,
            removeDomainAction.RemoveDomainAction,
            addDescriptionAction.AddDescriptionAction,
            addCustomProperties.AddCustomPropertiesAction,
            removeDescriptionAction.RemoveDescriptionAction,
            addTierAction.AddTierAction,
            removeTierAction.RemoveTierAction,
            addTestCaseAction.AddTestCaseAction,
            removeTestCaseAction.RemoveTestCaseAction,
            addOwnerAction.AddOwnerAction,
            removeOwnerAction.RemoveOwnerAction,
            removeCustomPropertiesAction.RemoveCustomPropertiesAction,
            addDataProductAction.AddDataProductAction,
            removeDataProductAction.RemoveDataProductAction,
            lineagePropagationAction.LineagePropagationAction,
            mlTaggingAction.MLTaggingAction,
        ]
    ]
):
    root: Annotated[
        Union[
            addTagsAction.AddTagsAction,
            removeTagsAction.RemoveTagsAction,
            addTermsAction.AddTermsAction,
            removeTermsAction.RemoveTermsAction,
            addDomainAction.AddDomainAction,
            removeDomainAction.RemoveDomainAction,
            addDescriptionAction.AddDescriptionAction,
            addCustomProperties.AddCustomPropertiesAction,
            removeDescriptionAction.RemoveDescriptionAction,
            addTierAction.AddTierAction,
            removeTierAction.RemoveTierAction,
            addTestCaseAction.AddTestCaseAction,
            removeTestCaseAction.RemoveTestCaseAction,
            addOwnerAction.AddOwnerAction,
            removeOwnerAction.RemoveOwnerAction,
            removeCustomPropertiesAction.RemoveCustomPropertiesAction,
            addDataProductAction.AddDataProductAction,
            removeDataProductAction.RemoveDataProductAction,
            lineagePropagationAction.LineagePropagationAction,
            mlTaggingAction.MLTaggingAction,
        ],
        Field(
            description='Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.'
        ),
    ]


class AutomatorAppConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        AutomatorAppType,
        Field(description='Application Type', title='Application Type'),
    ]
    resources: Annotated[
        Resource, Field(description='Entities selected to run the automation.')
    ]
    actions: Annotated[
        List[Action],
        Field(
            description='Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.'
        ),
    ]
