# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/metadataExporterAppConfig.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .metadataExporterConnectors import databricksConnection, snowflakeConnection


class EventType(Enum):
    PROFILE = 'PROFILE'
    TEST_CASE_RESULTS = 'TEST_CASE_RESULTS'


class MetadataExporterAppType(Enum):
    MetadataExporter = 'MetadataExporter'


class RangeType(Enum):
    ALL = 'ALL'
    LATEST = 'LATEST'
    DATE_RANGE = 'DATE_RANGE'


class Unit(Enum):
    DAYS = 'DAYS'
    HOURS = 'HOURS'


class ExportRangeConfig(BaseModel):
    rangeType: Annotated[RangeType, Field(description='Type of range for data export.')]
    interval: Annotated[
        Optional[int],
        Field(
            None,
            description="Interval for the export range, applicable when rangeType is 'DATE_RANGE'.",
        ),
    ]
    unit: Annotated[
        Optional[Unit], Field(None, description='Unit of time for the export range.')
    ]


class TableConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    databaseName: str
    schemaName: str
    tableName: str


class MetadataExporterAppConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MetadataExporterAppType],
        Field(
            MetadataExporterAppType.MetadataExporter,
            description='Application Type',
            title='Application Type',
        ),
    ]
    connectionConfig: Annotated[
        Union[
            snowflakeConnection.SnowflakeConnection,
            databricksConnection.DatabricksConnection,
        ],
        Field(description='Connection details for the Metadata Exporter Application.'),
    ]
    exportRange: Annotated[
        ExportRangeConfig,
        Field(
            description="Range of data to export. Options are 'ALL' for all data, 'LATEST' for the latest data, or a specific date range."
        ),
    ]
    eventTypes: Annotated[
        Optional[List[EventType]],
        Field(
            [EventType.PROFILE, EventType.TEST_CASE_RESULTS],
            description='List of event types to export.',
        ),
    ]
    backfill: Annotated[
        Optional[bool],
        Field(
            False,
            description='Enable backfill for the exporter to process historical data. This will only work on the very first run of the exporter.',
        ),
    ]
    tableConfiguration: Annotated[
        TableConfig,
        Field(description='Configuration for the table to export the data to.'),
    ]
