# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/metadataExporterConnectors/bigQueryConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......security.credentials import gcpCredentials
from .....services.connections import connectionBasicType


class BigqueryType(Enum):
    BigQuery = 'BigQuery'


class BigqueryScheme(Enum):
    bigquery = 'bigquery'


class BigQueryConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[BigqueryType],
        Field(BigqueryType.BigQuery, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[BigqueryScheme],
        Field(
            BigqueryScheme.bigquery,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    hostPort: Annotated[
        Optional[str],
        Field(
            'bigquery.googleapis.com',
            description='BigQuery APIs URL.',
            title='Host and Port',
        ),
    ]
    billingProjectId: Annotated[
        Optional[str],
        Field(None, description='Billing Project ID', title='Billing Project ID'),
    ]
    credentials: Annotated[
        gcpCredentials.GCPCredentials,
        Field(description='GCP Credentials', title='GCP Credentials'),
    ]
    taxonomyProjectID: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Project IDs used to fetch policy tags',
            title='Taxonomy Project IDs',
        ),
    ]
    taxonomyLocation: Annotated[
        Optional[str],
        Field(
            'us',
            description='Taxonomy location used to fetch policy tags',
            title='Taxonomy Location',
        ),
    ]
    usageLocation: Annotated[
        Optional[str],
        Field(
            'us',
            description='Location used to query INFORMATION_SCHEMA.JOBS_BY_PROJECT to fetch usage data. You can pass multi-regions, such as `us` or `eu`, or you specific region. Australia and Asia multi-regions are not yet in GA.',
            title='Usage Location',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
