# generated by datamodel-codegen:
#   filename:  entity/automations/workflow.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...metadataIngestion import reverseIngestionPipeline
from ...type import basic, entityHistory, entityReferenceList
from ..services.connections import testConnectionResult
from ..services.connections.metadata import openMetadataConnection
from ..services.ingestionPipelines import reverseIngestionResponse
from . import testServiceConnection


class WorkflowType(Enum):
    TEST_CONNECTION = 'TEST_CONNECTION'
    REVERSE_INGESTION = 'REVERSE_INGESTION'


class WorkflowStatus(Enum):
    Pending = 'Pending'
    Successful = 'Successful'
    Failed = 'Failed'
    Running = 'Running'


class Workflow(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this workflow instance.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the workflow.')]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this workflow definition.'
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the test connection def.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    workflowType: Annotated[WorkflowType, Field(description='Type of the workflow.')]
    status: Annotated[
        Optional[WorkflowStatus],
        Field(WorkflowStatus.Pending, description='Workflow computation status.'),
    ]
    request: Annotated[
        Union[
            testServiceConnection.TestServiceConnectionRequest,
            reverseIngestionPipeline.ReverseIngestionPipeline,
        ],
        Field(description='Request body for a specific workflow type'),
    ]
    response: Annotated[
        Optional[
            Union[
                testConnectionResult.TestConnectionResult,
                reverseIngestionResponse.ReverseIngestionResponse,
            ]
        ],
        Field(None, description='Response to the request.'),
    ]
    openMetadataServerConnection: Optional[
        openMetadataConnection.OpenMetadataConnection
    ] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this workflow.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
