# generated by datamodel-codegen:
#   filename:  entity/data/queryCostSearchResult.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class QueryDetails(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    query: Annotated[
        Optional[Dict[str, Any]], Field(None, description='Query information')
    ]


class QueryGroup(BaseModel):
    queryText: Annotated[str, Field(description='The text of the query')]
    users: Annotated[
        List[str], Field(description='List of users who executed the query')
    ]
    totalCost: Annotated[float, Field(description='Total cost of all query executions')]
    totalCount: Annotated[int, Field(description='Total number of query executions')]
    totalDuration: Annotated[
        float, Field(description='Total duration of all query executions')
    ]
    avgDuration: Annotated[
        float, Field(description='Average duration per query execution')
    ]
    queryDetails: Annotated[QueryDetails, Field(description='Additional query details')]


class OverallStats(BaseModel):
    totalCost: Annotated[float, Field(description='Total cost across all queries')]
    minCost: Annotated[float, Field(description='Minimum cost among all queries')]
    maxCost: Annotated[float, Field(description='Maximum cost among all queries')]
    avgCost: Annotated[float, Field(description='Average cost across all queries')]
    totalExecutionCount: Annotated[
        int, Field(description='Total number of query executions')
    ]


class QueryCostSearchResult(BaseModel):
    queryGroups: Annotated[
        List[QueryGroup], Field(description='List of query groups with their metrics')
    ]
    overallStats: Annotated[
        OverallStats, Field(description='Overall statistics across all queries')
    ]
