# generated by datamodel-codegen:
#   filename:  entity/datacontract/dataContractResult.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, contractExecutionStatus
from . import qualityValidation, schemaValidation, semanticsValidation, slaValidation


class DataContractResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Unique Data Contract validation execution identifier of this data contract result instance.',
        ),
    ]
    dataContractFQN: Annotated[
        basic.FullyQualifiedEntityName,
        Field(description='Fully qualified name of the data contract.'),
    ]
    timestamp: Annotated[
        basic.Timestamp,
        Field(description='Timestamp when the data contract was executed.'),
    ]
    contractExecutionStatus: Annotated[
        contractExecutionStatus.ContractExecutionStatus,
        Field(description='Overall status of the contract execution.'),
    ]
    result: Annotated[
        Optional[str],
        Field(None, description='Detailed result of the data contract execution.'),
    ]
    schemaValidation: Annotated[
        Optional[schemaValidation.SchemaValidation],
        Field(None, description='Schema validation details.'),
    ]
    semanticsValidation: Annotated[
        Optional[semanticsValidation.SemanticsValidation],
        Field(None, description='Semantics validation details.'),
    ]
    qualityValidation: Annotated[
        Optional[qualityValidation.QualityValidation],
        Field(None, description='Quality expectations validation details.'),
    ]
    slaValidation: Annotated[
        Optional[slaValidation.SlaValidation],
        Field(None, description='SLA validation details.'),
    ]
    incidentId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Incident ID if the contract execution failed and an incident was created.',
        ),
    ]
    executionTime: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Time taken to execute the contract validation in milliseconds.',
        ),
    ]
