# generated by datamodel-codegen:
#   filename:  entity/feed/thread.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReference, entityReferenceList, reaction
from . import (
    assets,
    customProperty,
    description,
    domain,
    entityInfo,
    tag,
    testCaseResult,
)


class GeneratedBy(Enum):
    user = 'user'
    system = 'system'


class CardStyle(Enum):
    default = 'default'
    logicalTestCaseAdded = 'logicalTestCaseAdded'
    entityCreated = 'entityCreated'
    entityDeleted = 'entityDeleted'
    entitySoftDeleted = 'entitySoftDeleted'
    description = 'description'
    tags = 'tags'
    owner = 'owner'
    testCaseResult = 'testCaseResult'
    customProperties = 'customProperties'
    assets = 'assets'
    domain = 'domain'


class FieldOperation(Enum):
    added = 'added'
    updated = 'updated'
    deleted = 'deleted'
    none = 'none'


class TaskType(Enum):
    RequestDescription = 'RequestDescription'
    UpdateDescription = 'UpdateDescription'
    RequestTag = 'RequestTag'
    UpdateTag = 'UpdateTag'
    RequestApproval = 'RequestApproval'
    RequestTestCaseFailureResolution = 'RequestTestCaseFailureResolution'
    Generic = 'Generic'


class ThreadTaskStatus(Enum):
    Open = 'Open'
    Closed = 'Closed'


class ThreadType(Enum):
    Conversation = 'Conversation'
    Task = 'Task'
    Announcement = 'Announcement'
    Chatbot = 'Chatbot'


class AnnouncementDetails(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    description: Annotated[
        Optional[str],
        Field(
            None,
            description='Announcement description in Markdown format. See markdown support for more details.',
        ),
    ]
    startTime: Annotated[
        basic.Timestamp,
        Field(
            description='Timestamp of the start time from when the announcement should be shown.'
        ),
    ]
    endTime: Annotated[
        basic.Timestamp,
        Field(description='Timestamp of when the announcement should end'),
    ]


class ChatbotDetails(BaseModel):
    query: Annotated[
        Optional[str],
        Field(None, description='The query being discussed with the Chatbot'),
    ]


class TaskDetails(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[int, Field(description='Unique identifier that identifies the task.')]
    type: TaskType
    assignees: Annotated[
        entityReferenceList.EntityReferenceList,
        Field(description='List of users or teams the task is assigned to'),
    ]
    status: Optional[ThreadTaskStatus] = ThreadTaskStatus.Open
    closedBy: Annotated[
        Optional[str], Field(None, description='The user that closed the task.')
    ]
    closedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp when the task was closed in Unix epoch time milliseconds.',
        ),
    ]
    oldValue: Annotated[
        Optional[str],
        Field(
            None, description='The value of old object for which the task is created.'
        ),
    ]
    suggestion: Annotated[
        Optional[str],
        Field(
            None,
            description='The suggestion object to replace the old value for which the task is created.',
        ),
    ]
    newValue: Annotated[
        Optional[str],
        Field(
            None,
            description='The new value object that was accepted to complete the task.',
        ),
    ]
    testCaseResolutionStatusId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='The test case resolution status id for which the task is created.',
        ),
    ]


class Post(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier that identifies the post.')
    ]
    message: Annotated[
        str,
        Field(
            description='Message in Markdown format. See Markdown support for more details.'
        ),
    ]
    postTs: Annotated[
        Optional[basic.Timestamp],
        Field(
            None, description='Timestamp of the post in Unix epoch time milliseconds.'
        ),
    ]
    from_: Annotated[
        str, Field(alias='from', description='Name of the User posting the message.')
    ]
    reactions: Annotated[
        Optional[reaction.ReactionList],
        Field(None, description='Reactions for the post.'),
    ]


class FeedInfo(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    headerMessage: Annotated[
        Optional[str], Field(None, description='Header message for the feed.')
    ]
    fieldName: Annotated[
        Optional[str], Field(None, description='Field Name message for the feed.')
    ]
    entitySpecificInfo: Optional[
        Union[
            assets.AssetsFeedInfo,
            customProperty.CustomPropertyFeedInfo,
            description.DescriptionFeedInfo,
            domain.DomainFeedInfo,
            entityInfo.EntityInfo,
            tag.TagFeedInfo,
            testCaseResult.TestCaseResultFeedInfo,
        ]
    ] = None


class Thread(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies an entity instance.'),
    ]
    type: Optional[ThreadType] = ThreadType.Conversation
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    threadTs: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp of the first post created the thread in Unix epoch time milliseconds.',
        ),
    ]
    about: Annotated[
        basic.EntityLink,
        Field(
            description='Data asset about which this thread is created for with format <#E::{entities}::{entityName}::{field}::{fieldValue}.'
        ),
    ]
    entityRef: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to the entity in `about` that the thread belongs to.',
        ),
    ]
    entityUrlLink: Annotated[
        Optional[str],
        Field(
            None,
            description='Link to the entity in `about` that the thread belongs to.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.Uuid]],
        Field(None, description='Domain the entity belongs to.'),
    ]
    generatedBy: Annotated[
        Optional[GeneratedBy],
        Field(GeneratedBy.user, description='User or team that generated the thread.'),
    ]
    cardStyle: Annotated[
        Optional[CardStyle],
        Field(CardStyle.default, description='Card style for the thread.'),
    ]
    fieldOperation: Annotated[
        Optional[FieldOperation],
        Field(
            FieldOperation.updated,
            description='Operation on thread, whether the field was added, or updated or deleted.',
        ),
    ]
    feedInfo: Annotated[
        Optional[FeedInfo],
        Field(
            None,
            description='Entity Id of the entity in `about` that the thread belongs to.',
        ),
    ]
    addressedTo: Annotated[
        Optional[basic.EntityLink],
        Field(
            None,
            description='User or team this thread is addressed to in format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
        ),
    ]
    createdBy: Annotated[
        Optional[str], Field(None, description='User who created the thread.')
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    resolved: Annotated[
        Optional[bool],
        Field(False, description='When `true` indicates the thread has been resolved.'),
    ]
    message: Annotated[
        str, Field(description='The main message of the thread in Markdown format.')
    ]
    postsCount: Annotated[
        Optional[int], Field(0, description='The total count of posts in the thread.')
    ]
    posts: Optional[List[Post]] = None
    reactions: Annotated[
        Optional[reaction.ReactionList],
        Field(None, description='Reactions for the thread.'),
    ]
    task: Annotated[
        Optional[TaskDetails],
        Field(
            None,
            description='Details about the task. This is only applicable if thread is of type task.',
        ),
    ]
    announcement: Annotated[
        Optional[AnnouncementDetails],
        Field(
            None,
            description='Details about the announcement. This is only applicable if thread is of type announcement.',
        ),
    ]
    chatbot: Annotated[
        Optional[ChatbotDetails],
        Field(
            None,
            description='Details about the Chatbot conversation. This is only applicable if thread is of type Chatbot.',
        ),
    ]
