# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/powerBIConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType
from .powerbi import azureConfig, gcsConfig, s3Config


class PowerBiType(Enum):
    PowerBI = 'PowerBI'


class PbitFileConfigType(Enum):
    local = 'local'


class LocalConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    pbitFileConfigType: Annotated[
        Optional[PbitFileConfigType],
        Field(PbitFileConfigType.local, description='pbit File Configuration type'),
    ]
    path: Annotated[
        Optional[str],
        Field(None, description='Directory path for the pbit files', title='Path'),
    ]
    pbitFilesExtractDir: Annotated[
        Optional[str],
        Field(
            '/tmp/pbitFiles',
            description='Path of the folder where the .pbit files will be unzipped and datamodel schema will be extracted',
            title='pbit Files Extraction Directory',
        ),
    ]


class PowerBIConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[PowerBiType],
        Field(PowerBiType.PowerBI, description='Service Type', title='Service Type'),
    ]
    clientId: Annotated[
        str, Field(description='client_id for PowerBI.', title='Client ID')
    ]
    clientSecret: Annotated[
        CustomSecretStr,
        Field(description='clientSecret for PowerBI.', title='Client Secret'),
    ]
    tenantId: Annotated[
        str, Field(description='Tenant ID for PowerBI.', title='Tenant ID')
    ]
    authorityURI: Annotated[
        Optional[str],
        Field(
            'https://login.microsoftonline.com/',
            description='Authority URI for the PowerBI service.',
            title='Authority URI',
        ),
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            'https://app.powerbi.com',
            description='Dashboard URL for PowerBI service.',
            title='Host and Port',
        ),
    ]
    scope: Annotated[
        Optional[List[str]],
        Field(
            ['https://analysis.windows.net/powerbi/api/.default'],
            description='PowerBI secrets.',
            title='Scope',
        ),
    ]
    pagination_entity_per_page: Annotated[
        Optional[int],
        Field(
            100,
            description='Entity Limit set here will be used to paginate the PowerBi APIs',
            title='Pagination Entity Per Page',
        ),
    ]
    useAdminApis: Annotated[
        Optional[bool],
        Field(
            True,
            description='Fetch the PowerBI metadata using admin APIs',
            title='Use PowerBI Admin APIs',
        ),
    ]
    displayTableNameFromSource: Annotated[
        Optional[bool],
        Field(
            False,
            description='Display Table Name from source instead of renamed table name for datamodel tables',
            title='Display Table Name from source',
        ),
    ]
    pbitFilesSource: Annotated[
        Optional[
            Union[
                LocalConfig,
                azureConfig.AzureConfig,
                gcsConfig.GCSConfig,
                s3Config.S3Config,
            ]
        ],
        Field(
            None,
            description='Source to get the .pbit files to extract lineage information',
            title='PowerBI .pbit Files Source',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
