# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/datalakeConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType
from .datalake import azureConfig, gcsConfig, s3Config


class DatalakeType(Enum):
    Datalake = 'Datalake'


class LocalConfig(BaseModel):
    pass
    model_config = ConfigDict(
        extra='forbid',
    )


class DatalakeConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatalakeType],
        Field(DatalakeType.Datalake, description='Service Type', title='Service Type'),
    ]
    configSource: Annotated[
        Union[
            LocalConfig, azureConfig.AzureConfig, gcsConfig.GCSConfig, s3Config.S3Config
        ],
        Field(
            description='Available sources to fetch files.',
            title='DataLake Configuration Source',
        ),
    ]
    bucketName: Annotated[
        Optional[str],
        Field('', description='Bucket Name of the data source.', title='Bucket Name'),
    ]
    prefix: Annotated[
        Optional[str],
        Field('', description='Prefix of the data source.', title='Prefix'),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
