# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/epicConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType


class FhirVersion(Enum):
    R4 = 'R4'
    STU3 = 'STU3'
    DSTU2 = 'DSTU2'


class EpicType(Enum):
    Epic = 'Epic'


class EpicConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[EpicType],
        Field(EpicType.Epic, description='Service Type', title='Service Type'),
    ]
    fhirServerUrl: Annotated[
        Optional[AnyUrl],
        Field(
            'https://fhir.epic.com/interconnect-fhir-oauth/api/FHIR',
            description='Base URL of the Epic FHIR server',
            title='FHIR Server URL',
        ),
    ]
    fhirVersion: Annotated[
        Optional[FhirVersion],
        Field(
            FhirVersion.R4,
            description='FHIR specification version (R4, STU3, DSTU2)',
            title='FHIR Version',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            'epic',
            description="Optional name to give to the database in OpenMetadata. If left blank, we will use 'epic' as the database name.",
            title='Database Name',
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to include/exclude FHIR resource categories',
            title='Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to include/exclude FHIR resource types',
            title='Table Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
