# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/ssasConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class SSASType(Enum):
    SSAS = 'SSAS'


class SSASConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SSASType],
        Field(SSASType.SSAS, description='Service Type', title='Service Type'),
    ]
    httpConnection: Annotated[
        str,
        Field(
            description='HTTP Link for SSAS ACCESS', title='HTTP Link for SSAS ACCESS'
        ),
    ]
    username: Annotated[str, Field(description='Username', title='Username')]
    password: Annotated[
        CustomSecretStr, Field(description='Password', title='Password')
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsLineageExtraction: Annotated[
        Optional[connectionBasicType.SupportsLineageExtraction],
        Field(None, title='Supports Lineage Extraction'),
    ]
