# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/redpandaConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType
from . import saslMechanismType


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'
    SASL_PLAINTEXT = 'SASL_PLAINTEXT'
    SASL_SSL = 'SASL_SSL'
    SSL = 'SSL'


class RedpandaType(Enum):
    Redpanda = 'Redpanda'


class RedpandaConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[RedpandaType],
        Field(RedpandaType.Redpanda, description='Service Type', title='Service Type'),
    ]
    bootstrapServers: Annotated[
        str,
        Field(
            description='Redpanda bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092',
            title='Bootstrap Servers',
        ),
    ]
    schemaRegistryURL: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Confluent Redpanda Schema Registry URL.',
            title='Schema Registry URL',
        ),
    ]
    saslUsername: Annotated[
        Optional[str],
        Field(
            None,
            description='sasl.username consumer config property',
            title='SASL Username',
        ),
    ]
    saslPassword: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='sasl.password consumer config property',
            title='SASL Password',
        ),
    ]
    schemaRegistryTopicSuffixName: Annotated[
        Optional[str],
        Field(
            '-value',
            description='Schema Registry Topic Suffix Name. The suffix to be appended to the topic name to get topic schema from registry.',
            title='Schema Registry Topic Suffix Name',
        ),
    ]
    securityProtocol: Annotated[
        Optional[SecurityProtocol],
        Field(
            SecurityProtocol.PLAINTEXT,
            description='security.protocol consumer config property',
            title='Security Protocol',
        ),
    ]
    saslMechanism: Annotated[
        Optional[saslMechanismType.SaslMechanismType],
        Field(
            saslMechanismType.SaslMechanismType.PLAIN,
            description='sasl.mechanism Consumer Config property',
            title='SASL Mechanism',
        ),
    ]
    basicAuthUserInfo: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='basic.auth.user.info schema registry config property, Client HTTP credentials in the form of username:password.',
            title='Schema Registry Basic Auth User Info',
        ),
    ]
    consumerConfig: Annotated[
        Optional[Dict[str, Any]],
        Field(
            {},
            description='Confluent Redpanda Consumer Config',
            title='Consumer Config',
        ),
    ]
    schemaRegistryConfig: Annotated[
        Optional[Dict[str, Any]],
        Field(
            {},
            description='Confluent Redpanda Schema Registry Config.',
            title='Schema Registry Config',
        ),
    ]
    topicFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch topics that matches the pattern.',
            title='Default Topic Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
