# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/kafkaConnectConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class KafkaConnectType(Enum):
    KafkaConnect = 'KafkaConnect'


class BasicAuthentication(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='KafkaConnect user to authenticate to the API.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='KafkaConnect password to authenticate to the API.',
            title='Password',
        ),
    ]


class KafkaConnectConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[KafkaConnectType],
        Field(
            KafkaConnectType.KafkaConnect,
            description='Service Type',
            title='Service Type',
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='KafkaConnect Service Management/UI URI.', title='Host And Port'
        ),
    ]
    KafkaConnectConfig: Annotated[
        Optional[BasicAuthentication],
        Field(
            None,
            description='We support username/password or No Authentication',
            title='KafkaConnect Credentials Configuration',
        ),
    ]
    verifySSL: Annotated[
        Optional[bool],
        Field(
            True,
            description='Boolean marking if we need to verify the SSL certs for KafkaConnect REST API. True by default.',
            title='Verify SSL',
        ),
    ]
    messagingServiceName: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the Kafka Messaging Service associated with this KafkaConnect Pipeline Service. e.g. local_kafka',
            title='Kafka Service Name',
        ),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
