# generated by datamodel-codegen:
#   filename:  entity/services/ingestionPipelines/reverseIngestionResponse.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....type import basic


class ReverseIngestionOperationResult(BaseModel):
    id: Annotated[basic.Uuid, Field(description='The id of the operation')]
    success: Annotated[
        bool, Field(description='Whether the specific operation was successful')
    ]
    message: Annotated[
        Optional[str], Field(None, description='Error message in case of failure')
    ]


class ReverseIngestionResponse(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    serviceId: Annotated[
        basic.Uuid, Field(description='The id of the service to be modified')
    ]
    success: Annotated[
        Optional[bool],
        Field(
            None,
            description='Whether the workflow was successful. Failure indicates a critical failure such as connection issues.',
        ),
    ]
    message: Annotated[
        Optional[str], Field(None, description='Error message in case of failure')
    ]
    results: Annotated[
        List[ReverseIngestionOperationResult],
        Field(description='List of operations to be performed on the service'),
    ]
