# generated by datamodel-codegen:
#   filename:  events/testDestinationStatus.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic


class Status(Enum):
    Success = 'Success'
    Failed = 'Failed'


class TestDestinationStatus(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    status: Annotated[
        Optional[Status],
        Field(
            None,
            description='Overall test status, indicating if the test operation succeeded or failed.',
        ),
    ]
    reason: Annotated[
        Optional[str],
        Field(
            None, description='Detailed reason for failure if the test did not succeed.'
        ),
    ]
    statusCode: Annotated[
        Optional[int],
        Field(
            None,
            description='HTTP status code of the response (e.g., 200 for OK, 404 for Not Found).',
        ),
    ]
    statusInfo: Annotated[
        Optional[str],
        Field(
            None,
            description="HTTP status reason phrase associated with the status code (e.g., 'Not Found').",
        ),
    ]
    headers: Annotated[
        Optional[Any],
        Field(
            None,
            description='HTTP headers returned in the response as a map of header names to values.',
        ),
    ]
    entity: Annotated[
        Optional[str],
        Field(
            None,
            description='Body of the HTTP response, if any, returned by the server.',
        ),
    ]
    mediaType: Annotated[
        Optional[str],
        Field(
            None,
            description='Media type of the response entity, if specified (e.g., application/json).',
        ),
    ]
    location: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='URL location if the response indicates a redirect or newly created resource.',
        ),
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp when the response was received, in UNIX epoch time milliseconds.',
        ),
    ]
